/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.NodeModelDelegate;
import cerent.util.gui.UScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NsdWizardInfo {
    private String selNode = null;
    private String nodeName = null;
    private boolean ansSelected = false;
    private boolean passiveUnitsSelected = false;
    private boolean sidesSelected = false;
    private boolean ppmSelected = false;
    private boolean anpSelected = false;
    private boolean paramSelected = false;
    private boolean patchcordsSelected = false;
    private boolean quickProv = false;
    private ColorPane logArea = null;
    private CtmLog logCtm = null;
    private int errCnt = 0;
    private NodeModelDelegate nmd = null;
    private Vector<NodeStructure> shelves;
    private Vector<PUnitStructure> punits;
    private Vector<PpmStructure> ppms;
    private Vector<ParamStructure> params;
    private Vector<PatchcordsStructure> patchcords;
    private Vector<SidesStructure> sides;
    private Vector<AnsParamStructure> ans;
    private CenterRenderer centerRenderer;
    private File f = null;
    private FileOutputStream fOut = null;
    private PrintStream ps = null;
    private String[] nodesArray = new String[100];
    private String[] nodesVer = new String[100];
    private int nodeCnt = 0;
    private boolean isCtm;
    private String firstPane;
    private String lastPane;

    public NsdWizardInfo() {
        this.init();
    }

    public NsdWizardInfo(File file) {
        this();
        this.isCtm = false;
        this.firstPane = "";
        this.lastPane = "";
        this.logArea = new ColorPane();
        this.f = file;
        try {
            this.fOut = new FileOutputStream(this.f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.ps = new PrintStream(this.fOut);
    }

    public NsdWizardInfo(File file, boolean bl) {
        this();
        this.isCtm = bl;
        this.logCtm = new CtmLog();
        this.f = file;
        try {
            this.fOut = new FileOutputStream(this.f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.ps = new PrintStream(this.fOut);
    }

    public void init() {
        this.shelves = new Vector();
        this.punits = new Vector();
        this.ppms = new Vector();
        this.params = new Vector();
        this.patchcords = new Vector();
        this.sides = new Vector();
        this.ans = new Vector();
        this.centerRenderer = new CenterRenderer();
    }

    public String getCurrentTimeStamp() {
        String string = "yyyy/MM/dd HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        Date date = new Date();
        String string2 = simpleDateFormat.format(date);
        return string2;
    }

    public String getFirstPane() {
        return this.firstPane;
    }

    public void setFirstPane(String string) {
        this.firstPane = string;
    }

    public String getLastPane() {
        return this.lastPane;
    }

    public void setLastPane(String string) {
        this.lastPane = string;
    }

    public boolean isCtm() {
        return this.isCtm;
    }

    public PrintStream getLogPs() {
        return this.ps;
    }

    public CenterRenderer getCenterRenderer() {
        return this.centerRenderer;
    }

    public UScrollPane getLogAreaPane() {
        return new UScrollPane((Component)this.logArea);
    }

    public void logInfo(String string) {
        if (this.isCtm) {
            this.logCtm.append(string);
        } else {
            this.logArea.append(Color.BLUE, string);
        }
    }

    public void logError(String string) {
        if (this.isCtm) {
            this.logCtm.append(string);
        } else {
            this.logArea.append(Color.RED, string);
        }
        ++this.errCnt;
    }

    public int getErrCnt() {
        return this.errCnt;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public NodeModelDelegate getNmd() {
        return this.nmd;
    }

    public void setNmd(NodeModelDelegate nodeModelDelegate) {
        this.nmd = nodeModelDelegate;
    }

    public boolean isAnpPresent() {
        return this.shelves.size() > 0;
    }

    public boolean isPassiveUnitsPresent() {
        return this.punits.size() > 0;
    }

    public boolean isPpmPresent() {
        return this.ppms.size() > 0;
    }

    public boolean isAnsPresent() {
        return this.ans.size() > 0;
    }

    public boolean isPatchcordsPresent() {
        return this.patchcords.size() > 0;
    }

    public boolean isParamPresent() {
        return this.params.size() > 0;
    }

    public boolean isSidesPresent() {
        return this.sides.size() > 0;
    }

    public boolean isQuickProv() {
        return this.quickProv;
    }

    public void setQuickProv(boolean bl) {
        this.quickProv = bl;
    }

    public boolean isAnpSelected() {
        return this.anpSelected;
    }

    public boolean isPassiveUnitsSelected() {
        return this.passiveUnitsSelected;
    }

    public boolean isPpmSelected() {
        return this.ppmSelected;
    }

    public boolean isPatchcordsSelected() {
        return this.patchcordsSelected;
    }

    public boolean isAnsSelected() {
        return this.ansSelected;
    }

    public boolean isParamSelected() {
        return this.paramSelected;
    }

    public boolean isSidesSelected() {
        return this.sidesSelected;
    }

    public Vector<NodeStructure> getAnp() {
        return this.shelves;
    }

    public Vector<PUnitStructure> getPassiveUnits() {
        return this.punits;
    }

    public Vector<PpmStructure> getPpm() {
        return this.ppms;
    }

    public Vector<ParamStructure> getParams() {
        return this.params;
    }

    public Vector<PatchcordsStructure> getPatchcords() {
        return this.patchcords;
    }

    public Vector<SidesStructure> getSides() {
        return this.sides;
    }

    public Vector<AnsParamStructure> getAnsParameters() {
        return this.ans;
    }

    public void setAnpSelected(boolean bl) {
        this.anpSelected = bl;
    }

    public void setPassiveUnitsSelected(boolean bl) {
        this.passiveUnitsSelected = bl;
    }

    public void setPpmSelected(boolean bl) {
        this.ppmSelected = bl;
    }

    public void setPatchcordsSelected(boolean bl) {
        this.patchcordsSelected = bl;
    }

    public void setAnsSelected(boolean bl) {
        this.ansSelected = bl;
    }

    public void setParamSelected(boolean bl) {
        this.paramSelected = bl;
    }

    public void setSidesSelected(boolean bl) {
        this.sidesSelected = bl;
    }

    public String getSelNode() {
        return this.selNode;
    }

    public int getSelIndex() {
        int n = 0;
        for (int i = 0; i < this.nodesArray.length; ++i) {
            if (!this.nodesArray[i].equalsIgnoreCase(this.getSelNode())) continue;
            n = i;
            break;
        }
        return n;
    }

    public void setSelNode(String string) {
        this.selNode = string;
    }

    public void incNodeCnt() {
        ++this.nodeCnt;
    }

    public int getNodeCnt() {
        return this.nodeCnt;
    }

    public void setNodesArray(int n, String string) {
        this.nodesArray[n] = string;
    }

    public String[] getNodesArray() {
        return this.nodesArray;
    }

    public void setNodesVer(int n, String string) {
        this.nodesVer[n] = string;
    }

    public String[] getNodesVer() {
        return this.nodesVer;
    }

    public String getSingleNodeArray() {
        return this.nodesArray[0];
    }

    public String getSingleNodeArray(int n) {
        return this.nodesArray[n];
    }

    public void dump() {
        for (NodeStructure object : this.shelves) {
            System.out.println(object);
        }
        for (PUnitStructure pUnitStructure : this.punits) {
            System.out.println(pUnitStructure);
        }
        for (PpmStructure ppmStructure : this.ppms) {
            System.out.println(ppmStructure);
        }
        for (ParamStructure paramStructure : this.params) {
            System.out.println(paramStructure);
        }
        for (PatchcordsStructure patchcordsStructure : this.patchcords) {
            System.out.println(patchcordsStructure);
        }
        for (SidesStructure sidesStructure : this.sides) {
            System.out.println(sidesStructure);
        }
        for (AnsParamStructure ansParamStructure : this.ans) {
            System.out.println(ansParamStructure);
        }
    }

    public class AnsParamStructure {
        public String shelf;
        public String slot;
        public String port;
        public String wavelength;
        public String paramName;
        public String paramValue;

        public AnsParamStructure clone_value() {
            AnsParamStructure ansParamStructure = new AnsParamStructure();
            ansParamStructure.shelf = this.shelf;
            ansParamStructure.slot = this.slot;
            ansParamStructure.port = this.port;
            return ansParamStructure;
        }

        public String toString() {
            return "ANS Param: Shelf# " + this.shelf + ", slot# " + this.slot + ", port# " + this.port + ", wl=" + this.wavelength + ", name=" + this.paramName + ", value=" + this.paramValue;
        }
    }

    class CenterRenderer
    extends DefaultTableCellRenderer {
        public CenterRenderer() {
            this.setHorizontalAlignment(0);
        }
    }

    private class ColorPane
    extends JTextPane {
        public ColorPane() {
            this.setEditable(false);
        }

        public void append(Color color, String string) {
            StyleContext styleContext = StyleContext.getDefaultStyleContext();
            AttributeSet attributeSet = styleContext.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color);
            int n = this.getDocument().getLength();
            this.setCaretPosition(n);
            try {
                this.getDocument().insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            NsdWizardInfo.this.ps.println(string);
        }
    }

    private class CtmLog {
        public void append(String string) {
            NsdWizardInfo.this.ps.println(string);
        }
    }

    public class NodeStructure {
        public String shelf;
        public String shType;
        public String rackNum;
        public String rackPos;
        public String RUPos;
        public String RUSize;
        public Vector<String> slot = new Vector();
        public Vector<String> eqType = new Vector();

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("SHELF: #" + this.shelf + ", type=" + this.shType + " (num=" + this.rackNum + ", pos=" + this.rackPos + ", RU#=" + this.RUPos + ", RUSize=" + this.RUSize + ")");
            for (int i = 0; i < this.slot.size(); ++i) {
                stringBuilder.append("\n\t[Slot=" + this.slot.get(i) + " type=" + this.eqType.get(i) + "]");
            }
            return stringBuilder.toString();
        }
    }

    public class PUnitStructure {
        public String unitNumber;
        public String eqType;
        public String description;
        public String rackNum;
        public String rackPos;
        public String RUPos;
        public String RUSize;
        public String slotPos;
        public String slotOccupied;

        public String toString() {
            return "PASSIVE: Unit #" + this.unitNumber + ", type=" + this.eqType + ", descr=" + this.description + ", (num=" + this.rackNum + ", pos=" + this.rackPos + ", RU#=" + this.RUPos + ", RUSize=" + this.RUSize + "), slot(pos= " + this.slotPos + ", occupancy=" + this.slotOccupied + ")";
        }
    }

    public class ParamStructure {
        public String shelf;
        public String slot;
        public String unitid;
        public String port;
        public String ppm;
        public String paramName;
        public String paramValue;

        public String toString() {
            return "PARAM: Shelf# " + this.shelf + ", slot# " + this.slot + ", unit# " + this.unitid + ", ppm# " + this.ppm + ", port# " + this.port + ", name=" + this.paramName + ", value=" + this.paramValue;
        }
    }

    public class PatchcordsStructure {
        public String from_shelf;
        public String to_shelf;
        public String from_slot;
        public String to_slot;
        public String from_unit;
        public String to_unit;
        public String from_port;
        public String to_port;

        public String toString() {
            return "PATCHCORD: from_shelf# " + this.from_shelf + ", to_shelf# " + this.to_shelf + ", from_slot# " + this.from_slot + ", to_slot# " + this.to_slot + ", from_unit# " + this.from_unit + ", to_unit# " + this.to_unit + ", from_port# " + this.from_port + ", to_port# " + this.to_port;
        }
    }

    public class PpmStructure {
        public String shelf;
        public String slot;
        public String ppmnum;
        public String ppmtype;
        public String ppmport;
        public String ppmporttype;

        public String toString() {
            return "PPM: Shelf# " + this.shelf + ", slot# " + this.slot + ", ppm# " + this.ppmnum + ", type=" + this.ppmtype + ", port# " + this.ppmport + ", ptype=" + this.ppmporttype;
        }
    }

    public class SidesStructure {
        public String side_name;
        public String shelf_in;
        public String shelf_out;
        public String slot_in;
        public String slot_out;
        public String port_in;
        public String port_out;

        public String toString() {
            return "SIDE: " + this.side_name + ", shelf_in# " + this.shelf_in + ", shelf_out# " + this.shelf_out + ", slot_in# " + this.slot_in + ", slot_out# " + this.slot_out + ", port_in# " + this.port_in + ", port_out# " + this.port_out;
        }
    }
}

