/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Common.eReach;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Optics.eCtdcu_comp;
import cerent.cms.idl.Optics.eFtdcu_comp;
import cerent.cms.idl.Optics.eOpticalAmplifierRole;
import cerent.cms.idl.SonetTopology.sYCableProvision;
import cerent.cms.model.Attribute;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OTU2XpModuleModel;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.TdcuModuleModel;
import cerent.cms.model.UnsupportedCardOperMode;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.OpticalThresholdTableModel;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.KDebug;
import cerent.util.SDebug;

public class ParamsManager
extends WzTask {
    private static final String CPP_START = ">> Starting Card Parameters Provisioning...";
    private static final String CPP_PROB = " could not be provisioned: ";
    private static final String CPP_NO_CARD = " could not be provisioned: no card found";
    private static final String CPP_OTN = ">> Provisioning OTN ";
    private static final String CPP_FEC = ">> Provisioning FEC ";
    private static final String CPP_MLSE = ">> Provisioning MLSE ";
    private static final String CPP_EXC = ">> Exception in provisioning parameter ";
    private static final String CPP_OPT = ">> Provisioning OPT_AMP ";
    private static final String CPP_WL = ">> Provisioning WL ";
    private static final String CPP_CHWL = ">> Provisioning CH_WL ";
    private static final String CPP_BANDWL = ">> Provisioning BAND_WL ";
    private static final String CPP_OPERMODE = ">> Provisioning OPERMODE ";
    private static final String CPP_PSM_FAIL_TH = ">> Provisioning PSM LOS threshold ";
    private static final String CPP_REACH = ">> Provisioning REACH ";
    private static final String CPP_CONFIG_1_3 = ">> Configuring Ports 1-3 ";
    private static final String CPP_CONFIG_2_4 = ">> Configuring Ports 2-4 ";
    private static final String CPP_CONFIG_3_4 = ">> Configuring Ports 3-4 ";
    private static final String CPP_CONFIG_SPLITTER = ">> Configuring Splitter on Ports 1-3-4 ";
    private static final String CPP_CONFIG_YCABLE = ">> Configuring YCABLE ";
    private static final String CPP_CONFIG_REGEN_PEER = ">> Configuring Regen Peer ";
    private static final String CPP_CONFIG_DCU_COMP = ">> Provisioning TDCU/DCU Compensation ";
    private static final String CPP_ERR_NO_DCU_COMP = ">> Card does not support TDCU/DCU Compensation";
    private static final String CPP_CONFIG_WXC_MODE = ">> Provisioning WXC Oper Mode ";
    private static final String CPP_VAL = " with value ";
    private static final SDebug db = new SDebug("ParamsManager");

    public ParamsManager(NsdWizardInfo nsdWizardInfo, NodeModelDelegate nodeModelDelegate) {
        super(nsdWizardInfo, nodeModelDelegate);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized void doTask() {
        var1_1 = null;
        var2_2 = null;
        var3_3 = 0;
        var4_4 = 0;
        var7_5 = null;
        var8_6 = null;
        this.setWorking();
        this.wzInfo.logInfo(">> Starting Card Parameters Provisioning...\n");
        block54: for (var9_7 = 0; var9_7 < this.wzInfo.getParams().size(); ++var9_7) {
            block150: {
                var1_1 = this.wzInfo.getParams().elementAt(var9_7);
                var5_8 = var1_1.paramValue;
                var6_9 = var1_1.paramName;
                if (var1_1.unitid != null) {
                    var2_2 = PassiveModuleModel.getPassiveUnitById(this.node, Integer.parseInt(var1_1.unitid));
                } else {
                    var3_3 = this.isMs != false ? Integer.parseInt(var1_1.shelf) : 1;
                    var4_4 = Integer.parseInt(var1_1.slot);
                    var7_5 = var1_1.port;
                    var8_6 = var1_1.ppm;
                    var2_2 = this.getCardModel(var3_3, var4_4);
                }
                if (var2_2 == null) {
                    if (ParamsManager.db.on) {
                        ParamsManager.db.println("No slot found");
                    }
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: no card found" + "\n");
                    continue;
                }
                if (!var6_9.equalsIgnoreCase("OPT_AMP")) break block150;
                this.printStartSentence(">> Provisioning OPT_AMP ", var3_3, var4_4, null, var5_8, null);
                var10_10 = ((OpticsModuleModel)var2_2).getOpticsAmplifiedLineModels();
                try {
                    if (((OpticsAmplifiedLineModel[])var10_10).length <= 0) ** GOTO lbl39
                    if (var5_8.equalsIgnoreCase("PRE_AMPLI")) {
                        ((OpticsModuleModel)var2_2).setAmpliRole(eOpticalAmplifierRole.PRE_AMPLI);
                    } else if (var5_8.equalsIgnoreCase("BST_AMPLI")) {
                        ((OpticsModuleModel)var2_2).setAmpliRole(eOpticalAmplifierRole.BST_AMPLI);
                    } else {
                        this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "wrong parameter value\n");
                        continue;
lbl39:
                        // 1 sources

                        this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "wrong card found\n");
                        continue;
                    }
                    this.wzInfo.logInfo(">> Done...\n");
                }
                catch (Exception var11_16) {
                    if (ParamsManager.db.on) {
                        ParamsManager.db.println("Exception in provisioning parameter OPT_AMP");
                        KDebug.printStackTrace((Throwable)var11_16);
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter OPT_AMP\n");
                }
                continue;
            }
            if (var6_9.equalsIgnoreCase("WL")) {
                this.printStartSentence(">> Provisioning WL ", var3_3, var4_4, var7_5, var5_8, " nm");
                var10_10 = null;
                var11_17 = null;
                var12_36 = null;
                var13_46 /* !! */  = false;
                var14_65 = false;
                var11_17 = var2_2.getLineModels();
                for (var15_70 = 0; var15_70 < var11_17.length; ++var15_70) {
                    try {
                        if (!(var11_17[var15_70] instanceof DwdmTrkLineModel) || (var13_46 /* !! */  = (var16_74 = (Object)(var12_36 = ((DwdmTrkLineModel)var11_17[var15_70]).getPortModel()).getPortNum())[0]) != Integer.parseInt(var7_5)) continue;
                        var10_10 = (DwdmTrkLineModel)var11_17[var15_70];
                        var14_65 = true;
                        break;
                    }
                    catch (Exception var16_75) {
                        if (ParamsManager.db.on) {
                            ParamsManager.db.println("No port model found");
                            KDebug.printStackTrace((Throwable)var16_75);
                        }
                        this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: no port model found\n");
                    }
                }
                if (!var14_65) {
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: wrong port\n");
                    continue;
                }
                var15_71 = var5_8;
                var16_74 = null;
                try {
                    var16_74 = this.convertWl(var15_71);
                }
                catch (Exception var17_80) {
                    if (ParamsManager.db.on()) {
                        ParamsManager.db.println("Cannot translate WL found in mfg data: " + var15_71 + ": " + var17_80.getMessage());
                        KDebug.printStackTrace((Throwable)var17_80);
                    }
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "wrong wavelength data\n");
                    continue;
                }
                try {
                    var10_10.setWavelengthEnum((eWavelength)var16_74);
                }
                catch (Exception var17_81) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var17_81);
                        ParamsManager.db.println("Setting WL failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter WL\n");
                    continue;
                }
                this.wzInfo.logInfo(">> Done...\n");
                continue;
            }
            if (var6_9.equalsIgnoreCase("OTN") || var6_9.equalsIgnoreCase("FEC") || var6_9.equalsIgnoreCase("MLSE")) {
                block149: {
                    var10_10 = null;
                    var11_18 = null;
                    var12_37 = null;
                    var13_47 = 0;
                    var14_66 = false;
                    var15_72 = var5_8;
                    var16_76 = false;
                    var17_82 = 0;
                    if (var6_9.equalsIgnoreCase("OTN")) {
                        this.printStartSentence(">> Provisioning OTN ", var3_3, var4_4, null, var5_8, null);
                        var16_76 = var15_72.equalsIgnoreCase("enable") != false;
                    } else if (var6_9.equalsIgnoreCase("MLSE")) {
                        this.printStartSentence(">> Provisioning MLSE ", var3_3, var4_4, null, var5_8, null);
                        var16_76 = var15_72.equalsIgnoreCase("enable") != false;
                    } else if (var6_9.equalsIgnoreCase("FEC")) {
                        this.printStartSentence(">> Provisioning FEC ", var3_3, var4_4, null, var5_8, null);
                        if (var15_72.equalsIgnoreCase("disable")) {
                            var17_82 = 0;
                        } else if (var15_72.equalsIgnoreCase("enable") || var15_72.equalsIgnoreCase("standard")) {
                            var17_82 = 1;
                        } else if (var15_72.equalsIgnoreCase("enhanced")) {
                            var17_82 = 2;
                        }
                    }
                    var11_18 = var2_2.getLineModels();
                    for (var18_86 = 0; var18_86 < var11_18.length; ++var18_86) {
                        try {
                            if (!(var11_18[var18_86] instanceof DwdmTrkLineModel) || (var13_47 = (var19_88 = (var12_37 = ((DwdmTrkLineModel)var11_18[var18_86]).getPortModel()).getPortNum())[0]) != Integer.parseInt(var7_5)) continue;
                            var10_10 = (DwdmTrkLineModel)var11_18[var18_86];
                            var14_66 = true;
                            break;
                        }
                        catch (Exception var19_89) {
                            if (ParamsManager.db.on) {
                                ParamsManager.db.println("No port model found");
                                KDebug.printStackTrace((Throwable)var19_89);
                            }
                            this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "no port model found\n");
                        }
                    }
                    if (!var14_66) {
                        this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "wrong port or card found\n");
                        continue;
                    }
                    try {
                        if (var6_9.equalsIgnoreCase("OTN")) {
                            var10_10.setOTNStatus(var16_76);
                            break block149;
                        }
                        if (var6_9.equalsIgnoreCase("FEC")) {
                            var10_10.setFECModeValue(var17_82);
                            break block149;
                        }
                        if (!var6_9.equalsIgnoreCase("MLSE")) break block149;
                        var10_10.enableMlse(var16_76);
                    }
                    catch (Exception var18_87) {
                        if (ParamsManager.db.on) {
                            KDebug.printStackTrace((Throwable)var18_87);
                            if (var6_9.equalsIgnoreCase("OTN")) {
                                ParamsManager.db.println("Setting OTN failed");
                            } else if (var6_9.equalsIgnoreCase("MLSE")) {
                                ParamsManager.db.println("Setting MLSE failed");
                            } else {
                                ParamsManager.db.println("Setting FEC failed");
                            }
                        }
                        if (var6_9.equalsIgnoreCase("OTN")) {
                            this.wzInfo.logError(">> Exception in provisioning parameter OTN\n");
                            continue;
                        }
                        if (var6_9.equalsIgnoreCase("MLSE")) {
                            this.wzInfo.logError(">> Exception in provisioning parameter MLSE\n");
                            continue;
                        }
                        this.wzInfo.logError(">> Exception in provisioning parameter FEC\n");
                        continue;
                    }
                }
                this.wzInfo.logInfo(">> Done...\n");
                continue;
            }
            if (var6_9.equalsIgnoreCase("OPERMODE")) {
                this.printStartSentence(">> Provisioning OPERMODE ", var3_3, var4_4, null, var5_8, null);
                var5_8 = "OPER_MODE_" + var5_8;
                try {
                    var10_10 = (eCardOperMode)eCardOperMode.class.getDeclaredField(var5_8).get(new Object());
                    var2_2.setCardOperMode((eCardOperMode)var10_10);
                    this.wzInfo.logInfo(">> Done...\n");
                }
                catch (IllegalArgumentException var11_19) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var11_19);
                        ParamsManager.db.println("OPERMODE setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                }
                catch (SecurityException var11_20) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var11_20);
                        ParamsManager.db.println("OPERMODE setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                }
                catch (IllegalAccessException var11_21) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var11_21);
                        ParamsManager.db.println("OPERMODE setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                }
                catch (NoSuchFieldException var11_22) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var11_22);
                        ParamsManager.db.println("OPERMODE setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                }
                catch (EMCProvisionError var11_23) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var11_23);
                        ParamsManager.db.println("OPERMODE setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                }
                catch (UnsupportedCardOperMode var11_24) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var11_24);
                        ParamsManager.db.println("OPERMODE setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                }
                catch (ResourceInUse var11_25) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var11_25);
                        ParamsManager.db.println("OPERMODE setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
                }
                continue;
            }
            if (var6_9.equalsIgnoreCase("CH_WL")) {
                this.printStartSentence(">> Provisioning CH_WL ", var3_3, var4_4, null, var5_8, " nm");
                var10_10 = null;
                var11_26 = var5_8;
                var12_38 = null;
                try {
                    var12_38 = this.convertWl(var11_26);
                }
                catch (Exception var13_48) {
                    if (ParamsManager.db.on()) {
                        ParamsManager.db.println("Cannot translate WL found in mfg data: " + var11_26 + ": " + var13_48.getMessage());
                        KDebug.printStackTrace((Throwable)var13_48);
                    }
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "wrong wavelength data\n");
                    continue;
                }
                try {
                    var10_10 = ((OpticsModuleModel)var2_2).getOpticsChannelModels();
                    var10_10[0].setExpectedWaveLength(var12_38);
                }
                catch (NoSuchInterface var13_49) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var13_49);
                        ParamsManager.db.println("CH_WL setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter CH_WL\n");
                    continue;
                }
                catch (WrongInterfaceType var13_50) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var13_50);
                        ParamsManager.db.println("CH_WL setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter CH_WL\n");
                    continue;
                }
                catch (ConfigError var13_51) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var13_51);
                        ParamsManager.db.println("CH_WL setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter CH_WL\n");
                    continue;
                }
                catch (InternalCommError var13_52) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var13_52);
                        ParamsManager.db.println("CH_WL setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter CH_WL\n");
                    continue;
                }
                catch (Exception var13_53) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var13_53);
                        ParamsManager.db.println("CH_WL setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter CH_WL\n");
                    continue;
                }
                this.wzInfo.logInfo(">> Done...\n");
                continue;
            }
            if (var6_9.equalsIgnoreCase("BAND_WL")) {
                this.printStartSentence(">> Provisioning BAND_WL ", var3_3, var4_4, null, var5_8, " nm");
                var10_10 = null;
                var11_27 = var5_8;
                var12_39 = null;
                try {
                    var12_39 = this.convertBand(var11_27);
                }
                catch (Exception var13_54) {
                    if (ParamsManager.db.on()) {
                        ParamsManager.db.println("Cannot translate WL found in mfg data: " + var11_27 + ": " + var13_54.getMessage());
                        KDebug.printStackTrace((Throwable)var13_54);
                    }
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "wrong wavelength data\n");
                    continue;
                }
                try {
                    var10_10 = ((OpticsModuleModel)var2_2).getOpticsOMSModels();
                    var10_10[0].setExpectedBand(var12_39);
                }
                catch (NoSuchInterface var13_55) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var13_55);
                        ParamsManager.db.println("BAND_WL setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter BAND_WL\n");
                    continue;
                }
                catch (WrongInterfaceType var13_56) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var13_56);
                        ParamsManager.db.println("BAND_WL setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter BAND_WL\n");
                    continue;
                }
                catch (ConfigError var13_57) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var13_57);
                        ParamsManager.db.println("BAND_WL setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter BAND_WL\n");
                    continue;
                }
                catch (InternalCommError var13_58) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var13_58);
                        ParamsManager.db.println("BAND_WL setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter BAND_WL\n");
                    continue;
                }
                catch (Exception var13_59) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var13_59);
                        ParamsManager.db.println("BAND_WL setting failed");
                    }
                    this.wzInfo.logError(">> Exception in provisioning parameter BAND_WL\n");
                    continue;
                }
                this.wzInfo.logInfo(">> Done...\n");
                continue;
            }
            if (var6_9.equalsIgnoreCase("LOS")) {
                this.printStartSentence(">> Provisioning PSM LOS threshold ", var3_3, var4_4, null, var5_8, " nm");
                var10_10 = ((OpticsModuleModel)var2_2).getAllInterfaceModels();
                var11_28 = null;
                for (var12_40 = 0; var12_40 < ((InterfaceModel[])var10_10).length; ++var12_40) {
                    try {
                        if (!(var10_10[var12_40] instanceof OpticsLineModel) || (var11_28 = (OpticsLineModel)var10_10[var12_40]).getPortNumber() != Integer.parseInt(var7_5)) continue;
                        var13_60 = var11_28.getOpticsAlmThresholds();
                        var13_60.opticalPowerAlmTh.fail.low = OpticalThresholdTableModel.ValPerTen(var5_8);
                        var11_28.setOpticsAlmThresholds(var13_60);
                        this.wzInfo.logInfo(">> Done...\n");
                        continue block54;
                    }
                    catch (Exception var13_61) {
                        if (ParamsManager.db.on) {
                            ParamsManager.db.println("Exception in provisioning parameter LOS for PSM");
                            KDebug.printStackTrace((Throwable)var13_61);
                        }
                        this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "wrong port\n");
                    }
                }
                continue;
            }
            if (var6_9.equalsIgnoreCase("REACH")) {
                this.printStartSentence(">> Provisioning REACH ", var3_3, var4_4, null, var5_8, null);
                var10_10 = var2_2.getLineModels();
                var14_67 = false;
                var15_73 = null;
                for (var16_77 = 0; var16_77 < ((Object)var10_10).length; ++var16_77) {
                    try {
                        if (!(var10_10[var16_77] instanceof DwdmTrkLineModel)) continue;
                        var11_29 = var10_10[var16_77].getPortModel();
                        var17_83 = var11_29.getPortNum();
                        var12_41 = var17_83[1];
                        var13_62 = var17_83[0];
                        if (var12_41 != Integer.parseInt(var7_5) || var13_62 != Integer.parseInt(var8_6)) continue;
                        if (var10_10[var16_77] instanceof XPL2LineModel) {
                            var15_73 = ((XPL2LineModel)var10_10[var16_77]).getOpticsProvExtModel();
                        } else if (var10_10[var16_77] instanceof DwdmTrkLineModel) {
                            var15_73 = ((DwdmTrkLineModel)var10_10[var16_77]).getOpticsProvExtModel();
                        }
                        var14_67 = true;
                        break;
                    }
                    catch (Exception var17_84) {
                        if (ParamsManager.db.on) {
                            ParamsManager.db.println("No port model found");
                            KDebug.printStackTrace((Throwable)var17_84);
                        }
                        this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "no port model found\n");
                    }
                }
                if (!var14_67) {
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "wrong port or card found\n");
                    continue;
                }
                try {
                    var16_78 = eReach.from_int(this.string2Obj(var15_73.getNodeModel(), var5_8).getIntValue());
                    var15_73.setLineReach(var16_78);
                }
                catch (Exception var16_79) {
                    if (ParamsManager.db.on) {
                        KDebug.printStackTrace((Throwable)var16_79);
                        ParamsManager.db.println("REACH setting failed");
                    }
                    this.wzInfo.logError(">> Provisioning REACH wrong parameter or port value\n");
                    continue;
                }
                this.wzInfo.logInfo(">> Done...\n");
                continue;
            }
            if (var6_9.equalsIgnoreCase("Cfg1-3")) {
                this.printStartSentence(">> Configuring Ports 1-3 ", var3_3, var4_4, null, var5_8, null);
                if (var2_2.getEqType() != 293) continue;
                try {
                    var10_10 = (OTU2XpModuleModel)var2_2;
                    var11_30 = null;
                    var11_30 = var10_10.getLineModel(1).getDwdmLineConfig();
                    if (var5_8.equalsIgnoreCase("Standard Regen")) {
                        var11_30.regenPeerLineIndex = var10_10.getLineModel(3).getIndex();
                    } else if (var5_8.equalsIgnoreCase("LAN-WAN")) {
                        var11_30.regenPeerLineIndex = 0;
                        var11_30.isLanWanMode = true;
                    } else {
                        var11_30.regenPeerLineIndex = 0;
                    }
                    var10_10.getLineModel(1).setDwdmLineConfig(var11_30);
                    this.wzInfo.logInfo(">> Done...\n");
                }
                catch (Exception var10_11) {
                    if (ParamsManager.db.on) {
                        ParamsManager.db.println("Wrong Configuration");
                        KDebug.printStackTrace((Throwable)var10_11);
                    }
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "Wrong Configuration\n");
                }
                continue;
            }
            if (var6_9.equalsIgnoreCase("Cfg2-4")) {
                this.printStartSentence(">> Configuring Ports 2-4 ", var3_3, var4_4, null, var5_8, null);
                if (var2_2.getEqType() != 293) continue;
                var10_10 = (OTU2XpModuleModel)var2_2;
                var11_31 = null;
                try {
                    var11_31 = var10_10.getLineModel(2).getDwdmLineConfig();
                    var11_31.regenPeerLineIndex = var5_8.equalsIgnoreCase("Standard Regen") != false ? var10_10.getLineModel(4).getIndex() : 0;
                    var10_10.getLineModel(2).setDwdmLineConfig(var11_31);
                    this.wzInfo.logInfo(">> Done...\n");
                }
                catch (Exception var12_42) {
                    if (ParamsManager.db.on) {
                        ParamsManager.db.println("Wrong Configuration");
                        KDebug.printStackTrace((Throwable)var12_42);
                    }
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "Wrong Configuration\n");
                }
                continue;
            }
            if (var6_9.equalsIgnoreCase("Cfg3-4")) {
                this.printStartSentence(">> Configuring Ports 3-4 ", var3_3, var4_4, null, var5_8, null);
                if (var2_2.getEqType() != 293) continue;
                try {
                    var10_10 = (OTU2XpModuleModel)var2_2;
                    var11_32 = null;
                    var11_32 = var10_10.getLineModel(3).getDwdmLineConfig();
                    var11_32.regenPeerLineIndex = var5_8.equalsIgnoreCase("Enhanced FEC") != false ? var10_10.getLineModel(4).getIndex() : 0;
                    var10_10.getLineModel(3).setDwdmLineConfig(var11_32);
                    this.wzInfo.logInfo(">> Done...\n");
                }
                catch (Exception var10_12) {
                    if (ParamsManager.db.on) {
                        ParamsManager.db.println("Wrong Configuration");
                        KDebug.printStackTrace((Throwable)var10_12);
                    }
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "Wrong Configuration\n");
                }
                continue;
            }
            if (var6_9.equalsIgnoreCase("Cfg1-3-4")) {
                this.printStartSentence(">> Configuring Splitter on Ports 1-3-4 ", var3_3, var4_4, null, var5_8, null);
                if (var2_2.getEqType() != 293) continue;
                try {
                    var10_10 = var2_2.getChassis().getElementModels();
                    var11_33 = ((OTU2XpModuleModel)var2_2).getLineModel(3).getPortModel();
                    var12_43 = ((OTU2XpModuleModel)var2_2).getLineModel(4).getPortModel();
                    var13_63 = new RevertiveBehavior(1, 300);
                    var14_68 = RevertiveBehaviorFactory.getRevertiveBehavior(var13_63);
                    if (var5_8.equalsIgnoreCase("Splitter")) {
                        var10_10.createSplitter(new sYCableProvision(var11_33.getEntityIndex(), var12_43.getEntityIndex(), var14_68, false), "Splitter_Shelf" + var3_3 + "_Slot" + var4_4);
                    }
                    this.wzInfo.logInfo(">> Done...\n");
                }
                catch (Exception var10_13) {
                    if (ParamsManager.db.on) {
                        ParamsManager.db.println("Wrong Configuration");
                        KDebug.printStackTrace((Throwable)var10_13);
                    }
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "Wrong Configuration\n");
                }
                continue;
            }
            if (var6_9.equalsIgnoreCase("YcablePeerSlot")) {
                this.printStartSentence(">> Configuring YCABLE ", var3_3, var4_4, var7_5, var5_8, null);
                try {
                    var10_10 = var2_2.getChassis().getElementModels();
                    var11_34 = Integer.parseInt(var7_5);
                    var12_44 = ((DwdmModuleModel)var2_2).getDwdmPorts()[var11_34 - 1].getIndex();
                    var13_64 = Integer.parseInt(var5_8);
                    var14_69 = (DwdmModuleModel)this.getCardModel(var3_3, var13_64);
                    var15_70 = var14_69.getDwdmPorts()[var11_34 - 1].getIndex();
                    var16_74 = new RevertiveBehavior(1, 300);
                    var17_85 = RevertiveBehaviorFactory.getRevertiveBehavior((IRevertiveBehavior)var16_74);
                    var10_10.createYCable(new sYCableProvision(var12_44, var15_70, var17_85, false), "YCable_Sh" + var3_3 + "_S" + var4_4 + "_S" + var5_8 + "_P" + var7_5);
                    this.wzInfo.logInfo(">> Done...\n");
                }
                catch (Exception var10_14) {
                    if (ParamsManager.db.on) {
                        ParamsManager.db.println("Wrong Configuration");
                        KDebug.printStackTrace((Throwable)var10_14);
                    }
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "Wrong Configuration\n");
                }
                continue;
            }
            if (var6_9.equalsIgnoreCase("RegenPeerSlot")) {
                this.printStartSentence(">> Configuring Regen Peer ", var3_3, var4_4, var7_5, var5_8, null);
                try {
                    var10_10 = ((DwdmModuleModel)var2_2).getFirstTrunkLine();
                    var11_35 = var10_10.getDwdmCardConfig();
                    var12_45 = Integer.parseInt(var5_8);
                    var11_35.regenPeerCardIndex = ((DwdmModuleModel)this.getCardModel(var3_3, var12_45)).getEntityIndex();
                    var10_10.setDwdmCardConfig(var11_35);
                    this.wzInfo.logInfo(">> Done...\n");
                }
                catch (Exception var10_15) {
                    if (ParamsManager.db.on) {
                        ParamsManager.db.println("Wrong Configuration");
                        KDebug.printStackTrace((Throwable)var10_15);
                    }
                    this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "Wrong Configuration\n");
                }
                continue;
            }
            if (var6_9.equalsIgnoreCase("TDCU_COMPENSATION")) {
                this.printStartSentence(">> Provisioning TDCU/DCU Compensation ", var3_3, var4_4, null, var5_8, null);
                if (var2_2 instanceof TdcuModuleModel) {
                    this.setTDCUCompensation((TdcuModuleModel)var2_2, var5_8 + " ps/nm");
                    continue;
                }
                this.wzInfo.logError(">> Card does not support TDCU/DCU Compensation\n");
                continue;
            }
            if (var6_9.equalsIgnoreCase("DCU_COMPENSATION")) {
                this.printStartSentence(">> Provisioning TDCU/DCU Compensation ", var1_1.unitid, var5_8, null);
                if (var2_2 instanceof PassiveModuleModel) {
                    this.setDCUCompensation((PassiveModuleModel)var2_2, var5_8);
                    continue;
                }
                this.wzInfo.logError(">> Card does not support TDCU/DCU Compensation\n");
                continue;
            }
            if (var6_9.equalsIgnoreCase("WXC_MODE")) {
                this.printStartSentence(">> Provisioning WXC Oper Mode ", var3_3, var4_4, null, var5_8, null);
                var10_10 = this.getAttribute("Wxc80CardMode", var5_8, var2_2);
                if (var10_10 != null) {
                    this.setCardMode(var2_2, var10_10.getIntValue());
                    continue;
                }
                this.wzInfo.logError(">> Invalid WXC MODE " + var5_8 + "\n");
                continue;
            }
            this.wzInfo.logError(">> " + var6_9 + " could not be provisioned: " + "wrong parameter name\n");
        }
        this.setCompleted();
    }

    private void printStartSentence(String string, int n, int n2, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + " at ");
        if (this.isMs) {
            stringBuilder.append("shelf " + n + ", ");
        }
        stringBuilder.append("slot " + n2 + ", ");
        if (string2 != null) {
            stringBuilder.append("port " + string2);
        }
        if (string4 == null) {
            string4 = "";
        }
        stringBuilder.append(CPP_VAL + string3 + string4 + "\n");
        this.wzInfo.logInfo(stringBuilder.toString());
    }

    private void printStartSentence(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + " at unit id " + string2);
        if (string4 == null) {
            string4 = "";
        }
        stringBuilder.append(CPP_VAL + string3 + string4 + "\n");
        this.wzInfo.logInfo(stringBuilder.toString());
    }

    private Attribute string2Obj(INodeModel iNodeModel, String string) {
        Attribute attribute = null;
        ElAttributeMaps elAttributeMaps = ElementDefaults.getAttributeMap((IModel)iNodeModel);
        Attribute[] attributeArray = elAttributeMaps.getAttributeArray("declDwdmReach");
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i].getKey().compareTo(string) != 0) continue;
            attribute = attributeArray[i];
            break;
        }
        return attribute;
    }

    private Attribute getAttribute(String string, String string2, ModuleModel moduleModel) {
        Attribute[] attributeArray;
        for (Attribute attribute : attributeArray = ElementDefaults.getAttributeMap(moduleModel).getAttributeArray(string)) {
            if (!attribute.getKey().equalsIgnoreCase(string2)) continue;
            return attribute;
        }
        return null;
    }

    private void setTDCUCompensation(TdcuModuleModel tdcuModuleModel, String string) {
        String string2 = tdcuModuleModel.getEqType() == 298 ? "fTdcuComp" : "cTdcuComp";
        Attribute attribute = this.getAttribute(string2, string, tdcuModuleModel);
        if (attribute != null) {
            try {
                if (tdcuModuleModel.getEqType() == 299) {
                    tdcuModuleModel.setCTdcuCompensationValue(eCtdcu_comp.from_int(attribute.getIntValue()));
                } else {
                    tdcuModuleModel.setFTdcuCompensationValue(eFtdcu_comp.from_int(attribute.getIntValue()));
                }
                this.wzInfo.logInfo(">> Done...\n");
            }
            catch (Exception exception) {
                this.wzInfo.logError(">> Exception in provisioning parameter  TDCU COmpensation\n");
            }
            return;
        }
        this.wzInfo.logError(">> Invalid TDCU Compensation value " + string + "\n");
    }

    private void setDCUCompensation(PassiveModuleModel passiveModuleModel, String string) {
        try {
            if (passiveModuleModel.getEqType() == 312) {
                passiveModuleModel.setDCUCompensation(string);
                this.wzInfo.logInfo(">> Done...\n");
            } else {
                this.wzInfo.logError(">> Card does not support TDCU/DCU Compensation\n");
            }
        }
        catch (Exception exception) {
            this.wzInfo.logError(">> Exception in provisioning parameter  TDCU COmpensation\n");
        }
    }

    private void setCardMode(ModuleModel moduleModel, int n) {
        try {
            moduleModel.setCardOperMode(eCardOperMode.from_int(n));
            this.wzInfo.logInfo(">> Done...\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (ParamsManager.db.on) {
                KDebug.printStackTrace((Throwable)illegalArgumentException);
                db.println("OPERMODE setting failed");
            }
            this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
        }
        catch (SecurityException securityException) {
            if (ParamsManager.db.on) {
                KDebug.printStackTrace((Throwable)securityException);
                db.println("OPERMODE setting failed");
            }
            this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
        }
        catch (EMCProvisionError eMCProvisionError) {
            if (ParamsManager.db.on) {
                KDebug.printStackTrace((Throwable)((Object)eMCProvisionError));
                db.println("OPERMODE setting failed");
            }
            this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
        }
        catch (UnsupportedCardOperMode unsupportedCardOperMode) {
            if (ParamsManager.db.on) {
                KDebug.printStackTrace((Throwable)unsupportedCardOperMode);
                db.println("OPERMODE setting failed");
            }
            this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
        }
        catch (ResourceInUse resourceInUse) {
            if (ParamsManager.db.on) {
                KDebug.printStackTrace((Throwable)resourceInUse);
                db.println("OPERMODE setting failed");
            }
            this.wzInfo.logError(">> Exception in provisioning parameter OPERMODE\n");
        }
    }
}

