/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PassiveUnitsManager
extends WzTask {
    private static final String PU_UNIT = ">> Provisioning Unit #";
    private static final String PU_PROB_UNIT = ">> Unit not empty...\n";
    private static final String PU_ERROR = ">> Error: ";
    private static final String PU_ERROR_UNKNOWN = ">> Error: Unknown unit type ";
    private static final String PU_PROB_GENERIC = ">> Generic error: ";
    private static final String PU_START = "\n>> Starting Passive Units Provisioning...\n";

    public PassiveUnitsManager(NsdWizardInfo nsdWizardInfo, NodeModelDelegate nodeModelDelegate) {
        super(nsdWizardInfo, nodeModelDelegate);
    }

    public void doTask() {
        this.setWorking();
        this.wzInfo.logInfo(PU_START);
        Vector<NsdWizardInfo.PUnitStructure> vector = this.wzInfo.getPassiveUnits();
        for (NsdWizardInfo.PUnitStructure pUnitStructure : vector) {
            this.provisionPassive(Integer.parseInt(pUnitStructure.unitNumber), pUnitStructure.eqType, pUnitStructure.description, Short.parseShort(pUnitStructure.rackNum), Short.parseShort(pUnitStructure.rackPos), Short.parseShort(pUnitStructure.slotPos), pUnitStructure.RUPos, pUnitStructure.RUSize, pUnitStructure.slotOccupied);
        }
        this.setCompleted();
    }

    private void provisionPassive(int n, String string, String string2, short s, short s2, short s3, String string3, String string4, String string5) {
        this.wzInfo.logInfo(PU_UNIT + n + " with " + string + " passive unit" + "..." + "\n");
        try {
            eEqType eEqType2 = EntityModel.name2EqType(this.node, string);
            boolean bl = true;
            short s4 = 1;
            short s5 = 1;
            short s6 = 1;
            if (string3 != null) {
                s2 = Short.parseShort(string3);
                bl = false;
            }
            if (string4 != null) {
                Matcher matcher = Pattern.compile("(\\d)/(\\d)").matcher(string4);
                if (matcher.find()) {
                    s4 = Short.parseShort(matcher.group(1));
                    s5 = Short.parseShort(matcher.group(2));
                } else {
                    s4 = Short.parseShort(string4);
                }
            }
            if (string5 != null) {
                s6 = Short.parseShort(string5);
            }
            if (eEqType2 != null) {
                PassiveModuleModel.provisionPassiveModule(this.entm, n, eEqType2, string2, s, s2, bl, s4, s5, s3, s6);
                this.wzInfo.logInfo(">> Done...\n");
            } else {
                this.wzInfo.logError(PU_ERROR_UNKNOWN + string + "..." + "\n");
            }
        }
        catch (ResourceInUse resourceInUse) {
            resourceInUse.printStackTrace();
            this.wzInfo.logError(PU_PROB_UNIT);
        }
        catch (EMCProvisionError eMCProvisionError) {
            eMCProvisionError.printStackTrace();
            this.wzInfo.logError(PU_ERROR + eMCProvisionError.getMessage() + "..." + "\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.wzInfo.logError(PU_PROB_GENERIC + exception.getMessage() + "..." + "\n");
        }
    }
}

