/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.model.DuplicatedPatchCord;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import java.util.Vector;

public class PatchcordsManager
extends WzTask {
    private static final String IPP_START = ">> Starting Internal Patchcords Provisioning...\n";
    private static final String IPP_PROB = ">> Patchcord could not be provisioned: ";
    private static final String IPP_CORE = ">> Provisioning internal patchcord ";

    public PatchcordsManager(NsdWizardInfo nsdWizardInfo, NodeModelDelegate nodeModelDelegate) {
        super(nsdWizardInfo, nodeModelDelegate);
    }

    public synchronized void doTask() {
        this.setWorking();
        this.wzInfo.logInfo(IPP_START);
        Vector<NsdWizardInfo.PatchcordsStructure> vector = this.wzInfo.getPatchcords();
        NsdWizardInfo.PatchcordsStructure patchcordsStructure = null;
        OpticalPatchCordModel opticalPatchCordModel = null;
        opticalPatchCordModel = this.node.getOpticalPatchCordModel();
        for (int i = 0; i < vector.size(); ++i) {
            patchcordsStructure = vector.elementAt(i);
            String string = this.getPortString(patchcordsStructure.from_shelf, patchcordsStructure.from_slot, patchcordsStructure.from_unit, patchcordsStructure.from_port);
            String string2 = this.getPortString(patchcordsStructure.to_shelf, patchcordsStructure.to_slot, patchcordsStructure.to_unit, patchcordsStructure.to_port);
            this.wzInfo.logInfo(IPP_CORE + string + string2 + "\n");
            PortModel portModel = this.getPortModel(patchcordsStructure.from_shelf, patchcordsStructure.from_slot, patchcordsStructure.from_unit, patchcordsStructure.from_port);
            PortModel portModel2 = this.getPortModel(patchcordsStructure.to_shelf, patchcordsStructure.to_slot, patchcordsStructure.to_unit, patchcordsStructure.to_port);
            if (portModel == null || portModel2 == null) continue;
            try {
                opticalPatchCordModel.addOpticalLink(portModel2.getIndex(), portModel.getIndex());
                this.wzInfo.logInfo(">> Done...\n");
                continue;
            }
            catch (Exception exception) {
                if (exception instanceof DuplicatedPatchCord) {
                    this.wzInfo.logError(">> Patchcord could not be provisioned: duplicated patchcord\n");
                    continue;
                }
                this.wzInfo.logError(">> Patchcord could not be provisioned: problem in adding the Optical Link\n");
            }
        }
        this.setCompleted();
    }
}

