/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class PpmManager
extends WzTask
implements Observer {
    private static final String PPM_START = "\n>> Starting Pluggable Port Modules Provisioning...\n";
    private static final String PPM_PROV = ">> Provisioning PPM #";
    private static final String PPM_TYPE = " with PPM Type ";
    private static final String PPM_PROB_CARD = ">> Setting refused: no card available...\n";
    private static final String PPM_PROB_SLOT = ">> Setting refused: PPM slot not empty...\n";
    private static final String PPM_PROB_TYPE = ">> Setting refused: unknown PPM type...\n";
    private static final String PPM_PROB_PROV = ">> Setting refused: provisioning error...\n";
    private static final String PPM_PROB_WRONG_PORT_TYPE = ">> Setting refused: wrong Port Type...\n";
    private static final String PPM_PROB_PROV_INUSE = ">> Setting refused: provisioning error, resource already in use...\n";
    private static final String PPM_PORT_PROV = ">> Provisioning Pluggable Port #";
    private static final String PPM_PORT_TYPE = " with Port Type ";
    private static final String PPM_PROB_WRONG_CARD = ">> Setting refused: wrong card found...\n";
    private NsdWizardInfo.PpmStructure ppmStr = null;
    private Vector ppmVect;
    private int ppmCounter;
    private Vector ppmHandles = new Vector();
    private static final SDebug db = new SDebug("PpmManager");

    public PpmManager(NsdWizardInfo nsdWizardInfo, NodeModelDelegate nodeModelDelegate) {
        super(nsdWizardInfo, nodeModelDelegate);
        this.ppmVect = nsdWizardInfo.getPpm();
        this.ppmCounter = this.ppmVect.size();
    }

    public synchronized void doTask() {
        this.setWorking();
        this.wzInfo.logInfo(PPM_START);
        this.preparePpm();
    }

    private void preparePpm() {
        int n;
        ModuleModel moduleModel = null;
        PluggableSlotModel[] pluggableSlotModelArray = null;
        PluggableSlotModel pluggableSlotModel = null;
        eEqType eEqType2 = null;
        List list = new ArrayList();
        TDMTerminology tDMTerminology = this.node.getTDMTerminology();
        for (n = 0; n < this.ppmVect.size(); ++n) {
            String string;
            pluggableSlotModel = null;
            eEqType2 = null;
            this.ppmStr = this.wzInfo.getPpm().elementAt(n);
            int n2 = Integer.parseInt(this.ppmStr.shelf);
            int n3 = Integer.parseInt(this.ppmStr.slot);
            int n4 = Integer.parseInt(this.ppmStr.ppmnum);
            String string2 = this.ppmStr.ppmtype;
            String string3 = string = this.ppmStr.ppmport != null ? this.ppmStr.ppmport : "";
            if (this.isMs) {
                this.wzInfo.logInfo(PPM_PROV + n4 + " at shelf " + n2 + ", slot " + n3 + PPM_TYPE + string2 + "\n");
            } else {
                this.wzInfo.logInfo(PPM_PROV + n4 + " at slot " + n3 + PPM_TYPE + string2 + "\n");
            }
            moduleModel = this.getCardModel(n2, n3);
            if (moduleModel == null) {
                --this.ppmCounter;
                this.wzInfo.logError(PPM_PROB_CARD);
                db.println("no card found");
                continue;
            }
            if (moduleModel instanceof PluggableCarrierModel) {
                int n5;
                list = ((PluggableCarrierModel)moduleModel).getAvailablePpmSlots();
                if (list == null || list.size() <= 0) {
                    --this.ppmCounter;
                    this.wzInfo.logError(PPM_PROB_SLOT);
                    db.println("ppm slot not available");
                    if (string.equalsIgnoreCase("")) continue;
                    this.provisionPpm(n2, n3, n4);
                    continue;
                }
                pluggableSlotModelArray = list.toArray(new PluggableSlotModel[0]);
                for (n5 = 0; n5 < pluggableSlotModelArray.length; ++n5) {
                    if (pluggableSlotModelArray[n5].getHierarchyNums()[0] != n4) continue;
                    pluggableSlotModel = pluggableSlotModelArray[n5];
                    break;
                }
                if (pluggableSlotModel == null) {
                    --this.ppmCounter;
                    this.wzInfo.logError(PPM_PROB_SLOT);
                    db.println("ppm slot not empty");
                    if (string.equalsIgnoreCase("")) continue;
                    this.provisionPpm(n2, n3, n4);
                    continue;
                }
                eEqType[] eEqTypeArray = pluggableSlotModel.getPluggableTypeList();
                for (n5 = 0; n5 < eEqTypeArray.length; ++n5) {
                    if (!EqTypeHelper.eqTypeToName((TDMTerminology)tDMTerminology, (int)eEqTypeArray[n5].value()).equalsIgnoreCase(string2)) continue;
                    eEqType2 = eEqTypeArray[n5];
                    break;
                }
                if (eEqType2 == null) {
                    --this.ppmCounter;
                    this.wzInfo.logError(PPM_PROB_TYPE);
                    db.println("unknown ppm type");
                    continue;
                }
                try {
                    pluggableSlotModel.provisionPluggable(eEqType2);
                }
                catch (Exception exception) {
                    --this.ppmCounter;
                    this.wzInfo.logError(PPM_PROB_PROV);
                    db.println("provisioning error");
                    continue;
                }
                this.wzInfo.logInfo(">> Done...\n");
                pluggableSlotModel.addObserver(this);
                this.ppmHandles.add(pluggableSlotModel);
                continue;
            }
            --this.ppmCounter;
            this.wzInfo.logError(PPM_PROB_WRONG_CARD);
            db.println("wrong card found");
        }
        if (this.ppmCounter == 0) {
            for (n = 0; n < this.ppmHandles.size(); ++n) {
                EntityModel entityModel = (EntityModel)this.ppmHandles.elementAt(n);
                entityModel.deleteObserver(this);
            }
            this.setCompleted();
        }
    }

    private void provisionPpm(int n, int n2, int n3) {
        int n4;
        NsdWizardInfo.PpmStructure ppmStructure = null;
        ModuleModel moduleModel = null;
        PpmModel[] ppmModelArray = null;
        PpmModel ppmModel = null;
        String string = null;
        for (n4 = 0; n4 < this.ppmVect.size(); ++n4) {
            ppmStructure = (NsdWizardInfo.PpmStructure)this.ppmVect.elementAt(n4);
            if (Integer.parseInt(ppmStructure.ppmnum) == n3 && Integer.parseInt(ppmStructure.shelf) == n && Integer.parseInt(ppmStructure.slot) == n2) break;
        }
        String string2 = string = ppmStructure.ppmport != null ? ppmStructure.ppmport : "";
        if (!string.equalsIgnoreCase("")) {
            if (this.isMs) {
                this.wzInfo.logInfo(PPM_PORT_PROV + ppmStructure.ppmport + PPM_PORT_TYPE + ppmStructure.ppmporttype + " at shelf " + ppmStructure.shelf + ", slot " + ppmStructure.slot + ", port " + ppmStructure.ppmnum + "\n");
            } else {
                this.wzInfo.logInfo(PPM_PORT_PROV + ppmStructure.ppmport + PPM_PORT_TYPE + ppmStructure.ppmporttype + " at slot " + ppmStructure.slot + ", port " + ppmStructure.ppmnum + "\n");
            }
            moduleModel = this.getCardModel(n, n2);
            if (moduleModel == null) {
                this.wzInfo.logError(PPM_PROB_CARD);
                db.println("no card found");
            }
            ppmModelArray = ((PluggableCarrierModel)moduleModel).getPpmModels();
            for (n4 = 0; n4 < ppmModelArray.length; ++n4) {
                if (ppmModelArray[n4].getHierarchyNums()[0] != n3) continue;
                ppmModel = ppmModelArray[n4];
                break;
            }
            PortId portId = new PortId(ppmModel, ppmStructure.ppmport);
            int n5 = portId.getPortPosInParent();
            EntityTableModel entityTableModel = this.node.getEntityTableModel();
            eEqType eEqType2 = EntityModel.name2EqType(this.node, ppmStructure.ppmporttype + "_PORT");
            try {
                if (eEqType2 == null) {
                    if (eEqType2 == null || eEqType2.equals(eEqType.INVALID)) {
                        if (db.on()) {
                            db.println("Error applying changes in Pluggable Port Provisioning");
                        }
                        this.wzInfo.logError(PPM_PROB_WRONG_PORT_TYPE);
                    } else {
                        entityTableModel.provisionPort(ppmModel, n5, eEqType2);
                        this.wzInfo.logInfo(">> Done...\n");
                    }
                } else {
                    entityTableModel.provisionPort(ppmModel, n5, eEqType2);
                    this.wzInfo.logInfo(">> Done...\n");
                }
            }
            catch (ProvisionError provisionError) {
                if (db.on()) {
                    db.println("Error applying changes in Pluggable Port Provisioning, ProvisionError Exception: " + provisionError.getPrettyMessage());
                }
                this.wzInfo.logError(PPM_PROB_PROV);
            }
            catch (ResourceInUse resourceInUse) {
                if (db.on()) {
                    db.println("Error applying changes in Pluggable Port Provisioning, ResourceInUse Exception: " + resourceInUse.toString());
                }
                this.wzInfo.logError(PPM_PROB_PROV_INUSE);
            }
        }
    }

    public void update(Observable observable, Object object) {
        int n = -1;
        if (observable instanceof PluggableSlotModel) {
            n = (Integer)object;
            switch (n) {
                case 2: {
                    --this.ppmCounter;
                    int n2 = ((PluggableSlotModel)((Object)observable)).getHierarchyNums()[0];
                    int n3 = ((PluggableSlotModel)((Object)observable)).getSlot();
                    int n4 = ((PluggableSlotModel)((Object)observable)).getShelfId();
                    this.provisionPpm(n4, n3, n2);
                    if (this.ppmCounter != 0) break;
                    for (int i = 0; i < this.ppmHandles.size(); ++i) {
                        EntityModel entityModel = (EntityModel)this.ppmHandles.elementAt(i);
                        entityModel.deleteObserver(this);
                    }
                    this.setCompleted();
                    break;
                }
                default: {
                    if (!db.on()) break;
                    db.severe("Unknown update type " + n);
                }
            }
        }
    }

    protected class PortId {
        private IPortContainer _container;
        private String _portNum;

        public PortId(IPortContainer iPortContainer, String string) {
            this._container = iPortContainer;
            this._portNum = string;
        }

        public String getPortNum() {
            return this._portNum;
        }

        public IPortContainer getContainer() {
            return this._container;
        }

        public String toString() {
            return this._portNum;
        }

        public int getPortPosInParent() {
            int n = this._portNum.lastIndexOf(45) + 1;
            return Integer.parseInt(this._portNum.substring(n));
        }
    }
}

