/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzPane;
import cerent.cms.ui.nodesetup.IWzTaskListener;
import cerent.cms.ui.nodesetup.NodeSetupDialog;
import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public abstract class WzNsdPane
extends WzPane
implements IWzTaskListener {
    protected final NsdWizardInfo wizInfo;
    private final NodeSetupDialog nsd;
    private final WzTask task;
    protected JPanel rowTextArea;
    protected JPanel colTextArea;
    private UScrollPane colTextPane;
    protected String[] columnNames;
    protected String[][] dataValues;
    private JSplitPane js = new JSplitPane();
    protected final boolean isMs;

    public WzNsdPane(NodeSetupDialog nodeSetupDialog, WzDiagDebug wzDiagDebug, String string, NsdWizardInfo nsdWizardInfo, WzTask wzTask) {
        super(nodeSetupDialog, wzDiagDebug, string);
        this.wizInfo = nsdWizardInfo;
        this.nsd = nodeSetupDialog;
        this.task = wzTask;
        this.task.addListener(this);
        this.isMs = nsdWizardInfo.getNmd().isMultishelf();
    }

    private void disableButtons() {
        this.nsd.setNextEnabled(this.getNextPaneName() != null);
        this.nsd.setApplyEnabled(false);
        if (this.getNextPaneName() == null) {
            this.nsd.setFinishEnabled(true);
        }
    }

    private JPanel createRightPanel() {
        this.rowTextArea = WzNsdPane.createHorizontalPanel(null);
        this.colTextArea = WzNsdPane.createVerticalPanel("Log");
        this.colTextPane = this.wizInfo.getLogAreaPane();
        this.colTextArea.add((Component)this.colTextPane);
        this.rowTextArea.add(this.colTextArea);
        return this.rowTextArea;
    }

    private JPanel createLeftPanel() {
        this.createColumns();
        this.createData();
        JTable jTable = new JTable(this.dataValues, this.columnNames){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setShowHorizontalLines(true);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(true);
        this.changeTableSetting(jTable);
        UScrollPane uScrollPane = new UScrollPane((Component)jTable);
        JPanel jPanel = WzNsdPane.createHorizontalPanel(null);
        JPanel jPanel2 = WzNsdPane.createVerticalPanel("");
        jPanel2.add((Component)uScrollPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected abstract void createColumns();

    protected abstract void createData();

    protected void changeTableSetting(JTable jTable) {
    }

    public final void initPane() {
        this.setLayout(new BorderLayout(5, 5));
        this.js.setDividerLocation(375);
        this.js.setOneTouchExpandable(true);
        this.js.setContinuousLayout(true);
        this.js.setLeftComponent(this.createLeftPanel());
        this.js.setRightComponent(this.createRightPanel());
        this.nsd.setApplyEnabled(true);
        this.nsd.setButtonsEnabled(false, false);
        this.add((Component)this.js, "Center");
    }

    public final String handleNext() {
        try {
            this.resetOkToPostValidate();
            this.validatePage();
            if (!this.isOkToPostValidate()) {
                return null;
            }
            this.handlePostValidate();
        }
        catch (Exception exception) {
            this.handleNextException(exception);
            return null;
        }
        return this.getNextPaneName();
    }

    public final void enteringPane() {
        this.initPane();
        if (this.db.on()) {
            this.db.println("enteringPage: start");
        }
        super.enteringPane();
    }

    public final boolean handleBack() {
        if (this.db.on()) {
            this.db.println("handleBack: start");
        }
        this.rowTextArea.remove(this.colTextArea);
        this.colTextArea.remove((Component)this.colTextPane);
        return super.handleBack();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public void validatePage() throws Exception {
        if (this.db.on()) {
            this.db.println("validatePage: start");
        }
        this.rowTextArea.remove(this.colTextArea);
        this.colTextArea.remove((Component)this.colTextPane);
    }

    public final void handleApply() {
        if (this.wizInfo.getFirstPane().equalsIgnoreCase(this.getName())) {
            this.task.begin();
            this.wizInfo.logInfo("------------------------------------------------");
        }
        this.task.doTask();
    }

    public final void taskFinished() {
        this.wizInfo.logInfo(">> Applied...\n");
        if (this.wizInfo.getLastPane().equalsIgnoreCase(this.getName())) {
            this.wizInfo.logInfo("------------------------------------------------");
            this.task.end();
        }
        this.disableButtons();
    }

    public final void taskStatusChanged() {
    }

    public final CSHelpID getHelpID() {
        return CSHelpConst.NodeSetupWizard;
    }

    protected String getPortString(String string, String string2, String string3, String string4) {
        return this.task.getPortString(string, string2, string3, string4);
    }
}

