/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.nodesetup;

import cerent.cms.ui.nodesetup.NsdWizardInfo;
import cerent.cms.ui.nodesetup.WzTask;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WzTasksController
implements Runnable {
    private Vector<WzTask> tasks = null;
    private NsdWizardInfo wzInfo = null;
    private boolean isCtm;
    private int wakeupTime;
    private static final SDebug db = new SDebug("WzTaskController");

    public WzTasksController(Vector<WzTask> vector, NsdWizardInfo nsdWizardInfo, boolean bl) {
        this.tasks = vector;
        this.wzInfo = nsdWizardInfo;
        this.isCtm = bl;
        this.wakeupTime = 500;
    }

    @Override
    public void run() {
        block6: {
            try {
                WzTask.begin(this.wzInfo);
                while (this.checkTasks()) {
                    Thread.sleep(this.wakeupTime);
                }
                WzTask.end(this.wzInfo);
            }
            catch (InterruptedException interruptedException) {
                db.println("InterruptedException during WzTasksCotroller thread execution: " + interruptedException);
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)interruptedException);
            }
        }
        if (!this.isCtm) {
            if (this.wzInfo.getErrCnt() > 0) {
                CerentDialog.warningDialog(null, (String)"The wizard completed import with some error!\nCheck log for details.", (String)"Wizard End");
            } else {
                CerentDialog.infoDialog(null, (String)"The wizard successfully completed the import.", (String)"Wizard End");
            }
        }
        this.wzInfo.getLogPs().close();
    }

    private boolean checkTasks() {
        boolean bl = false;
        WzTask wzTask = null;
        for (int i = 0; i < this.tasks.size(); ++i) {
            wzTask = this.tasks.elementAt(i);
            if (wzTask == null) continue;
            if (wzTask.isIdle()) {
                wzTask.doTask();
                bl = true;
                break;
            }
            if (wzTask.isCompleted()) {
                this.tasks.remove(i);
                --i;
                continue;
            }
            if (!wzTask.isWorking()) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

