/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oadm;

import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class OadmOpticalPlugInTableModel
extends AbstractTableModel {
    private static final SDebug db = new SDebug("OadmOpticalPlugInTableModel");
    private OpticsModuleModel module;
    private String[] Key;
    private String[] strValue;
    private static final TreeMap names = new TreeMap();
    private static final TreeMap units = new TreeMap();
    private OpticsPortModel[] models;
    private OpticsLineModel[] lineModels;
    private OpticsModuleModel eqpmtModel;
    private boolean[] rowDirty;
    private int numLines;
    private int numPorts;
    protected String[] columnNames = new String[]{"Attribute", "Value", "Units"};

    public OadmOpticalPlugInTableModel(OpticsModuleModel opticsModuleModel) {
        this.module = opticsModuleModel;
        this.fetchValues();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private String getKey(int n) {
        String string = (String)names.get(this.Key[n]);
        if (string == null) {
            string = this.Key[n];
        }
        return string;
    }

    private String getUnits(int n) {
        if (this.Key[n].startsWith("IL")) {
            return "dB";
        }
        return (String)units.get(this.Key[n]);
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.getKey(n);
            }
            case 1: {
                return this.strValue[n];
            }
            case 2: {
                return this.getUnits(n);
            }
        }
        return null;
    }

    private void fetchValues() {
        TreeMap treeMap = new TreeMap();
        treeMap.putAll(this.module.getExtraInfoMap());
        this.Key = new String[treeMap.size()];
        this.strValue = new String[treeMap.size()];
        Iterator iterator = treeMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.Key[n] = (String)iterator.next();
            this.strValue[n] = (String)treeMap.get(this.Key[n]);
            ++n;
        }
    }

    public int getRowCount() {
        return this.Key.length;
    }

    public void refreshFromModel() {
        int n = this.getRowCount();
        this.fetchValues();
        int n2 = this.getRowCount();
        if (n < n2) {
            this.fireTableRowsInserted(n, n2 - 1);
        } else {
            this.fireTableRowsDeleted(n2, n - 1);
        }
        this.fireTableRowsUpdated(0, this.Key.length - 1);
    }

    private String getVendorID(int n) {
        return "Na";
    }

    private String getProductID(int n) {
        return "Na";
    }

    private String getPartNumber(int n) {
        return "Na";
    }

    private String getSerialNumber(int n) {
        return "Na";
    }

    private String getFWVersion(int n) {
        return "Na";
    }

    private String getHWVersion(int n) {
        return "Na";
    }

    public void resetRowDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        this.fireTableRowsUpdated(n, n);
    }

    public void refresh() {
        for (int i = 0; i < this.numPorts; ++i) {
        }
        this.fireTableRowsUpdated(0, this.numPorts - 1);
    }

    public static void main(String[] stringArray) {
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public void destroy() {
        this.models = null;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.rowDirty = null;
    }

    static {
        names.put("VENDOR_NAME", "Vendor ID");
        names.put("VENDOR_P/N", "Part Number");
        names.put("SERIAL_NUMBER", "Serial Number");
        names.put("FW_VERSION", "FW Version");
        names.put("HW_VERSION", "HW Version");
        units.put("VENDOR_NAME", "");
        units.put("VENDOR_P/N", "");
        units.put("SERIAL_NUMBER", "");
        units.put("FW_VERSION", "");
        units.put("HW_VERSION", "");
    }
}

