/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ochterm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Optics.sAlarmThresholds;
import cerent.cms.idl.Optics.sOpticsAlmThresholds;
import cerent.cms.idl.Optics.sOpticsTCAThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.IPortModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.OpticalTableModel;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public class OchOpticalThresholdTableModel
extends AbstractTableModel {
    public static final String[] columnNames = new String[]{"Circuit Name", "Port Name", "Actual Wavelength", "opwrMax (dBm)", "opwrMin (dBm)", "Power Failure Low (dBm)", "Power Degrade High (dBm)", "Power Degrade Low (dBm)"};
    public static final int CIRCUIT_NAME_INDEX = 0;
    public static final int PORT_INDEX = 1;
    public static final int LINENUMBER_INDEX = 2;
    public static final int POWER_HIGH_INDEX = 3;
    public static final int POWER_LOW_INDEX = 4;
    public static final int POWER_FAILURE_LOW_INDEX = 5;
    public static final int POWER_DEGRADE_HIGH_INDEX = 6;
    public static final int POWER_DEGRADE_LOW_INDEX = 7;
    public static final int NA_VALUE = -1000000;
    private int thresholdLayer;
    private sOpticsTCAThresholds[] thresholdsVal;
    private sOpticsAlmThresholds[] AlmThresholdsVal;
    private sAlarmThresholds[] AddAlmThresholdsVal;
    private boolean[][] isDirty;
    private boolean[][] flgFeatureUnsupported;
    private String[] PowerH;
    private String[] PowerL;
    private String[] PowerFailureL;
    private AbstractOpticsLineModel[] model;
    private int numLines = 0;
    private int numChars = 0;
    private OpticsModuleModel oModule;
    private static final SDebug db = new SDebug("OchOpticalThresholdTableModel");

    public OchOpticalThresholdTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray, OpticsModuleModel opticsModuleModel, int n) {
        this.thresholdLayer = n;
        this.oModule = opticsModuleModel;
        this.model = abstractOpticsLineModelArray;
        this.numLines = this.model != null ? this.model.length : 0;
        this.init();
    }

    protected void init() {
        this.flgFeatureUnsupported = new boolean[this.numLines][this.getColumnCount()];
        this.thresholdsVal = new sOpticsTCAThresholds[this.numLines];
        this.AlmThresholdsVal = new sOpticsAlmThresholds[this.numLines];
        this.AddAlmThresholdsVal = new sAlarmThresholds[this.numLines];
        this.PowerL = new String[this.numLines];
        this.PowerH = new String[this.numLines];
        this.PowerFailureL = new String[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.thresholdsVal[i] = null;
            this.AlmThresholdsVal[i] = null;
            this.AddAlmThresholdsVal[i] = null;
            this.PowerH[i] = null;
            this.PowerL[i] = null;
            this.PowerFailureL[i] = null;
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.flgFeatureUnsupported[i][j] = false;
            }
        }
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirtyBits();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 4 || n2 == 3 || n2 == 5) {
            return !this.flgFeatureUnsupported[n][n2];
        }
        return false;
    }

    private boolean isUserAuthorized(SecurityLevel securityLevel) {
        return this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], securityLevel);
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getCircuitName(n);
                }
                case 1: {
                    return this.getPortDescription(n);
                }
                case 2: {
                    return this.getActualWavelength(n);
                }
                case 3: {
                    return this.getPowerHigh(n);
                }
                case 4: {
                    return this.getPowerLow(n);
                }
                case 5: {
                    return this.getFailureLow(n);
                }
                case 6: {
                    return this.getPowerDegradeH(n);
                }
                case 7: {
                    return this.getPowerDegradeL(n);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OchOpticalThresholdTableModel: error in getValueAt" + exception);
            }
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 3: {
                    String string = (String)object;
                    this.PowerH[n] = (String)object;
                    if (OpticalTableModel.isValidNumber(string, "Power High")) {
                        int n3 = OchOpticalThresholdTableModel.ValPerTen(string);
                        if (this.thresholdsVal[n] != null) {
                            this.thresholdsVal[n].opticalPowerPMTh.high = n3;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.PowerH[n] = null;
                    this.getPowerHigh(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 4: {
                    String string = (String)object;
                    this.PowerL[n] = (String)object;
                    if (OpticalTableModel.isValidNumber(string, "Power Low")) {
                        int n4 = OchOpticalThresholdTableModel.ValPerTen(string);
                        if (this.thresholdsVal[n] != null) {
                            this.thresholdsVal[n].opticalPowerPMTh.low = n4;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.PowerL[n] = null;
                    this.getPowerLow(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                case 5: {
                    String string = (String)object;
                    this.PowerFailureL[n] = (String)object;
                    if (OpticalTableModel.isValidNumber(string, "Power failure Low")) {
                        int n5 = OchOpticalThresholdTableModel.ValPerTen(string);
                        if (this.AlmThresholdsVal[n] != null) {
                            this.AlmThresholdsVal[n].opticalPowerAlmTh.fail.low = n5;
                            break;
                        }
                        this.isDirty[n][n2] = false;
                        return;
                    }
                    this.PowerFailureL[n] = null;
                    this.getFailureLow(n);
                    this.fireTableRowsUpdated(0, this.numLines - 1);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            return;
        }
        this.isDirty[n][n2] = bl ? !this.isDirty[n][n2] : true;
        this.fireTableCellUpdated(n, n2);
    }

    protected String getActualWavelength(int n) {
        int n2 = 0;
        if (this.model[n] != null && this.model[n] instanceof OpticsOchTermModel) {
            OpticsOchTermModel opticsOchTermModel = (OpticsOchTermModel)this.model[n];
            try {
                n2 = opticsOchTermModel.getActualWaveLength();
            }
            catch (Exception exception) {
                n2 = 0;
            }
        }
        return n2 == 0 ? "UNKNOWN" : Wavelength.getWavelengthStringFromWavelength(n2);
    }

    protected String getPowerHigh(int n) {
        int n2 = 0;
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.PowerH[n] == null) {
            this.flgFeatureUnsupported[n][3] = true;
            this.PowerH[n] = "N/A";
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_15_MIN, AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.ThType.HIGHIDX);
                        break;
                    }
                    case 1: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_DAY, AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.ThType.HIGHIDX);
                    }
                }
                if (n2 != -1000000) {
                    this.PowerH[n] = this.formatDecimalNumber(n2);
                    this.flgFeatureUnsupported[n][3] = false;
                }
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.PowerH[n];
    }

    protected String getPowerLow(int n) {
        int n2 = 0;
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.PowerL[n] == null) {
            this.flgFeatureUnsupported[n][4] = true;
            this.PowerL[n] = "N/A";
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_15_MIN, AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.ThType.LOWIDX);
                        break;
                    }
                    case 1: {
                        n2 = this.model[n].getOpticsTCAPower(eIntervalType.INTERVAL_DAY, AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.ThType.LOWIDX);
                    }
                }
                if (n2 != -1000000) {
                    this.PowerL[n] = this.formatDecimalNumber(n2);
                    this.flgFeatureUnsupported[n][4] = false;
                }
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.PowerL[n];
    }

    protected String getFailureLow(int n) {
        this.refreshThresholds(n);
        this.refreshAlarmThresholds(n);
        if (this.PowerFailureL[n] == null) {
            this.flgFeatureUnsupported[n][5] = true;
            this.PowerFailureL[n] = "N/A";
            try {
                int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.LevelType.FAIL, AbstractOpticsLineModel.ThType.LOWIDX);
                if (n2 != -1000000) {
                    this.PowerFailureL[n] = this.formatDecimalNumber(n2);
                    this.flgFeatureUnsupported[n][5] = false;
                }
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return this.PowerFailureL[n];
    }

    protected String getPowerDegradeH(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.HIGHIDX);
            if (n2 != -1000000) {
                string = this.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    protected String getPowerDegradeL(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.POWER, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.LOWIDX);
            if (n2 != -1000000) {
                string = this.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    protected String getVOADegradeH(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.VOA, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.HIGHIDX);
            if (n2 != -1000000) {
                string = this.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    protected String getVOADegradeL(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.VOA, AbstractOpticsLineModel.LevelType.DEGRADE, AbstractOpticsLineModel.ThType.LOWIDX);
            if (n2 != -1000000) {
                string = this.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    protected String getVOAFailureL(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOpticsAlm(AbstractOpticsLineModel.TCAAlmType.VOA, AbstractOpticsLineModel.LevelType.FAIL, AbstractOpticsLineModel.ThType.LOWIDX);
            if (n2 != -1000000) {
                string = this.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            KDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    protected String formatDecimalNumber(int n) {
        String string = new Integer(n).toString();
        this.numChars = string.startsWith("-") ? 2 : 1;
        string = string.length() > this.numChars ? string.substring(0, string.length() - 1) + "." + string.substring(string.length() - 1) : (this.numChars == 2 ? string.substring(0, 1) + "0." + string.substring(1, string.length()) : "0." + string);
        return string;
    }

    protected void refreshAlarmThresholds(int n) {
        if (this.AlmThresholdsVal[n] == null) {
            try {
                this.AlmThresholdsVal[n] = this.model[n].getOpticsAlmThresholds();
                if (db.on()) {
                    db.println("Alarm Thresholds val got for line " + n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.AddAlmThresholdsVal[n] == null) {
            try {
                if ((this.model[n].getFeatures() & 0x10) == 16) {
                    this.AddAlmThresholdsVal[n] = this.model[n].getAddPTThresholds();
                    if (db.on()) {
                        db.println("Add Alarm Thresholds val got for line " + n);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void refreshThresholds(int n) {
        if (this.thresholdsVal[n] == null) {
            try {
                switch (this.thresholdLayer) {
                    case 0: {
                        this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_15_MIN);
                        break;
                    }
                    case 1: {
                        this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_DAY);
                    }
                }
                if (db.on()) {
                    db.println("Thresholds val got for line " + n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.refreshLineFromModel(i);
        }
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        try {
            switch (this.thresholdLayer) {
                case 0: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_15_MIN);
                    break;
                }
                case 1: {
                    this.thresholdsVal[n] = this.model[n].getOpticsTCAThresholds(eIntervalType.INTERVAL_DAY);
                    break;
                }
                case 2: {
                    this.AlmThresholdsVal[n] = this.model[n].getOpticsAlmThresholds();
                    if ((this.model[n].getFeatures() & 0x10) != 16) break;
                    this.AddAlmThresholdsVal[n] = this.model[n].getAddPTThresholds();
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        if (n >= this.getRowCount() || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetDirtyBits();
        this.thresholdsVal[n] = null;
        this.AlmThresholdsVal[n] = null;
        this.AddAlmThresholdsVal[n] = null;
        this.PowerH[n] = null;
        this.PowerL[n] = null;
        this.PowerFailureL[n] = null;
    }

    public void applyToModel() throws Exception, ConfigError {
        if (db.on()) {
            db.println("applyToModel");
        }
        int n = 0;
        try {
            if (CerentDialog.yesNoDialog((Component)this.getFrame(), (String)"The selected operation could be service affecting. Is it OK to apply the changes anyway?", (String)"Confirmation Dialog")) {
                block9: for (n = 0; n < this.numLines; ++n) {
                    if (!this.isRowDirty(n)) continue;
                    switch (this.thresholdLayer) {
                        case 0: {
                            this.model[n].setOpticsTCAThresholds(this.thresholdsVal[n], eIntervalType.INTERVAL_15_MIN);
                            continue block9;
                        }
                        case 1: {
                            this.model[n].setOpticsTCAThresholds(this.thresholdsVal[n], eIntervalType.INTERVAL_DAY);
                            continue block9;
                        }
                        case 2: {
                            this.model[n].setOpticsAlmThresholds(this.AlmThresholdsVal[n]);
                            if ((this.model[n].getFeatures() & 0x10) != 16) continue block9;
                            this.model[n].setAddPTThresholds(this.AddAlmThresholdsVal[n]);
                        }
                    }
                }
            }
            this.resetDirtyBits();
        }
        catch (ConfigError configError) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ACTION_NOTALLOWED);
            this.refreshFromModel();
        }
        catch (ProvisionError provisionError) {
            this.displayError(provisionError);
            this.refreshFromModel();
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_WRONG_INPUT);
            this.refreshFromModel();
        }
    }

    private void displayError(ProvisionError provisionError) {
        int n = provisionError.getDiscriminator();
        switch (n) {
            case 3: {
                ErrorMsg.displayError(this.getFrame(), EMC.EID_VALUE_RANGE_ERROR_PARAM_3, "Power Failure Low", ConvertPwrToDb.formatDecimalNumber(provisionError.getLoValue()), ConvertPwrToDb.formatDecimalNumber(provisionError.getHiValue()));
                break;
            }
            case 4: {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_POWER_FAILURE_LOW_VALUE);
                break;
            }
            case 0: {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_POWER_FAILURE_LOW_TH);
                break;
            }
            case 5: {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_POWER_FAILURE_LOW_TCA);
                break;
            }
            default: {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_GENERIC_PROV_ERROR);
            }
        }
    }

    public synchronized void setOchTermModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        this.model = abstractOpticsLineModelArray;
        this.numLines = this.model == null ? 0 : this.model.length;
        this.init();
        this.refreshFromModel();
        this.fireTableDataChanged();
    }

    public static int ValPerTen(String string) {
        float f = Float.parseFloat(string);
        int n = (int)(f *= 10.0f);
        return n;
    }

    protected Frame getFrame() {
        return this.oModule.getNodeModelDelegate().getUiToolkit().getApplicationFrame();
    }

    protected String getCircuitName(int n) {
        return ((OpticsOchTermModel)this.model[n]).getCircuitName();
    }

    public void enteringPage() {
        this.numLines = this.model == null ? 0 : this.model.length;
    }

    private String getPortDescription(int n) {
        String string;
        Object object;
        try {
            object = this.model[n].getPortModel();
            string = PortHelper.getPortNumString((IPortModel)object);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            string = String.valueOf(n + 1);
        }
        object = string + " (" + this.getType(n) + ")";
        return object;
    }

    private String getType(int n) {
        try {
            return this.model[n].getOptPortTypeString();
        }
        catch (Exception exception) {
            return "N/A";
        }
    }
}

