/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ochterm;

import cerent.cms.idl.Optics.eVOAForceStatus;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.OpticalTableModel;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.KDebug;
import cerent.util.SDebug;

public class OchParametersTableModel
extends OpticalTableModel {
    public static final int CIRCUIT_NAME_INDEX = 14;
    public static final int FROM_SIDE_INDEX = 15;
    public static final int TO_SIDE_INDEX = 16;
    public static final int ACTUAL_POWER_TO_INDEX = 17;
    public static final int ACTUAL_WAVEL_INDEX = 18;
    public static final int FORCE_VOA_ENABLE_INDEX = 19;
    public static final int FORCE_VOA_CHAN_STARTUP = 20;
    protected static final String OVERLOAD = "Overload";
    public static String[] columnNames = new String[]{"Circuit Name", "From", "To", "Power To", "Actual Wavelength", "Force Channel", "Force Channel Status"};
    private int[] actualWavelength;
    private String[] forceVOAEnable;
    private static final SDebug db = new SDebug("OchParametersTableModel");

    public OchParametersTableModel(OpticsOchTermModel[] opticsOchTermModelArray, OpticsModuleModel opticsModuleModel) {
        super(db, opticsOchTermModelArray, opticsModuleModel);
        this.otmColumnNames[5] = "Power From";
    }

    protected void init() {
        this.actualWavelength = new int[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.actualWavelength[i] = 0;
        }
        this.forceVOAEnable = new String[this.numLines];
        super.init();
    }

    public int getColumnCount() {
        return super.getColumnCount() + columnNames.length;
    }

    public String getColumnName(int n) {
        if (n < 14) {
            return super.getColumnName(n);
        }
        return columnNames[n - 14];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 14: {
                    return this.getCircuitName(n);
                }
                case 15: {
                    return this.getFrom(n);
                }
                case 16: {
                    return this.getTo(n);
                }
                case 5: {
                    return this.getActToPower(n);
                }
                case 17: {
                    return this.getActPower(n);
                }
                case 18: {
                    return this.getActualWavelength(n);
                }
                case 19: {
                    return this.getForceVoaEnable(n);
                }
                case 20: {
                    return this.getForceChannelStartup(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OchParametersTableModel: error in getValueAt" + exception);
            }
            KDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        boolean bl = false;
        try {
            switch (n2) {
                case 19: {
                    String string = (String)object;
                    if (this.forceVOAEnable[n].equals(string)) {
                        return;
                    }
                    if (!this.Flg_FeatureUnsupported[n][19]) {
                        this.forceVOAEnable[n] = string;
                        this.isDirty[n][19] = true;
                        break;
                    }
                    this.forceVOAEnable[n] = "N/A";
                    break;
                }
                default: {
                    super.setValueAt(object, n, n2);
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            KDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.fireTableCellUpdated(n, n2);
    }

    protected String getActualWavelength(int n) {
        if (this.actualWavelength[n] == 0 && this.model[n] != null && this.model[n] instanceof OpticsOchTermModel) {
            OpticsOchTermModel opticsOchTermModel = (OpticsOchTermModel)this.model[n];
            try {
                this.actualWavelength[n] = opticsOchTermModel.getActualWaveLength();
            }
            catch (Exception exception) {
                this.actualWavelength[n] = 0;
            }
        }
        return this.actualWavelength[n] == 0 ? "UNKNOWN" : Wavelength.getWavelengthStringFromWavelength(this.actualWavelength[n]);
    }

    protected String getActPower(int n) {
        String string = "N/A";
        int n2 = -1000000;
        AbstractOpticsLineModel abstractOpticsLineModel = this.model[n];
        try {
            n2 = ((OpticsOchTermModel)this.model[n]).getActPower();
            string = n2 == -1000000 ? OVERLOAD : ConvertPwrToDb.formatDecimalNumber(n2);
        }
        catch (InternalCommError internalCommError) {
            KDebug.printStackTrace((Throwable)internalCommError);
            string = "N/A";
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
            string = "N/A";
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
            string = "N/A";
        }
        catch (FeatureUnsupported featureUnsupported) {
            KDebug.printStackTrace((Throwable)featureUnsupported);
            string = "N/A";
        }
        return string;
    }

    private String getActToPower(int n) {
        String string = "N/A";
        int n2 = -1000000;
        try {
            n2 = ((OpticsOchTermModel)this.model[n]).getActualToPower();
            string = n2 == -1000000 ? OVERLOAD : ConvertPwrToDb.formatDecimalNumber(n2);
        }
        catch (InternalCommError internalCommError) {
            KDebug.printStackTrace((Throwable)internalCommError);
            string = "N/A";
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
            string = "N/A";
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
            string = "N/A";
        }
        catch (FeatureUnsupported featureUnsupported) {
            KDebug.printStackTrace((Throwable)featureUnsupported);
            string = "N/A";
        }
        return string;
    }

    private String getFrom(int n) {
        IPortModel iPortModel = ((OpticsOchTermModel)this.model[n]).getOchFromPortModel();
        return this.fillPortValue(iPortModel);
    }

    private String getTo(int n) {
        IPortModel iPortModel = ((OpticsOchTermModel)this.model[n]).getOchToPortModel();
        return this.fillPortValue(iPortModel);
    }

    private String fillPortValue(IPortModel iPortModel) {
        String string = null;
        try {
            String string2 = PortHelper.getPortNumString((IPortModel)iPortModel);
            string = string2 + " (" + ((AbstractOpticsLineModel)iPortModel.getInterfaceModel()).getPortTypeString() + ")";
        }
        catch (NoSuchInterface noSuchInterface) {
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            KDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return string;
    }

    public void refreshLineFromModel(int n) {
        if (n >= this.getRowCount() || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.getActualWavelength(n);
        this.getFrom(n);
        this.getTo(n);
        this.getCircuitName(n);
        this.getActPower(n);
        this.getForceChannelStartup(n);
        this.getForceVoaEnable(n);
        this.getActToPower(n);
        super.refreshLineFromModel(n);
    }

    protected void resetLineCache(int n) {
        super.resetLineCache(n);
        this.actualWavelength[n] = 0;
        this.forceVOAEnable[n] = null;
    }

    public synchronized void setOchTermModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        this.model = abstractOpticsLineModelArray;
        int n = this.numLines = this.model == null ? 0 : this.model.length;
        if (this.eqpmtModel == null) {
            try {
                this.eqpmtModel = this.model[0].getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("problems with the update of the first circuit");
                return;
            }
        }
        this.init();
        this.refreshFromModel();
        this.fireTableDataChanged();
    }

    private String getCircuitName(int n) {
        return ((OpticsOchTermModel)this.model[n]).getCircuitName();
    }

    void setHideAllRows() {
        this.numLines = 0;
    }

    private String getForceVoaEnable(int n) {
        if (this.forceVOAEnable[n] == null) {
            this.forceVOAEnable[n] = this.initForceVoaEnable(n);
        }
        return this.forceVOAEnable[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return false;
        }
        if (n2 == 19) {
            return true;
        }
        return super.isCellEditable(n, n2);
    }

    public void applyToModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isDirty[i][19]) continue;
            this.forceVOAEnable(i);
        }
        super.applyToModel();
    }

    private void forceVOAEnable(int n) throws FeatureUnsupported, WrongInterfaceType, NoSuchInterface, ProvisionError {
        OpticsOchTermModel opticsOchTermModel = (OpticsOchTermModel)this.model[n];
        boolean bl = this.getForceVoaEnable(n).compareTo("ON") == 0;
        if (opticsOchTermModel.isForceVOASupported()) {
            opticsOchTermModel.setForceVoaEnable(bl);
        }
    }

    private String getForceChannelStartup(int n) {
        String string = "N/A";
        try {
            string = this.enumToVoaStatus(((OpticsOchTermModel)this.model[n]).getForceVoaStatus());
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return string;
    }

    private String initForceVoaEnable(int n) {
        String string = "N/A";
        this.Flg_FeatureUnsupported[n][19] = true;
        try {
            string = ((OpticsOchTermModel)this.model[n]).getForceVoaEnable() ? "ON" : "OFF";
            this.Flg_FeatureUnsupported[n][19] = false;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (FeatureUnsupported featureUnsupported) {
            SDebug.printStackTrace((Throwable)featureUnsupported);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return string;
    }

    private String enumToVoaStatus(eVOAForceStatus eVOAForceStatus2) {
        String string = null;
        switch (eVOAForceStatus2.value()) {
            case 0: {
                string = "Unlocked";
                break;
            }
            case 2: {
                string = "Locked";
                break;
            }
            case 1: {
                string = "Forced";
            }
        }
        return string;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return super.getColumnClass(n);
    }
}

