/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sLineThresholds;
import cerent.cms.model.ConfigError;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.GeneralPmThresholdsPane;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.oscm.OscmLinePmThresholdsTableModel;
import cerent.cms.ui.oscm.OscmSdhLinePmThresholdsTableModel;
import cerent.cms.ui.oscm.OscmSonetLinePmThresholdsTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class OscmLinePmThresholdsPane
extends GeneralPmThresholdsPane
implements TableModelListener {
    protected OscmLinePmThresholdsTableModel dataModel = null;
    protected TdmLineModel[] lineModels = null;
    protected OpticsModuleModel eqpmtModel = null;
    protected eIntervalType intervalType = null;
    protected boolean nearEnd = false;
    protected int numLines = 0;
    private static final SDebug db = new SDebug("TdmLinePmThresholdsPane");

    public OscmLinePmThresholdsPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(string, tabbedView);
        this.lineModels = tdmLineModelArray;
        this.numLines = this.lineModels == null ? 0 : 1;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.dataModel = this.getTableModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(225);
        for (int i = 1; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(50);
        }
        this.registerWithModel();
        this.add((Component)uScrollPane);
    }

    protected OscmLinePmThresholdsTableModel getTableModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        OscmLinePmThresholdsTableModel oscmLinePmThresholdsTableModel = iNodeModel.getTdmProtocolTypeObj().isSdh() ? new OscmSdhLinePmThresholdsTableModel(iNodeModel, this.lineModels, this.intervalType, this.nearEnd) : new OscmSonetLinePmThresholdsTableModel(iNodeModel, this.lineModels, this.intervalType, this.nearEnd);
        return oscmLinePmThresholdsTableModel;
    }

    protected ResettablePmThresholdsTableModel dataModel() {
        return this.dataModel;
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                OscmLinePmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In TdmLinePmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.printThresholds(this.dataModel.getThresholdsVal(n));
                this.lineModels[n].setLinePmThresholds(this.intervalType, this.nearEnd, this.dataModel.getThresholdsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (ConfigError configError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_CHANGE_ROW_PARAM_1, (Object)Integer.toString(n + 1));
        }
        catch (Exception exception) {
            throw new AnnotatedException(ErrorMsg.getString((EID)EMC.EID_ERROR_CHANGE_ROW_PARAM_1, (Object)Integer.toString(n + 1)), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.numLines - 1 ? this.numLines - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void printThresholds(sLineThresholds sLineThresholds2) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("CV " + sLineThresholds2.cv);
            db.println("ES " + sLineThresholds2.es);
            db.println("SES " + sLineThresholds2.ses);
            db.println("BBE " + sLineThresholds2.bbe);
            db.println("FC " + sLineThresholds2.fc);
            db.println("PSC " + sLineThresholds2.psc);
            db.println("PSD " + sLineThresholds2.psd);
            db.println("UAS " + sLineThresholds2.uas);
            db.println("===============================================");
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.OscmLinePmThresholdsPane;
    }
}

