/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.SonetMedia.sLineThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;

public abstract class OscmLinePmThresholdsTableModel
extends TdmTableModel
implements ResettablePmThresholdsTableModel {
    protected boolean[] rowDirty = null;
    protected sLineThresholds[] thresholdsVal;
    protected eIntervalType intervalType;
    protected boolean nearEnd = false;
    protected EntityCellRenderer myPortRenderer;
    protected String[] columnNames;
    private static final SDebug db = new SDebug("SonetPmThresholdsTableMode");

    public OscmLinePmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(iNodeModel);
        this.model = tdmLineModelArray;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        if (this.model == null) {
            if (db.on()) {
                db.println("Model null");
            }
            this.numLines = 0;
        } else {
            this.numLines = 1;
        }
        this.initColumnNames();
        this.init();
    }

    protected abstract void initColumnNames();

    private void init() {
        this.myPortRenderer = new EntityCellRenderer();
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sLineThresholds[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
            this.thresholdsVal[i] = null;
        }
    }

    protected void refreshPmThresholds(int n) {
        if (this.thresholdsVal[n] == null) {
            try {
                this.thresholdsVal[n] = this.model[n].getLinePmThresholds(this.intervalType, this.nearEnd);
                if (db.on()) {
                    db.println("Thresholds val got for line " + n);
                }
                this.printThresholds(this.thresholdsVal[n]);
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_ERROR_GETTING_THRESHOLD);
            }
        }
    }

    public void markRowDirty(int n) {
        this.rowDirty[n] = true;
    }

    public boolean resetToDefaultByLine() {
        return false;
    }

    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        eEqType eEqType2 = this.model[n].getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.model[n].getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefLineThr(eEqType2, eEqType3, this.nearEnd, this.intervalType);
    }

    public void setThresholdValue(int n, Object object) {
        if (object instanceof sLineThresholds) {
            this.thresholdsVal[n] = (sLineThresholds)object;
        }
    }

    protected int getEs(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].es;
    }

    protected int getCv(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].cv;
    }

    protected int getSes(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].ses;
    }

    protected int getFc(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].fc;
    }

    protected int getPsc(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].psc;
    }

    protected int getPsd(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].psd;
    }

    protected int getPscW(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].pscw;
    }

    protected int getPsdW(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].psdw;
    }

    protected int getPscS(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].pscs;
    }

    protected int getPsdS(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].psds;
    }

    protected int getPscR(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].pscr;
    }

    protected int getPsdR(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].psdr;
    }

    protected int getUas(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].uas;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return Integer.class;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public sLineThresholds getThresholdsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.thresholdsVal[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public void refreshLineFromModel(int n) {
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.thresholdsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    private void printThresholds(sLineThresholds sLineThresholds2) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("CV " + sLineThresholds2.cv);
            db.println("ES " + sLineThresholds2.es);
            db.println("SES " + sLineThresholds2.ses);
            db.println("FC " + sLineThresholds2.fc);
            db.println("PSC " + sLineThresholds2.psc);
            db.println("PSD " + sLineThresholds2.psd);
            db.println("UAS " + sLineThresholds2.uas);
            db.println("BBE " + sLineThresholds2.bbe);
            db.println("===============================================");
        }
    }
}

