/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.oscm;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.OpticalTableModel;
import cerent.util.KDebug;
import cerent.util.SDebug;

public class OscmOTSTableModel
extends OpticalTableModel {
    public static final int OSC_POWER_INDEX = 14;
    public static String[] columnNames = new String[]{"OSC Power"};
    private String[] oscPower;
    private static final SDebug db = new SDebug("OscmOTSTableModel");

    public OscmOTSTableModel(AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(db, abstractOpticsLineModelArray);
        this.oscPower = new String[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.oscPower[i] = null;
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return super.getColumnCount() + columnNames.length;
    }

    public String getColumnName(int n) {
        if (n < 14) {
            return super.getColumnName(n);
        }
        return columnNames[n - 14];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 14: {
                    return this.getOSCPower(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OscmOTSTableModel: error in getValueAt" + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        if (db.on()) {
            db.println("refresh from model line: " + n);
        }
        this.resetLineCache(n);
        this.oscPower[n] = this.getOSCPowerFromUnit(n);
        super.refreshLineFromModel(n);
    }

    protected void resetLineCache(int n) {
        super.resetLineCache(n);
        this.oscPower[n] = null;
    }

    protected String getOSCPowerFromUnit(int n) {
        String string = "N/A";
        try {
            int n2 = this.model[n].getOSCPower();
            if (n2 != -1000000) {
                string = ConvertPwrToDb.formatDecimalNumber(n2);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    public String getOSCPower(int n) {
        return this.oscPower[n];
    }
}

