/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.SonetMedia.sLineStats;
import cerent.cms.idl.SonetMedia.sSectionStats;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmLineStats;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public abstract class AbstractPmLayerTdmLine
extends PmLayer {
    protected sLineStats[] lineStatsVal;
    protected TdmLineModel model = null;
    protected int numRegisters;
    protected sSectionStats[] sectionStatsVal;
    protected String[] parmNames;
    private static final sSectionStats _defaultSectionStats = new sSectionStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
    private static final sLineStats _defaultLineStats = new sLineStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);

    public AbstractPmLayerTdmLine(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n, boolean bl) {
        super(pmTableModel, tdmLineModel, bl);
        this.model = tdmLineModel;
        this.numRegisters = n;
        this.sectionStatsVal = new sSectionStats[n];
        this.lineStatsVal = new sLineStats[n];
        this.tossData();
    }

    public AbstractPmLayerTdmLine(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n) {
        this(pmTableModel, tdmLineModel, n, true);
    }

    public void clearStats() {
        try {
            this.model.clearStats(this.nearEnd, this.intervalType);
        }
        catch (InternalCommError internalCommError) {
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public String layerLabel() {
        return "Line";
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.sectionStatsVal[i] = null;
            this.lineStatsVal[i] = null;
        }
    }

    public String parmName(int n) {
        return this.parmNames[n];
    }

    public int parmCount() {
        return this.parmNames.length;
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.model = (TdmLineModel)interfaceModel;
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.sectionStatsVal[n] == null || this.lineStatsVal[n] == null || this.sectionStatsVal[n] == _defaultSectionStats || this.lineStatsVal[n] == _defaultLineStats) {
            this.sectionStatsVal[n] = _defaultSectionStats;
            this.lineStatsVal[n] = _defaultLineStats;
            TdmLineStats tdmLineStats = this.model.getStats(this.nearEnd, this.intervalType, (short)n);
            this.sectionStatsVal[n] = tdmLineStats.sectionStats;
            this.lineStatsVal[n] = tdmLineStats.lineStats;
        }
    }
}

