/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sPmStat64;
import cerent.cms.idl.Common.sPmStatRatio;
import cerent.cms.model.ConfigError;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmTableModel;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.TableModelEvent;

public abstract class PmLayer
implements Observer {
    public boolean nearEnd = true;
    public eIntervalType intervalType = eIntervalType.INTERVAL_15_MIN;
    public InterfaceModel ifModel;
    public PmTableModel tblModel;
    protected static final sPmStat PM_STATS_INVALID = new sPmStat(-1, false);
    protected static final sPmStat PM_STATS_VALID = new sPmStat(-1, true);
    protected static final sPmStat64 PM_STATS_64_INVALID = new sPmStat64(-1L, false);
    protected static final sPmStatRatio PM_STATS_RATIO_INVALID = new sPmStatRatio(-1, false);
    protected boolean fromPeerCard = false;
    protected boolean supportsFarEnd = false;

    public PmLayer() {
    }

    public PmLayer(PmTableModel pmTableModel, Object object) {
        this(pmTableModel, object, false);
    }

    public PmLayer(PmTableModel pmTableModel, Object object, boolean bl) {
        this();
        this.tblModel = pmTableModel;
        if (object instanceof InterfaceModel) {
            this.ifModel = (InterfaceModel)object;
            this.ifModel.addObserver(this);
        }
        this.supportsFarEnd = bl;
    }

    public boolean hasFarEnd() {
        return this.supportsFarEnd;
    }

    public void setNearEnd(boolean bl) {
        this.nearEnd = bl;
    }

    public void setIntervalType(eIntervalType eIntervalType2) {
        this.intervalType = eIntervalType2;
    }

    public boolean isHigherPmDisplayed() {
        return true;
    }

    public boolean disableFarEnd() {
        return false;
    }

    public boolean isFromPeerCard() {
        return this.fromPeerCard;
    }

    public boolean needsRebuild() {
        return false;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n == ModelUpdateType.DELETED) {
                this.destroy();
                this.refreshParent();
            } else if (n == ModelUpdateType.ADDED) {
                this.refreshParent();
            }
        }
    }

    public void refreshParent() {
        if (this.tblModel == null) {
            return;
        }
        this.tblModel.fireTableChanged(new TableModelEvent(this.tblModel, -1, -1, -1, -100));
    }

    public void destroy() {
        if (this.ifModel != null) {
            this.ifModel.deleteObserver(this);
        }
        this.ifModel = null;
        this.tblModel = null;
    }

    public void clearStats(String[] stringArray) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
    }

    public void clearAllStatsForCard() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
    }

    public void clearAllStatsForLine() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
    }

    public abstract void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation;

    public abstract Object getPmValue(int var1, int var2) throws NoSuchInterface, WrongInterfaceType, InternalCommError;

    public abstract String layerLabel();

    public abstract int parmCount();

    public abstract void refreshPmStats(int var1) throws NoSuchInterface, WrongInterfaceType, InternalCommError;

    public abstract String parmName(int var1);

    public abstract void setModel(InterfaceModel var1);

    public abstract void tossData();
}

