/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat64;
import cerent.cms.idl.Dwdm.sDwdmFECPmStats;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public class PmLayerFEC
extends PmLayer {
    protected DwdmTrkLineModel model = null;
    protected int numRegisters;
    protected sDwdmFECPmStats[] statsVal;
    public static final String[] parmNames = new String[]{"Bit Errors", "Uncorrectable Words"};
    public static final int FEC_BIT_ERR = 0;
    public static final int FEC_UNCOR_WDS = 1;
    private static final sDwdmFECPmStats _defaultFecStats = new sDwdmFECPmStats(PM_STATS_64_INVALID, PM_STATS_64_INVALID, PM_STATS_64_INVALID, PM_STATS_64_INVALID, PM_STATS_64_INVALID);
    private static final SDebug db = new SDebug("PmLayerFEC");

    public PmLayerFEC(PmTableModel pmTableModel, DwdmTrkLineModel dwdmTrkLineModel, int n) {
        this.model = dwdmTrkLineModel;
        this.numRegisters = n;
        this.statsVal = new sDwdmFECPmStats[n];
        this.tossData();
    }

    public void clearStats() {
        try {
            this.model.clearFECStats(this.intervalType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        switch (n) {
            case 0: {
                return new PmRendererStat(this.statsVal[n2].bitErrCor);
            }
            case 1: {
                return new PmRendererStat(this.statsVal[n2].uncorWords);
            }
        }
        db.println("WARNING: PmLayerFEC.getPmValue needs updating, unknown value " + n);
        return null;
    }

    public String layerLabel() {
        return "Port";
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            if (this.statsVal[n] == null || this.statsVal[n] == _defaultFecStats) {
                this.statsVal[n] = _defaultFecStats;
                this.statsVal[n] = this.model.getFECStats(this.intervalType, (short)n);
                if (db.on() && n == 0) {
                    this.printStats(0);
                }
            }
        }
        catch (InternalCommError internalCommError) {
            this.statsVal[n] = new sDwdmFECPmStats(PM_STATS_64_INVALID, PM_STATS_64_INVALID, PM_STATS_64_INVALID, PM_STATS_64_INVALID, PM_STATS_64_INVALID);
            throw internalCommError;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
    }

    private void printStats(int n) {
        db.println("FEC bitErrCor=" + this.strPmStat64(this.statsVal[n].bitErrCor) + " uncorWords=" + this.strPmStat64(this.statsVal[n].uncorWords));
    }

    private String strPmStat64(sPmStat64 sPmStat642) {
        if (sPmStat642.valid) {
            return Long.toString(sPmStat642.cnt);
        }
        return "#";
    }

    public String parmName(int n) {
        return parmNames[n];
    }

    public int parmCount() {
        return parmNames.length;
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.model = (DwdmTrkLineModel)interfaceModel;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.statsVal[i] = null;
        }
    }

    public boolean isHigherPmDisplayed() {
        return false;
    }
}

