/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sPmStatRatio;
import cerent.cms.idl.SonetMedia.sVtStats;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class PmLayerLoPath
extends PmLayer {
    protected TdmLoModel model;
    protected int numParms;
    protected int numRegisters;
    protected sVtStats[] statsVal;
    public static String[] parmNames;
    public static final int CV_V_INDEX = 0;
    public static final int ES_V_INDEX = 1;
    public static final int FC_V_INDEX = 2;
    public static final int SES_V_INDEX = 3;
    public static final int UAS_V_INDEX = 4;
    public static final int SDH_BBE_V_INDEX = 5;
    public static final int SDH_ESR_V_INDEX = 6;
    public static final int SDH_SESR_V_INDEX = 7;
    public static final int SDH_BBER_V_INDEX = 8;
    private static final sVtStats _defaultVtStats;
    protected static final SDebug db;

    public PmLayerLoPath(PmTableModel pmTableModel, TdmLoModel tdmLoModel, int n, boolean bl) {
        super(pmTableModel, tdmLoModel, bl);
        this.model = tdmLoModel;
        this.initParmName();
        this.numRegisters = n;
        this.numParms = parmNames.length;
        this.statsVal = new sVtStats[n];
        for (int i = 0; i < n; ++i) {
            this.statsVal[i] = null;
        }
    }

    public PmLayerLoPath(PmTableModel pmTableModel, TdmLoModel tdmLoModel, int n) {
        this(pmTableModel, tdmLoModel, n, true);
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearStats(this.nearEnd, this.intervalType);
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_INVALID;
        sPmStatRatio sPmStatRatio2 = PM_STATS_RATIO_INVALID;
        boolean bl = false;
        if (PmLayerLoPath.db.on) {
            db.println("entering getPmValue - row= " + n + ", interval= " + n2);
        }
        switch (n) {
            case 0: {
                sPmStat2 = this.statsVal[n2].cv;
                break;
            }
            case 1: {
                sPmStat2 = this.statsVal[n2].es;
                break;
            }
            case 2: {
                sPmStat2 = this.statsVal[n2].fc;
                break;
            }
            case 3: {
                sPmStat2 = this.statsVal[n2].ses;
                break;
            }
            case 4: {
                sPmStat2 = this.statsVal[n2].uas;
                break;
            }
            case 5: {
                sPmStat2 = this.statsVal[n2].bbe;
                break;
            }
            case 6: {
                sPmStatRatio2 = this.statsVal[n2].esr;
                bl = true;
                break;
            }
            case 7: {
                sPmStatRatio2 = this.statsVal[n2].sesr;
                bl = true;
                break;
            }
            case 8: {
                sPmStatRatio2 = this.statsVal[n2].bber;
                bl = true;
            }
        }
        if (bl) {
            return new PmRendererStatRatio(sPmStatRatio2);
        }
        return new PmRendererStat(sPmStat2);
    }

    public String layerLabel() {
        String string = "VT";
        TDMTerminology tDMTerminology = this.model.getNodeModel().getTDMTerminology();
        try {
            string = tDMTerminology.getGeneralTerms(1);
        }
        catch (Exception exception) {
            db.finer("Exception in layerLabel() " + exception);
        }
        return string;
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.statsVal[n] == null || this.statsVal[n] == _defaultVtStats) {
            boolean bl = this.fromPeerCard;
            this.statsVal[n] = _defaultVtStats;
            try {
                this.statsVal[n] = this.model.getStats(this.nearEnd, this.intervalType, (short)n);
            }
            catch (InternalCommError internalCommError) {
                this.statsVal[n] = new sVtStats(false, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
                throw internalCommError;
            }
            this.fromPeerCard = this.statsVal[n].fromPeerCard;
            if (db.on() && bl != this.fromPeerCard) {
                db.println("Vt fromPeerCard changed from " + bl + " to " + this.fromPeerCard);
            }
        }
    }

    public String parmName(int n) {
        return parmNames[n];
    }

    protected void initParmName() {
        TDMTerminology tDMTerminology = this.model.getNodeModel().getTDMTerminology();
        if (this.model.getNodeModel().getTdmProtocolTypeObj().isSonet()) {
            parmNames = new String[5];
            PmLayerLoPath.parmNames[0] = tDMTerminology.createPmColumnName(5, 1);
            PmLayerLoPath.parmNames[1] = tDMTerminology.createPmColumnName(5, 2);
            PmLayerLoPath.parmNames[2] = tDMTerminology.createPmColumnName(5, 0);
            PmLayerLoPath.parmNames[3] = tDMTerminology.createPmColumnName(5, 3);
            PmLayerLoPath.parmNames[4] = tDMTerminology.createPmColumnName(5, 9);
        } else {
            parmNames = new String[9];
            PmLayerLoPath.parmNames[0] = tDMTerminology.createPmColumnName(5, 1);
            PmLayerLoPath.parmNames[1] = tDMTerminology.createPmColumnName(5, 2);
            PmLayerLoPath.parmNames[2] = tDMTerminology.createPmColumnName(5, 0);
            PmLayerLoPath.parmNames[3] = tDMTerminology.createPmColumnName(5, 3);
            PmLayerLoPath.parmNames[4] = tDMTerminology.createPmColumnName(5, 9);
            PmLayerLoPath.parmNames[5] = tDMTerminology.createPmColumnName(5, 5);
            PmLayerLoPath.parmNames[6] = tDMTerminology.createPmColumnName(5, 6);
            PmLayerLoPath.parmNames[7] = tDMTerminology.createPmColumnName(5, 7);
            PmLayerLoPath.parmNames[8] = tDMTerminology.createPmColumnName(5, 8);
        }
    }

    public int parmCount() {
        return parmNames.length;
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.model = (TdmLoModel)interfaceModel;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.statsVal[i] = null;
        }
        this.fromPeerCard = false;
    }

    static {
        _defaultVtStats = new sVtStats(false, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
        db = new SDebug("PmLayerLoPath");
    }
}

