/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sPmStatRatio;
import cerent.cms.idl.Common.sStsInfo;
import cerent.cms.idl.SonetMedia.sPathStats;
import cerent.cms.idl.SonetMedia.sPathStats600;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.LinePathHolder;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmProtocolType;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmRendererStatRatio;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.SwingUtilities;

public class PmLayerSonetStsPjc
extends PmLayer {
    protected sPathStats600[] pathStatsVal;
    protected TdmHoModel model;
    protected LinePathHolder lpHolder = null;
    protected boolean lpHolderValid;
    protected int numRegisters;
    public String[] parmNames;
    protected static final int CV_P_INDEX = 0;
    protected static final int ES_P_INDEX = 1;
    protected static final int FC_P_INDEX = 2;
    protected static final int SES_P_INDEX = 3;
    protected static final int UAS_P_INDEX = 4;
    protected static final int PJP_IN_INDEX = 5;
    protected static final int PJN_IN_INDEX = 6;
    protected static final int PJP_OUT_INDEX = 7;
    protected static final int PJN_OUT_INDEX = 8;
    protected static final int ESR_P_INDEX = 9;
    protected static final int SESR_P_INDEX = 10;
    protected static final int BBER_P_INDEX = 11;
    protected static final int BBE_P_INDEX = 12;
    public static final int SONET_INDEX_LEN = 9;
    public static final int SDH_INDEX_LEN = 13;
    private int protocolType;
    private TDMTerminology terms;
    protected static final sPathStats600 _defaultPathStats = PmLayerSonetStsPjc.getDefaultPathStats();
    private static final SDebug db = new SDebug("PmLayerSonetStsPjc");

    public PmLayerSonetStsPjc(PmTableModel pmTableModel, Object object, int n, boolean bl) {
        super(pmTableModel, object, bl);
        if (object instanceof TdmHoModel) {
            this.model = (TdmHoModel)object;
            this.protocolType = this.model.getNodeModel().getTdmProtocolType();
            this.terms = this.model.getNodeModel().getTDMTerminology();
        } else if (object instanceof LinePathHolder) {
            this.lpHolder = (LinePathHolder)object;
            this.protocolType = this.lpHolder.getLineModel().getNodeModel().getTdmProtocolType();
            this.terms = this.lpHolder.getLineModel().getNodeModel().getTDMTerminology();
        }
        this.lpHolderValid = true;
        this.numRegisters = n;
        this.pathStatsVal = new sPathStats600[this.numRegisters];
        this.initParamNames();
    }

    public PmLayerSonetStsPjc(PmTableModel pmTableModel, Object object, int n) {
        this(pmTableModel, object, n, true);
    }

    public static sPathStats600 getDefaultPathStats() {
        return new sPathStats600(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearPathStats(this.nearEnd, this.intervalType);
    }

    public void clearStats(String[] stringArray) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearStatsPerParam(this.nearEnd, this.intervalType, stringArray);
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_INVALID;
        sPmStatRatio sPmStatRatio2 = PM_STATS_RATIO_INVALID;
        boolean bl = false;
        this.refreshPmStats(n2);
        switch (n) {
            case 0: {
                sPmStat2 = this.pathStatsVal[n2].cv;
                break;
            }
            case 1: {
                sPmStat2 = this.pathStatsVal[n2].es;
                break;
            }
            case 2: {
                sPmStat2 = this.pathStatsVal[n2].fc;
                break;
            }
            case 3: {
                sPmStat2 = this.pathStatsVal[n2].ses;
                break;
            }
            case 4: {
                sPmStat2 = this.pathStatsVal[n2].uas;
                break;
            }
            case 5: {
                sPmStat2 = this.pathStatsVal[n2].pjpIn;
                break;
            }
            case 6: {
                sPmStat2 = this.pathStatsVal[n2].pjnIn;
                break;
            }
            case 7: {
                sPmStat2 = this.pathStatsVal[n2].pjpOut;
                break;
            }
            case 8: {
                sPmStat2 = this.pathStatsVal[n2].pjnOut;
                break;
            }
            case 12: {
                sPmStat2 = this.pathStatsVal[n2].bbe;
                break;
            }
            case 9: {
                sPmStatRatio2 = this.pathStatsVal[n2].esr;
                bl = true;
                break;
            }
            case 10: {
                sPmStatRatio2 = this.pathStatsVal[n2].sesr;
                bl = true;
                break;
            }
            case 11: {
                sPmStatRatio2 = this.pathStatsVal[n2].bber;
                bl = true;
            }
        }
        if (bl) {
            return new PmRendererStatRatio(sPmStatRatio2);
        }
        return new PmRendererStat(sPmStat2);
    }

    public String layerLabel() {
        boolean bl = TdmProtocolType.getTdmProtocolType((int)this.protocolType).isSdh();
        if (bl) {
            return "VC3/VC4";
        }
        return "STS";
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.pathStatsVal[n] == null || this.pathStatsVal[n].equals(_defaultPathStats)) {
            if (this.model != null) {
                int n2 = this.intervalType == eIntervalType.INTERVAL_15_MIN ? this.numRegisters : this.numRegisters - 4;
                sPathStats600[] sPathStats600Array = new sPathStats600[this.numRegisters];
                for (int i = 0; i < n2; ++i) {
                    this.pathStatsVal[i] = PmLayerSonetStsPjc.getDefaultPathStats();
                    sPathStats600Array[i] = this.pathStatsVal[i];
                }
                this.model.getPathStats(this.nearEnd, this.intervalType, (short)-1, sPathStats600Array);
            } else if (this.lpHolder != null && this.lpHolderValid) {
                try {
                    this.pathStatsVal[n] = PmLayerSonetStsPjc.getDefaultPathStats();
                    TdmLineModel tdmLineModel = this.lpHolder.getLineModel();
                    IPortModel iPortModel = tdmLineModel.getPortModel();
                    short s = this.lpHolder.getPathInfo().getStartingIdlHo();
                    sStsInfo sStsInfo2 = new sStsInfo(iPortModel.getIndex(), s);
                    sPathStats sPathStats2 = tdmLineModel.getBlsrProtectPathStats(sStsInfo2, this.nearEnd, this.intervalType, (short)n);
                    this.pathStatsVal[n].es = sPathStats2.es;
                    this.pathStatsVal[n].ses = sPathStats2.ses;
                    this.pathStatsVal[n].cv = sPathStats2.cv;
                    this.pathStatsVal[n].uas = sPathStats2.uas;
                    this.pathStatsVal[n].fc = sPathStats2.fc;
                    this.pathStatsVal[n].pjpIn = sPathStats2.pjpIn;
                    this.pathStatsVal[n].pjpOut = sPathStats2.pjpOut;
                    this.pathStatsVal[n].pjnIn = sPathStats2.pjnIn;
                    this.pathStatsVal[n].pjnOut = sPathStats2.pjnOut;
                    this.pathStatsVal[n].bbe = sPathStats2.bbe;
                    this.pathStatsVal[n].esr = sPathStats2.esr;
                    this.pathStatsVal[n].sesr = sPathStats2.sesr;
                    this.pathStatsVal[n].bber = sPathStats2.bber;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    SDebug.printStackTrace((Throwable)unsupportedOperation);
                    this.lpHolderValid = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PmLayerSonetStsPjc.this.refreshParent();
                        }
                    });
                }
            } else {
                db.println("PmLayerHoPath::refreshPmStats(), model AND lpHolder were null!");
            }
        }
    }

    public String parmName(int n) {
        return this.parmNames[n];
    }

    public int parmCount() {
        return this.parmNames.length;
    }

    public void setModel(InterfaceModel interfaceModel) {
        interfaceModel = (TdmHoModel)interfaceModel;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.pathStatsVal[i] = null;
        }
    }

    private void initParamNames() {
        boolean bl = TdmProtocolType.getTdmProtocolType((int)this.protocolType).isSdh();
        int n = bl ? 13 : 9;
        try {
            TDMTerminology tDMTerminology = this.terms;
            String string = "";
            if (!bl) {
                string = "STS ";
            }
            this.parmNames = new String[n];
            this.parmNames[0] = string + tDMTerminology.createPmColumnName(3, 1);
            this.parmNames[1] = string + tDMTerminology.createPmColumnName(3, 2);
            this.parmNames[2] = string + tDMTerminology.createPmColumnName(3, 0);
            this.parmNames[3] = string + tDMTerminology.createPmColumnName(3, 3);
            this.parmNames[4] = string + tDMTerminology.createPmColumnName(3, 9);
            this.parmNames[5] = tDMTerminology.createPmColumnName(11, 10);
            this.parmNames[6] = tDMTerminology.createPmColumnName(11, 11);
            this.parmNames[7] = tDMTerminology.createPmColumnName(11, 12);
            this.parmNames[8] = tDMTerminology.createPmColumnName(11, 13);
            if (bl) {
                this.parmNames[9] = tDMTerminology.createPmColumnName(3, 6);
                this.parmNames[10] = tDMTerminology.createPmColumnName(3, 7);
                this.parmNames[11] = tDMTerminology.createPmColumnName(3, 8);
                this.parmNames[12] = tDMTerminology.createPmColumnName(3, 5);
            }
        }
        catch (Exception exception) {
            db.finer("Exception in initColumnNames() " + exception);
        }
    }
}

