/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ppm;

import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.shelf.AbstractOCNCard;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.OpticalPortGraphic;
import cerent.util.SDebug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class PpmCard
extends AbstractOCNCard {
    public PpmCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
        super(entityModel, abstractShelfLayout, sDebug);
        this.setBounds(rectangle);
        this.registerForUpdates();
        if (sDebug.on()) {
            sDebug.println("PpmCard: " + entityModel.getEqLabel() + "\tIndex: " + entityModel.getPositionInParent() + "\tNum of children: " + entityModel.getChildren().size());
        }
    }

    private void registerForUpdates() {
        if (this.entityM != null) {
            this.entityM.addObserver(this);
            List list = this.getPorts();
            PortModel portModel = null;
            for (int i = 0; i < list.size(); ++i) {
                portModel = (PortModel)list.get(i);
                if (portModel == null) continue;
                try {
                    portModel.getInterfaceModel().addObserver((Observer)this);
                    if (!this.db.on()) continue;
                    this.db.println("PpmCard: Registered Child: " + portModel);
                    continue;
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    if (!this.db.on()) continue;
                    this.db.println("registerForUpdates(): InterfaceModel does not exist for " + portModel);
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                    continue;
                }
                catch (Exception exception) {
                    if (!this.db.on()) continue;
                    this.db.println("registerForUpdates(): Unexpected exception retrieving InterfaceModel for" + portModel);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (this.db.on()) {
                this.db.println("PpmCard: Registered parent: " + this.entityM);
            }
        }
    }

    private void deregisterFromUpdates() {
        if (this.entityM != null) {
            this.entityM.deleteObserver(this);
            List list = this.getPorts();
            PortModel portModel = null;
            for (int i = 0; i < list.size(); ++i) {
                portModel = (PortModel)list.get(i);
                if (portModel == null) continue;
                try {
                    portModel.getInterfaceModel().deleteObserver((Observer)this);
                    if (!this.db.on()) continue;
                    this.db.println("PpmCard: Deregistered Child: " + portModel);
                    continue;
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    if (!this.db.on()) continue;
                    this.db.println("deregisterFromUpdates(): InterfaceModel does not exist for " + portModel);
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                    continue;
                }
                catch (Exception exception) {
                    if (!this.db.on()) continue;
                    this.db.println("deregisterFromUpdates(): Unexpected exception retrieving InterfaceModel for" + portModel);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (this.db.on()) {
                this.db.println("PpmCard: Deregistered parent: " + this.entityM);
            }
        }
    }

    protected List getPorts() {
        return ((PpmModel)this.entityM).getContainedPorts();
    }

    public void update(Observable observable, Object object) {
        if (this.entityM == null) {
            if (this.db.on()) {
                this.db.println("update: entityM is NULL, no update");
            }
            return;
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(ModelUpdateType.ADDED) && observable == this.entityM) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (this.db.on()) {
                    this.db.println("PpmCard: Port ADDED");
                }
            } else if (n.equals(ModelUpdateType.DELETED)) {
                observable.deleteObserver(this);
                SwingUtilities.invokeLater(new ReplacePort());
                if (this.db.on()) {
                    this.db.println("PpmCard: Port DELETED");
                }
            }
        }
        super.update(observable, object);
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.setColor(this.currentColor);
        graphics2D.fill(this.cardPainter.getMainRectangle());
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.draw(this.cardPainter.getMainRectangle());
        int n = ((PpmModel)this.entityM).getMaxPorts();
        if (n == 1) {
            if (this.portGraphics != null && this.portGraphics.length == 1) {
                this.portGraphics[0].draw(graphics2D);
            } else if (!this.pci.is600()) {
                this.drawPortSlot(graphics2D);
            }
        } else {
            this.db.println("Multi-port PPM not handled !");
        }
    }

    private void drawPortSlot(Graphics2D graphics2D) {
        Rectangle rectangle = new Rectangle(this.calcPortBounds());
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.lightGray);
        graphics2D.fill(rectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(rectangle);
        graphics2D.setColor(color);
    }

    private Rectangle calcPortBounds() {
        int n = 3;
        return new Rectangle(this.cardPainter.getMainRectangle().x + n, this.cardPainter.getMainRectangle().y + n, this.cardPainter.getMainRectangle().width - 2 * n, this.cardPainter.getMainRectangle().height - 2 * n);
    }

    public IAlarmStatus getAlarmStatus() {
        int n = 0;
        IAlarmStatus iAlarmStatus = this.alarmStore.getEntityAlarmStatus(this.entityM);
        if (iAlarmStatus != null) {
            n = iAlarmStatus.getHighestSeverity();
        }
        List list = this.getPorts();
        PortModel portModel = null;
        for (int i = 0; i < list.size(); ++i) {
            IAlarmStatus iAlarmStatus2;
            portModel = (PortModel)list.get(i);
            if (portModel == null || (iAlarmStatus2 = this.alarmStore.getEntityAlarmStatus(portModel)) == null || iAlarmStatus2.getHighestSeverity() <= n) continue;
            iAlarmStatus = iAlarmStatus2;
        }
        return iAlarmStatus;
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (!this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.db.fine("setBounds : before setting bounds : number of ports = " + this.getPorts().size() + ", height = " + rectangle.height + ", width = " + rectangle.width + ", bounds.x = " + rectangle.x + ", bounds.y = " + rectangle.y);
        if (this.pci.is600()) {
            int n = 2;
            if (this.getPorts().size() > 0 && rectangle.height == 6) {
                rectangle.x -= n;
                rectangle.y -= n;
                rectangle.width += n * 2;
                rectangle.height += n * 2;
            } else if (this.getPorts().size() == 0 && rectangle.height > 6) {
                rectangle.x += n;
                rectangle.y += n;
                rectangle.width -= n * 2;
                rectangle.height -= n * 2;
            }
        }
        this.db.fine("setBounds : after setting bounds : height = " + rectangle.height + ", width = " + rectangle.width + ", bounds.x = " + rectangle.x + ", bounds.y = " + rectangle.y);
        this.cardPainter.getMainRectangle().setBounds(rectangle);
        super.setBounds(this.cardPainter.getMainRectangle());
        this.setPortBounds(this.calcPortBounds());
    }

    protected void setPortBounds(Rectangle rectangle) {
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                this.portGraphics[i].x = rectangle.x;
                this.portGraphics[i].y = rectangle.y;
                this.portGraphics[i].width = rectangle.width;
                this.portGraphics[i].height = rectangle.height;
            }
        }
    }

    public boolean contains(Point point) {
        return point.x >= this.getX() && point.x <= this.getX() + this.getWidth() && point.y >= this.getY() && point.y <= this.getY() + this.getHeight();
    }

    public boolean hasProvisionedCard() {
        boolean bl;
        block3: {
            bl = false;
            try {
                if (this.entityM.getParent() != null) {
                    bl = true;
                }
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        return bl;
    }

    public void dispose() {
        this.deregisterFromUpdates();
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].dispose();
                this.portGraphics[i] = null;
            }
        }
        this.portGraphics = null;
        super.dispose();
    }

    static /* synthetic */ OpticalPortGraphic[] access$702(PpmCard ppmCard, OpticalPortGraphic[] opticalPortGraphicArray) {
        ppmCard.portGraphics = opticalPortGraphicArray;
        return opticalPortGraphicArray;
    }

    static /* synthetic */ OpticalPortGraphic[] access$902(PpmCard ppmCard, OpticalPortGraphic[] opticalPortGraphicArray) {
        ppmCard.portGraphics = opticalPortGraphicArray;
        return opticalPortGraphicArray;
    }

    private class ReplacePort
    implements Runnable {
        private ReplacePort() {
        }

        public void run() {
            block7: {
                try {
                    PpmCard.this.deregisterFromUpdates();
                    if (PpmCard.this.portGraphics != null) {
                        for (int i = 0; i < PpmCard.this.portGraphics.length; ++i) {
                            if (PpmCard.this.portGraphics[i] == null) continue;
                            PpmCard.this.portGraphics[i].dispose();
                            ((PpmCard)PpmCard.this).portGraphics[i] = null;
                        }
                        PpmCard.access$702(PpmCard.this, null);
                    }
                    if (PpmCard.this.entityM != null) {
                        List list = PpmCard.this.getPorts();
                        PpmCard.access$902(PpmCard.this, new OpticalPortGraphic[list.size()]);
                        for (int i = 0; i < PpmCard.this.portGraphics.length; ++i) {
                            ((PpmCard)PpmCard.this).portGraphics[i] = PpmCard.this.createPortGraphic(PpmCard.this.cardPainter.getOpticonXOffset(), PpmCard.this.cardPainter.getOpticonYOffset(), (PortModel)list.get(i));
                            if (!PpmCard.this.db.on()) continue;
                            PpmCard.this.db.println("Port updated: " + PpmCard.this.portGraphics[i]);
                        }
                        PpmCard.this.setBounds(PpmCard.this.cardPainter.getMainRectangle().getBounds());
                        PpmCard.this.registerForUpdates();
                    }
                }
                catch (Exception exception) {
                    if (!PpmCard.this.db.on()) break block7;
                    PpmCard.this.db.println("Error replacing port: " + exception);
                    PpmCard.this.db;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (PpmCard.this.parent != null) {
                PpmCard.this.parent.repaint();
            }
        }
    }
}

