/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ransvc;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class RanSvcLineTableModel
extends AbstractTableModel {
    public static final int LINENUMBER_INDEX = 0;
    public static final int PORTNAME_INDEX = 1;
    public static final int ADMIN_STATE_INDEX = 2;
    public static final int LINK_STATE_INDEX = 3;
    protected String[] columnNames = new String[]{"Port", "Port Name", "Admin State", "Link State"};
    protected InterfaceModel[] model;
    protected int numLines;
    protected String[] portNums;
    protected String[] portNames;
    protected AdminState[] adminState;
    protected IServiceState[] serviceState;
    protected boolean[][] isDirty;
    private TDMTerminology _terms;
    private static final SDebug db = new SDebug("RanSvcLineTableModel");

    public RanSvcLineTableModel(InterfaceModel[] interfaceModelArray) {
        this.model = interfaceModelArray;
        this.numLines = interfaceModelArray.length;
        this.portNums = new String[this.numLines];
        this.portNames = new String[this.numLines];
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this._terms = interfaceModelArray[0].getNodeModel().getTDMTerminology();
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortNum(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getAdminState(n) == AdminState.IS ? "Up" : "Down";
                }
                case 3: {
                    return this.getServiceState(n).equals(0) ? "Up" : "Down";
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("RanSvcLineTableModel: error in getValueAt" + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            switch (n2) {
                case 1: {
                    this.portNames[n] = (String)object;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return;
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isCellEditable(int n, int n2) {
        if (n < this.numLines && this.model != null && this.numLines > 0) {
            return n2 == 1 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING);
        }
        return false;
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    public void applyToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (!this.isDirty(n, 1)) continue;
                this.model[n].setAlias(this.getPortName(n));
                this.isDirty[n][1] = false;
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    private void resetLineCache(int n) {
        this.portNums[n] = null;
        this.portNames[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    private AdminState getAdminState(int n) throws Exception {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    private String getPortName(int n) throws NoSuchInterface {
        if (this.portNames[n] == null) {
            this.portNames[n] = this.model[n].getAlias();
        }
        return this.portNames[n];
    }

    private String getPortNum(int n) {
        block3: {
            if (this.portNums[n] == null) {
                try {
                    this.portNums[n] = PortHelper.getPortNumAndTypeString((IPortModel)this.model[n].getPortModel(), (boolean)false, (boolean)true);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    db.println("Caught NoSuchEntity in getPortNum!");
                    if (!db.on()) break block3;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return this.portNums[n];
    }

    private TDMTerminology getTerms() {
        return this._terms;
    }
}

