/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IChassisModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractSmpDiagnosticPane;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.cms.ui.shelf.SmpAuditPane;
import cerent.cms.ui.shelf.SmpDBPane;
import cerent.cms.ui.shelf.SmpDiagnosticPane;
import cerent.cms.ui.shelf.SmpOsiPane;
import cerent.cms.ui.shelf.SmpProtectionPane;
import cerent.cms.ui.shelf.SmpRipRoutingPane;
import cerent.cms.ui.shelf.SmpRoutingPane;
import cerent.cms.ui.shelf.SmpTimingReportPane;
import cerent.cms.ui.shelf.SmpTimingSourcePane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractShelfMaintenancePane
extends NodeProvPane {
    protected static String RING_TAB;
    public static final SDebug db;
    private HashMap maintTabMap = new HashMap();

    public AbstractShelfMaintenancePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        RING_TAB = this.terms.getRingTerms(1);
        this.init(tabbedView);
    }

    protected final void init(TabbedView tabbedView) {
        Component component;
        this.initPositions();
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        if (this.getUiModel() instanceof IChassisModel) {
            final IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
            if (!this.getUiModel().getNodeModel().isMultishelf()) {
                this.newTab("Database", (Component)((Object)this.getSmpDBPane("Database", this.subTabs)));
                this.newTab("OSI", (Component)((Object)new SmpOsiPane("OSI", this.subTabs)));
                this.newTab("Audit", (Component)((Object)new SmpAuditPane("Audit", this.subTabs, this.pci)));
            }
            this.newTab("Protection", (Component)((Object)new SmpProtectionPane("Protection", this.subTabs)));
            this.newTab("Timing", (Component)((Object)new AbstractSubTabbedPane("Timing", this.subTabs){

                public void createSubTabs() {
                    this.subTabs.add((Component)((Object)new SmpTimingSourcePane("Source", this.subTabs, iChassisModel.getSyncModel())));
                    this.subTabs.add((Component)((Object)new SmpTimingReportPane("Report", this.subTabs, iChassisModel.getSyncModel())));
                }
            }));
            this.newTab("Diagnostic", (Component)((Object)this.getSmpDiagnosticPane("Diagnostic", this.subTabs)));
        } else {
            this.newTab("Database", (Component)((Object)this.getSmpDBPane("Database", this.subTabs)));
            this.newTab("OSI", (Component)((Object)new SmpOsiPane("OSI", this.subTabs)));
            this.newTab("Protection", (Component)((Object)new SmpProtectionPane("Protection", this.subTabs)));
            this.newTab("Diagnostic", (Component)((Object)this.getSmpDiagnosticPane("Diagnostic", this.subTabs)));
            this.newTab("Audit", (Component)((Object)new SmpAuditPane("Audit", this.subTabs, this.pci)));
            this.newTab("Network", (Component)((Object)new AbstractSubTabbedPane("Network", this.subTabs){

                public void createSubTabs() {
                    this.subTabs.add((Component)((Object)new SmpRoutingPane("Routing Table", this.subTabs)));
                    this.subTabs.add((Component)((Object)new SmpRipRoutingPane("RIP Routing Table", this.subTabs)));
                }
            }));
        }
        this.localInit();
        if (db.on()) {
            db.println("Maintenance Subtabs:");
            for (int i = 0; i < this.maintTabMap.size(); ++i) {
                component = (Component)this.maintTabMap.get(new Integer(i));
                db.println(i + " -> " + component);
            }
        }
        for (int i = 0; i < this.maintTabMap.size(); ++i) {
            component = (Component)this.maintTabMap.get(new Integer(i));
            if (component != null) {
                this.subTabs.add(component, i);
                continue;
            }
            db.severe("ERROR: no component for index " + i);
        }
        this.maintTabMap.clear();
        this.maintTabMap = null;
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    protected abstract void localInit();

    protected AbstractSmpDiagnosticPane getSmpDiagnosticPane(String string, TabbedView tabbedView) {
        return new SmpDiagnosticPane(string, tabbedView);
    }

    protected SmpDBPane getSmpDBPane(String string, TabbedView tabbedView) {
        return new SmpDBPane(string, tabbedView);
    }

    private Integer getTabPos(String string) {
        Map map = this.getTabMap();
        if (map.containsKey(string)) {
            return (Integer)map.get(string);
        }
        db.severe("ERROR: no entry in tab pos map for " + string);
        return new Integer(-1);
    }

    protected abstract Map getTabMap();

    protected abstract void initPositions();

    public boolean hasSubTabs() {
        return true;
    }

    protected void newTab(String string, Component component) {
        this.maintTabMap.put(this.getTabPos(string), component);
    }

    static {
        db = new SDebug((KDebug)ShelfTabbedView.db, "ShelfMaintenancePane");
    }
}

