/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.eLapdMode;
import cerent.cms.idl.OSI.eLinkType;
import cerent.cms.idl.OSI.sLapdTerm;
import cerent.cms.idl.OSI.sSubnet;
import cerent.cms.idl.SonetMedia.eOverheadChannelType;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.Busy;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DuplicateDccNum;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.LapdTermModel;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.OsiModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SubnetModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.WizardDialog;
import cerent.cms.ui.shelf.AbstractTermPane;
import cerent.cms.ui.shelf.LapdCreationPane;
import cerent.cms.ui.shelf.SubnetCreationPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.SpinPropertyEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class AbstractTermCreationDialog
extends WizardDialog
implements ActionListener,
PropertyChangeListener {
    protected int WIDTH = 400;
    protected int HEIGHT = 420;
    protected int IIH_STEP = 1;
    protected int T200_STEP = 100;
    protected int T203_STEP = 100;
    protected int MTU_STEP = 1;
    protected static final String PROT_PPP = "PPP";
    protected static final String PROT_LAPD = "LAPD";
    private SpinPropertyEditor eshSpinner;
    private SpinPropertyEditor ishSpinner;
    private SpinPropertyEditor iihSpinner;
    private SpinPropertyEditor metricCostSpinner;
    private JComboBox routerCB;
    private JButton defaultSubnetB;
    private JButton defaultLapdB;
    private JRadioButton aitsButton;
    private JRadioButton uitsButton;
    private JRadioButton netButton;
    private JRadioButton usrButton;
    private SpinPropertyEditor mtuSpinner;
    private SpinPropertyEditor t200Spinner;
    private SpinPropertyEditor t203Spinner;
    AbstractTermPane _atp = null;
    protected AbstractTermConnectionModel connTable;
    private NodeModelDelegate nmd;
    private LapdTermModel lapdTermModel;
    private SubnetModel subnetModel;
    private OsiModel osiModel;
    protected static String GCC_TERM_TYPE = "GCC";
    protected static String OSC_TERM_TYPE = "OSC";
    private String SDCC_TERM_TYPE;
    private String LDCC_TERM_TYPE;
    protected String terminationType;
    LapdCreationPane lapdCreationPane;
    SubnetCreationPane subnetCreationPane;
    private boolean hasLapd = false;
    private boolean hasSubnet = false;
    protected static final SDebug db = new SDebug("TermCreationDialog");

    protected AbstractTermCreationDialog(Frame frame, String string, String string2, Object object) {
        super(frame, string);
        this.terminationType = string2;
        this.connTable = (AbstractTermConnectionModel)object;
        this.SDCC_TERM_TYPE = this.connTable.getNodeModelDelegate().getTDMTerminology().getGeneralTerms(8);
        this.LDCC_TERM_TYPE = this.connTable.getNodeModelDelegate().getTDMTerminology().getGeneralTerms(10);
        this.nmd = this.connTable.getNodeModelDelegate();
        this.setSize(new Dimension(this.WIDTH, this.HEIGHT));
        this.setLocationRelativeTo(frame);
        this.subnetModel = this.nmd.getSubnetModel();
        this.lapdTermModel = this.nmd.getLapdModel();
        this.osiModel = this.nmd.getOsiModel();
        this._atp = null;
    }

    protected void setEnableSubnetPane(boolean bl, int n) {
        boolean bl2 = this.osiModel.getRoutingMode() == 0;
        sSubnet sSubnet2 = null;
        try {
            sSubnet2 = this.subnetModel.getSubnetByIndex(n);
        }
        catch (Exception exception) {
            db.info("Unexpected error when getting Subnet: " + exception);
        }
        this.eshSpinner.setEnabled(bl);
        this.defaultSubnetB.setEnabled(bl);
        this.ishSpinner.setEnabled(bl && !bl2);
        this.iihSpinner.setEnabled(bl && !bl2);
        this.metricCostSpinner.setEnabled(bl && !bl2 && sSubnet2 == null);
        if (this.routerCB != null) {
            this.routerCB.setEnabled(bl && sSubnet2 == null);
        }
    }

    protected void editSubnetInfo(boolean bl, int n, Object object) throws Exception {
        db.fine("Working with dccIndex " + Integer.toHexString(n));
        sSubnet sSubnet2 = this.getSubnetFromPane(n);
        sSubnet sSubnet3 = null;
        try {
            sSubnet3 = this.subnetModel.getSubnetByIndex(n);
        }
        catch (Exception exception) {
            db.info("Unexpected error when getting Subnet: " + exception);
        }
        if (sSubnet3 == null) {
            if (bl) {
                if (!this.nmd.getRouterModel().getEnabled(sSubnet2.routerNumber)) {
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_OSI_ROUTER_DISABLED);
                } else if (this.osiModel.getRoutingMode() == 0 && this.subnetModel.getSubnetList((short)1).length > 0) {
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_ES_ONLY_SUPPORT_ONE_SUBNET);
                } else {
                    this.subnetModel.createSubnetBody(sSubnet2);
                }
            }
        } else if (bl) {
            if (sSubnet2.ish != sSubnet3.ish) {
                this.subnetModel.setISHTimer(sSubnet3.routerNumber, sSubnet3.type, sSubnet3.dccIndex, sSubnet2.ish);
            }
            if (sSubnet2.esh != sSubnet3.esh) {
                this.subnetModel.setESHTimer(sSubnet3.routerNumber, sSubnet3.type, sSubnet3.dccIndex, sSubnet2.esh);
            }
            if (sSubnet2.iih != sSubnet3.iih) {
                this.subnetModel.setIIHTimer(sSubnet3.routerNumber, sSubnet3.type, sSubnet3.dccIndex, sSubnet2.iih);
            }
        } else {
            this.subnetModel.removeSubnetBody(n, sSubnet3.type);
        }
    }

    private String helpHelpPutDefaultData(String string, String string2) {
        try {
            string2 = this.nmd.getDefaultValue(string);
        }
        catch (NoSuchDefault noSuchDefault) {
            db.severe("putDefaultSubnet(): NoSuchDefault " + string);
        }
        catch (Exception exception) {
            db.severe("putDefaultSubnet():unexpected exception from getDefaultValue():" + exception);
        }
        return string2;
    }

    private void helpPutDefaultData(String string, String string2, SpinPropertyEditor spinPropertyEditor) {
        spinPropertyEditor.setValue(new Integer(this.helpHelpPutDefaultData(string, string2)));
    }

    private void helpPutDefaultData(String string, String string2, JRadioButton jRadioButton) {
        jRadioButton.setSelected(this.helpHelpPutDefaultData(string, string2).equalsIgnoreCase(string2));
    }

    private void putDefaultSubnet() {
        String string = "NODE.osi.subnet.SDCCISISCost";
        String string2 = "60";
        if (this.terminationType != null) {
            if (this.terminationType.equals(GCC_TERM_TYPE)) {
                string = "NODE.osi.subnet.GCCISISCost";
                string2 = "60";
            } else if (this.terminationType.equals(this.LDCC_TERM_TYPE)) {
                string = "NODE.osi.subnet.LDCCISISCost";
                string2 = "40";
            } else if (this.terminationType.equals(OSC_TERM_TYPE)) {
                string = "NODE.osi.subnet.OSCISISCost";
                string2 = "60";
            }
        }
        if (this.eshSpinner.isEnabled()) {
            this.helpPutDefaultData("NODE.osi.subnet.ESH", "10", this.eshSpinner);
        }
        if (this.ishSpinner.isEnabled()) {
            this.helpPutDefaultData("NODE.osi.subnet.ISH", "10", this.ishSpinner);
        }
        if (this.iihSpinner.isEnabled()) {
            this.helpPutDefaultData("NODE.osi.subnet.IIH", "3", this.iihSpinner);
        }
        if (this.metricCostSpinner.isEnabled()) {
            this.helpPutDefaultData(string, string2, this.metricCostSpinner);
        }
    }

    private JComboBox helpAddComboBox(GridBagPanel gridBagPanel, JComboBox jComboBox, String string, int n) {
        jComboBox.addActionListener(this);
        int n2 = 0;
        gridBagPanel.add(new JLabel(string), n2++, n, 1, 1);
        gridBagPanel.add(jComboBox, n2++, n, 1, 1);
        gridBagPanel.add(new JLabel(""), n2, n, 1, 1);
        return jComboBox;
    }

    private SpinPropertyEditor helpAddSpinner(GridBagPanel gridBagPanel, SpinPropertyEditor spinPropertyEditor, String string, int n) {
        spinPropertyEditor.addPropertyChangeListener(this);
        int n2 = 0;
        gridBagPanel.add(new JLabel(spinPropertyEditor.getLabelText() + ":"), n2++, n, 1, 1);
        spinPropertyEditor.setLabelText("");
        gridBagPanel.add(spinPropertyEditor, n2++, n, 1, 1);
        gridBagPanel.add(new JLabel(string), n2, n, 1, 1);
        return spinPropertyEditor;
    }

    private void helpAddRadioButtonPair(GridBagPanel gridBagPanel, JRadioButton jRadioButton, JRadioButton jRadioButton2, String string, int n) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.addActionListener(this);
        jRadioButton.setSelected(true);
        jRadioButton2.addActionListener(this);
        int n2 = 0;
        gridBagPanel.add(new JLabel(string), n2++, n, 1, 1);
        gridBagPanel.add(jRadioButton, n2++, n, 1, 1);
        gridBagPanel.add(jRadioButton2, n2, n, 1, 1);
    }

    private JButton helpAddButton(GridBagPanel gridBagPanel, JButton jButton, int n) {
        jButton.addActionListener(this);
        gridBagPanel.add(jButton, 0, n, 1, 1);
        return jButton;
    }

    protected JPanel getSubnetPane(AbstractTermPane abstractTermPane) {
        this._atp = abstractTermPane;
        this.hasSubnet = true;
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchorWest();
        gridBagPanel.inset(4, 1);
        int n = 0;
        String[] stringArray = this.nmd.getRouterModel().getOsiRouters();
        int n2 = this.osiModel.getRoutingMode();
        if (stringArray.length > 1 && n2 != 0) {
            this.routerCB = this.helpAddComboBox(gridBagPanel, new JComboBox<String>(stringArray), "Router:", n++);
        }
        this.eshSpinner = this.helpAddSpinner(gridBagPanel, new SpinPropertyEditor("ESH", 10, 10, 1000), "sec", n++);
        this.ishSpinner = this.helpAddSpinner(gridBagPanel, new SpinPropertyEditor("ISH", 10, 10, 1000), "sec", n++);
        this.iihSpinner = this.helpAddSpinner(gridBagPanel, new SpinPropertyEditor("IIH", this.IIH_STEP, 1, 600), "sec", n++);
        this.metricCostSpinner = this.helpAddSpinner(gridBagPanel, new SpinPropertyEditor("IS-IS Cost", Integer.parseInt("1"), 1, 63), "", n++);
        this.defaultSubnetB = this.helpAddButton(gridBagPanel, new JButton("Default"), n);
        this.putDefaultSubnet();
        return gridBagPanel;
    }

    protected JPanel getSubnetPane() {
        return this.getSubnetPane(null);
    }

    protected void setEnableLapdPane(boolean bl) {
        this.aitsButton.setEnabled(bl);
        this.uitsButton.setEnabled(bl);
        this.netButton.setEnabled(bl);
        this.usrButton.setEnabled(bl);
        this.mtuSpinner.setEnabled(bl);
        this.defaultLapdB.setEnabled(bl);
        this.t200Spinner.setEnabled(bl && this.aitsButton.isSelected());
        this.t203Spinner.setEnabled(bl && this.aitsButton.isSelected());
    }

    protected void editLapdInfo(boolean bl, int n, Object object) throws Exception {
        db.fine("Working with dccIndex " + Integer.toHexString(n));
        sLapdTerm sLapdTerm2 = this.getLapdTermFromPane(n);
        sLapdTerm sLapdTerm3 = this.lapdTermModel.getLapdByIndex(n);
        if (sLapdTerm3 == null) {
            db.severe("No LAPD  for " + n);
        } else if (bl && (sLapdTerm3.acknowledged != sLapdTerm2.acknowledged || sLapdTerm3.mode != sLapdTerm2.mode || sLapdTerm3.t200 != sLapdTerm2.t200 || sLapdTerm3.t203 != sLapdTerm2.t203 || sLapdTerm3.mtu != sLapdTerm2.mtu)) {
            this.lapdTermModel.editLapdTerm(sLapdTerm2);
        }
    }

    private void putDefaultLapdData() {
        if (this.aitsButton.isEnabled()) {
            this.helpPutDefaultData("NODE.osi.lapd.Mode", "AITS", this.aitsButton);
        }
        if (this.uitsButton.isEnabled()) {
            this.helpPutDefaultData("NODE.osi.lapd.Mode", "UITS", this.uitsButton);
        }
        if (this.netButton.isEnabled()) {
            this.helpPutDefaultData("NODE.osi.lapd.Role", "Network", this.netButton);
        }
        if (this.usrButton.isEnabled()) {
            this.helpPutDefaultData("NODE.osi.lapd.Role", "User", this.usrButton);
        }
        if (this.mtuSpinner.isEnabled()) {
            this.helpPutDefaultData("NODE.osi.lapd.MTU", "512", this.mtuSpinner);
        }
        if (this.t200Spinner.isEnabled()) {
            this.helpPutDefaultData("NODE.osi.lapd.T200", "200", this.t200Spinner);
        }
        if (this.t203Spinner.isEnabled()) {
            this.helpPutDefaultData("NODE.osi.lapd.T203", "10000", this.t203Spinner);
        }
    }

    protected JPanel getLapdPane() {
        this.hasLapd = true;
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.anchorWest();
        gridBagPanel.inset(4, 1);
        int n = 0;
        this.aitsButton = new JRadioButton("AITS");
        this.uitsButton = new JRadioButton("UITS");
        this.helpAddRadioButtonPair(gridBagPanel, this.aitsButton, this.uitsButton, "Mode:", n++);
        this.netButton = new JRadioButton("Network");
        this.usrButton = new JRadioButton("User");
        this.helpAddRadioButtonPair(gridBagPanel, this.netButton, this.usrButton, "Role:", n++);
        this.mtuSpinner = this.helpAddSpinner(gridBagPanel, new SpinPropertyEditor("MTU", this.MTU_STEP, 512, 1500), "", n++);
        this.t200Spinner = this.helpAddSpinner(gridBagPanel, new SpinPropertyEditor("T200", this.T200_STEP, 200, 20000), "ms", n++);
        this.t200Spinner.setEditorSize(4);
        this.t203Spinner = this.helpAddSpinner(gridBagPanel, new SpinPropertyEditor("T203", this.T203_STEP, 4000, 120000), "ms", n++);
        this.t203Spinner.setEditorSize(5);
        this.defaultLapdB = this.helpAddButton(gridBagPanel, new JButton("Default"), n);
        this.putDefaultLapdData();
        this.helpEnableTTimer();
        return gridBagPanel;
    }

    protected JPanel getLapdPane(AbstractTermPane abstractTermPane) {
        this._atp = abstractTermPane;
        return this.getLapdPane();
    }

    protected boolean hasSubnetPage() {
        return this.hasSubnet;
    }

    protected boolean hasLapdPage() {
        return this.hasLapd;
    }

    protected sSubnet getSubnetFromPane(int n) {
        if (this.hasSubnetPage()) {
            boolean bl = true;
            short s = this.routerCB == null ? (short)1 : (short)(this.routerCB.getSelectedIndex() + 1);
            eLinkType eLinkType2 = eLinkType.LINK_TYPE_SDCC;
            if (this.terminationType.equals(this.LDCC_TERM_TYPE)) {
                eLinkType2 = eLinkType.LINK_TYPE_LDCC;
            } else if (this.terminationType.equals(GCC_TERM_TYPE)) {
                eLinkType2 = eLinkType.LINK_TYPE_GCC;
            } else if (this.terminationType.equals(OSC_TERM_TYPE)) {
                eLinkType2 = eLinkType.LINK_TYPE_OSC;
            }
            short s2 = Short.parseShort((String)this.ishSpinner.getValue());
            short s3 = Short.parseShort((String)this.eshSpinner.getValue());
            short s4 = Short.parseShort((String)this.iihSpinner.getValue());
            short s5 = Short.parseShort((String)this.metricCostSpinner.getValue());
            short s6 = 63;
            return new sSubnet(s2, s3, s4, s6, s5, eLinkType2, s, n);
        }
        db.fine("getSubnetFromPane: no pane");
        return null;
    }

    protected void fillSubnetPane(sSubnet sSubnet2) {
        if (this.routerCB != null) {
            this.routerCB.setSelectedIndex(sSubnet2.routerNumber - 1);
        }
        this.ishSpinner.setValue(new Short(sSubnet2.ish));
        this.eshSpinner.setValue(new Short(sSubnet2.esh));
        this.iihSpinner.setValue(new Short(sSubnet2.iih));
        this.metricCostSpinner.setValue(new Short(sSubnet2.metric).toString());
    }

    protected sLapdTerm getLapdTermFromPane(int n) throws Exception {
        if (this.hasLapdPage()) {
            int n2 = this.netButton.isSelected() ? 0 : 1;
            short s = Short.parseShort((String)this.t200Spinner.getValue());
            int n3 = Integer.parseInt((String)this.t203Spinner.getValue());
            short s2 = Short.parseShort((String)this.mtuSpinner.getValue());
            if (s2 < 512 || s2 > 1500) {
                throw new Exception("The MTU must be between 512 and 1500.");
            }
            if (this.aitsButton.isSelected() && (s < 200 || s > 20000)) {
                throw new Exception("The T200 must be between 200 and 20000.");
            }
            if (this.aitsButton.isSelected() && (n3 < 4000 || n3 > 120000)) {
                throw new Exception("The T203 must be between 4000 and 120000.");
            }
            return new sLapdTerm(n, eOverheadChannelType.from_int(0), this.aitsButton.isSelected(), eLapdMode.from_int(n2), s, n3, s2);
        }
        db.fine("getLapdTermFromPane: no pane");
        return null;
    }

    protected void fillLapdPane(sLapdTerm sLapdTerm2) {
        if (sLapdTerm2.mode.value() == 0) {
            this.netButton.setSelected(true);
        } else {
            this.usrButton.setSelected(true);
        }
        if (sLapdTerm2.acknowledged) {
            this.aitsButton.setSelected(true);
        } else {
            this.uitsButton.setSelected(true);
        }
        this.t200Spinner.setValue(new Short(sLapdTerm2.t200));
        this.t203Spinner.setValue(new Integer(sLapdTerm2.t203));
        this.mtuSpinner.setValue(new Short(sLapdTerm2.mtu));
        this.helpEnableTTimer();
    }

    protected void addSubnetPage() {
        if (this.subnetCreationPane == null) {
            this.subnetCreationPane = new SubnetCreationPane("OSI Subnet", this);
            this.addPage(this.subnetCreationPane);
        }
    }

    protected void addLapdPage() {
        if (this.lapdCreationPane == null) {
            this.lapdCreationPane = new LapdCreationPane(PROT_LAPD, this);
            this.addPage(this.lapdCreationPane);
        }
    }

    protected void removeLapdPage() {
        if (this.lapdCreationPane != null) {
            this.removePage(this.lapdCreationPane);
            this.hasLapd = false;
            this.lapdCreationPane = null;
        }
    }

    protected void removeSubnetPage() {
        if (this.subnetCreationPane != null) {
            this.removePage(this.subnetCreationPane);
            this.hasSubnet = false;
            this.subnetCreationPane = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.defaultSubnetB) {
            this.putDefaultSubnet();
            this.enableEditOk();
        } else if (object == this.defaultLapdB) {
            this.putDefaultLapdData();
            this.enableEditOk();
            this.helpEnableTTimer();
        } else if (object == this.routerCB || object == this.netButton || object == this.usrButton) {
            this.enableEditOk();
        } else if (object == this.uitsButton || object == this.aitsButton) {
            this.enableEditOk();
            this.helpEnableTTimer();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void enableEditOk() {
        if (this._atp != null) {
            this._atp.enableEditOkButton();
        }
    }

    private void helpEnableTTimer() {
        this.t200Spinner.setEnabled(this.aitsButton.isSelected());
        this.t203Spinner.setEnabled(this.aitsButton.isSelected());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof SpinPropertyEditor && this._atp != null) {
            this._atp.enableEditOkButton();
        }
    }

    public void dispose() {
        this.connTable = null;
        this.lapdCreationPane = null;
        this.subnetCreationPane = null;
        this.subnetModel = null;
        this.lapdTermModel = null;
        super.dispose();
    }

    protected abstract void createTermination(IEntityModel var1) throws Exception;

    protected void createTerms(Object[] objectArray, int n) {
        int n2;
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = n != -1 ? new ArrayList() : null;
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer("slot ");
        if (this.hasSubnetPage()) {
            n2 = (short)(this.routerCB == null ? 1 : (short)(this.routerCB.getSelectedIndex() + 1));
            short s = (short)n2;
            if (!this.nmd.getRouterModel().getEnabled(n2)) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_OSI_ROUTER_DISABLED);
                return;
            }
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            IEntityModel iEntityModel;
            block23: {
                iEntityModel = (IEntityModel)objectArray[n2];
                if (this.hasSubnetPage() && this.osiModel.getRoutingMode() == 0) {
                    try {
                        if (this.subnetModel.getSubnetList((short)1).length > 0 || objectArray.length > 1) {
                            AbstractTermPane.addFailureReason(EMC.EID_ES_ONLY_SUPPORT_ONE_SUBNET, iEntityModel, entityCellRenderer, arrayList2);
                            break;
                        }
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block23;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
            }
            try {
                this.createTermination(iEntityModel);
                arrayList.add(iEntityModel);
            }
            catch (InvalidOhTerm invalidOhTerm) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)invalidOhTerm);
                }
                AbstractTermPane.addFailureReason(EMC.EID_INVALID_OH_TERM, iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            catch (Busy busy) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)busy);
                }
                AbstractTermPane.addFailureReason(EMC.EID_TERM_TYPE_IN_USE_PARAM_1, this.terminationType, iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            catch (ResourceInUse resourceInUse) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)resourceInUse);
                }
                AbstractTermPane.addFailureReason(EMC.EID_OH_TERM_PORT_IN_USE_PARAM_1, this.terminationType, iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            catch (OhMaxConnections ohMaxConnections) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)ohMaxConnections);
                }
                AbstractTermPane.addFailureReason(EMC.EID_OH_MAX_CONNECTIONS, iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            catch (ConfigError configError) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)configError);
                }
                AbstractTermPane.addFailureReason(EMC.EID_TERM_TYPE_CREATE_FAIL_PARAM_1, this.terminationType, iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            catch (ProvisionError provisionError) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)provisionError);
                }
                AbstractTermPane.addFailureReason(provisionError.getEID(), iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            catch (DuplicateDccNum duplicateDccNum) {
            }
            catch (Exception exception) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                AbstractTermPane.addFailureReason(EMC.EID_TERM_TYPE_CREATE_FAIL_PARAM_1, this.terminationType, iEntityModel, entityCellRenderer, arrayList2);
                continue;
            }
            if (n == -1 || !(iEntityModel instanceof TdmPortModel) && !(iEntityModel instanceof DwdmPortModel)) continue;
            PortModel portModel = (PortModel)iEntityModel;
            AbstractTermPane.maybeSetAdminState(portModel, n, arrayList3, entityCellRenderer, db);
        }
        AbstractTermPane.handleFailures(this, this.terminationType, "create", arrayList, arrayList2, arrayList3, entityCellRenderer);
    }

    void validateWizard() throws Exception {
        short s = Short.parseShort((String)this.mtuSpinner.getValue());
        if (this.osiModel.getRoutingMode() == 1 && s < this.osiModel.getL1LspBufferSize()) {
            throw new Exception(ErrorMsg.getString((EID)EMC.EID_LSP_EXCEED_MTU_PARAM_3, (Object)"L1", (Object)new Short(this.osiModel.getL1LspBufferSize()).toString(), (Object)new Short(s).toString()));
        }
        if (this.osiModel.getRoutingMode() == 2 && s < this.osiModel.getMaxLsp()) {
            throw new Exception(ErrorMsg.getString((EID)EMC.EID_LSP_EXCEED_MTU_PARAM_3, (Object)"Max", (Object)new Short(this.osiModel.getL1LspBufferSize()).toString(), (Object)new Short(s).toString()));
        }
    }

    public String getSdccTerm() {
        return this.SDCC_TERM_TYPE;
    }

    public String getLdccTerm() {
        return this.LDCC_TERM_TYPE;
    }
}

