/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.ServiceState;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CardView
extends JPanel
implements Observer {
    protected AbstractCardViewPanel cardViewPanel;
    protected List portModels;
    protected EntityModel model;
    protected boolean is327;
    protected int numPorts;
    protected AbstractPortGraphic[] ports;
    private AbstractPortGraphic selectedPort;
    private int slotNo;
    protected static final Color[] severityColor = new Color[]{Color.white, Color.yellow, Color.orange, Color.red};
    protected ElementAlarmStore cardAlarmStore;
    protected IPlatform pci;
    private static final SDebug db = new SDebug("CardView");

    public CardView(EntityModel entityModel) {
        this.initCardView(entityModel);
    }

    public CardView(ModuleModel moduleModel, AbstractCardViewPanel abstractCardViewPanel) {
        this.cardViewPanel = abstractCardViewPanel;
        this.initCardView(moduleModel);
    }

    private void initCardView(EntityModel entityModel) {
        this.model = entityModel;
        if (this.model != null) {
            NodeModelDelegate nodeModelDelegate = this.model.getNodeModelDelegate();
            this.portModels = this.getPorts();
            this.numPorts = this.portModels.size();
            if (db.on()) {
                db.println("Number of Ports found " + this.numPorts);
            }
            this.slotNo = this.model.getSlot();
            this.ports = new AbstractPortGraphic[this.numPorts];
            this.setLayout(new GridBagLayout());
            this.pci = nodeModelDelegate.getPlatform();
            this.is327 = this.pci.is327();
            this.addPorts(this.pci.positionPortsVertically());
            this.addLabels();
            this.setBorder(BorderFactory.createBevelBorder(0));
            ElementAlarmStore elementAlarmStore = (ElementAlarmStore)nodeModelDelegate.getElementAlarmStore();
            this.cardAlarmStore = (ElementAlarmStore)elementAlarmStore.getCardAlarmStore(this.model.getShelfId(), this.slotNo);
            this.cardAlarmStore.addAlarmStatusObserver(this);
            this.model.addObserver(this);
            this.cardAlarmStore.enablePortAlarmsStatus(this.model.getModuleModel());
            this.refreshAlarmInfo();
        }
    }

    protected void refreshAlarmInfo() {
        this.update(this.cardAlarmStore.getAlarmStatusObservable(), this.cardAlarmStore.getAlarmStatus());
    }

    protected Dimension getCardSize() {
        this.validate();
        return this.getPreferredSize();
    }

    public void update(Observable observable, Object object) {
        if (object instanceof AlarmStatus) {
            AlarmStatus alarmStatus = (AlarmStatus)object;
            this.setAlarmColor(alarmStatus.getHighestSeverity());
            for (int i = 0; i < this.numPorts; ++i) {
                Object e = this.portModels.get(this.getPortModelIdx(i));
                if (!(e instanceof PortModel)) continue;
                PortModel portModel = (PortModel)e;
                IAlarmStatus iAlarmStatus = this.cardAlarmStore.getEntityAlarmStatus(portModel);
                if (iAlarmStatus != null && this.ports[i] != null) {
                    this.ports[i].setAlarmState(iAlarmStatus.getHighestSeverity());
                    if (!db.on()) continue;
                    db.println("Updated position " + i + " port: " + portModel.getPort() + ", eqType " + portModel.getEqType() + ", model: " + this.ports[i].getModel().toString());
                    continue;
                }
                if (!db.on()) continue;
                db.println("null portAlarmStatus for position " + i + ", eqType " + portModel.getEqType() + ", port " + portModel.getPort());
            }
        } else if (object.equals(ModelUpdateType.CHANGED)) {
            this.setAlarmColor(this.cardAlarmStore.getAlarmStatus().getHighestSeverity());
        }
    }

    public void portSelected(AbstractPortGraphic abstractPortGraphic) {
        if (this.selectedPort != null) {
            this.selectedPort.setDeSelected();
        }
        this.selectedPort = abstractPortGraphic;
        this.selectedPort.setSelected();
    }

    public static void join(Graphics graphics, JComponent jComponent, JComponent jComponent2) {
        Point point = jComponent.getLocation(null);
        Point point2 = jComponent2.getLocation(null);
        Dimension dimension = jComponent.getSize();
        Dimension dimension2 = jComponent2.getSize();
        int n = point.x + dimension.width;
        int n2 = point2.x;
        int n3 = point.y + dimension.height / 2;
        int n4 = point2.y + dimension2.height / 2;
        graphics.drawLine(n, n3, n2, n4);
    }

    protected eEqState getState() {
        if (this.model instanceof MfgEntityModel) {
            return ((MfgEntityModel)this.model).getState();
        }
        return null;
    }

    public void drawDoubleHeadedArrow(Graphics graphics, Rectangle rectangle, Rectangle rectangle2) {
        if (this.pci.positionPortsVertically()) {
            int n = (int)rectangle.getCenterX() + (int)(rectangle.getWidth() / 2.0) + 2;
            int n2 = (int)rectangle.getCenterY();
            int n3 = (int)rectangle2.getCenterX() - (int)(rectangle2.getWidth() / 2.0) - 3;
            int n4 = (int)rectangle2.getCenterY();
            graphics.drawLine(n + 3, n2, n3 - 3, n4);
            int[] nArray = new int[]{n, n + 3, n + 3};
            int[] nArray2 = new int[]{n2, n2 - 3, n2 + 3};
            Polygon polygon = new Polygon(nArray, nArray2, 3);
            graphics.fillPolygon(polygon);
            int[] nArray3 = new int[]{n3, n3 - 3, n3 - 3};
            int[] nArray4 = new int[]{n4, n4 - 3, n4 + 3};
            Polygon polygon2 = new Polygon(nArray3, nArray4, 3);
            graphics.fillPolygon(polygon2);
        } else {
            int n = (int)rectangle.getCenterX();
            int n5 = (int)rectangle.getCenterY() + (int)(rectangle.getHeight() / 2.0) + 2;
            int n6 = (int)rectangle2.getCenterX();
            int n7 = (int)rectangle2.getCenterY() - (int)(rectangle2.getHeight() / 2.0) - 3;
            graphics.drawLine(n, n5 + 3, n6, n7 - 3);
            int[] nArray = new int[]{n, n + 4, n - 4};
            int[] nArray5 = new int[]{n5, n5 + 4, n5 + 4};
            Polygon polygon = new Polygon(nArray, nArray5, 3);
            graphics.fillPolygon(polygon);
            int[] nArray6 = new int[]{n6, n6 + 3, n6 - 3};
            int[] nArray7 = new int[]{n7, n7 - 3, n7 - 3};
            Polygon polygon3 = new Polygon(nArray6, nArray7, 3);
            graphics.fillPolygon(polygon3);
        }
    }

    public EntityModel getModel() {
        return this.model;
    }

    public void dispose() {
        this.cardAlarmStore.deleteAlarmStatusObserver(this);
        this.cardAlarmStore.disablePortAlarmsStatus();
        if (this.model != null) {
            this.model.deleteObserver(this);
        }
        if (db.on()) {
            db.println("Dispose called ");
        }
        if (this.ports != null) {
            for (int i = 0; i < this.ports.length; ++i) {
                if (this.ports[i] == null) continue;
                this.ports[i].dispose();
            }
        }
    }

    protected void setAlarmColor(int n) {
        Object object;
        block10: {
            try {
                if (this.model instanceof MfgEntityModel && ((ServiceState)(object = (ServiceState)((MfgEntityModel)this.model).getServiceSt())).isFormOfMT()) {
                    this.setBackground(ElementDefaults.OOS_MT_COLOR);
                    return;
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block10;
                db.println("Caught exception in setAlarmColor: " + exception);
            }
        }
        object = null;
        try {
            object = this.getState();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object == null) {
            return;
        }
        if (object == eEqState.DELETED) {
            this.setBackground(ElementDefaults.OOS_DSBLD_COLOR);
        } else if ((object == eEqState.NOT_PRESENT || object == eEqState.MISMATCH) && n == 0) {
            this.setBackground(ElementDefaults.PROVISIONED_COLOR);
        } else {
            this.setBackground(severityColor[n]);
        }
        this.repaint();
    }

    protected int getPortModelIdx(int n) {
        return n;
    }

    protected void addLabels() {
    }

    protected void addPorts(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(2, 3, 2, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        for (int i = 0; i < this.numPorts; ++i) {
            Object e = this.portModels.get(this.getPortModelIdx(i));
            if (!(e instanceof PortModel)) continue;
            PortModel portModel = (PortModel)e;
            this.ports[i] = new GenericPortGraphic(this, portModel, portModel.getPort(), portModel.isSpecial());
            if (db.on()) {
                db.println("Position: " + i + ", port: " + portModel.getPort() + ", model: " + portModel.toString());
            }
            if (bl) {
                gridBagConstraints.gridy = i + 1;
            } else {
                gridBagConstraints.gridx = i + 1;
            }
            this.add((Component)this.ports[i], gridBagConstraints);
        }
        this.repaint();
    }

    protected List getPorts() {
        List list = new ArrayList();
        list = this.model.getDescendantsOfType(eClass.E_SENSOR);
        list.addAll(this.model.getDescendantsOfType(eClass.SENSOR_OUTPUT));
        list.addAll(this.model.getDescendantsOfClassType(7));
        return list;
    }
}

