/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.OpticalPortGraphic;
import cerent.util.SDebug;

public class DwdmPortGraphic
extends OpticalPortGraphic {
    private AbstractDwdmLineModel dwdmM;
    private PortModel dwdmPortM;

    public DwdmPortGraphic(CardGraphic cardGraphic, int n, int n2, PortModel portModel) {
        super(cardGraphic, n, n2, portModel, 1);
    }

    public DwdmPortGraphic(CardGraphic cardGraphic, int n, int n2, int n3, int n4, PortModel portModel) {
        super(cardGraphic, n, n2, n3, n4, portModel, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLoopback(int n) {
        boolean bl = false;
        Throwable throwable = null;
        if (this.dwdmM != null) {
            try {
                bl = this.dwdmM.getLoopbackAsInt() == n;
            }
            catch (NoSuchInterface noSuchInterface) {
                throwable = noSuchInterface;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                throwable = wrongInterfaceType;
            }
            finally {
                if (throwable != null) {
                    SDebug.printStackTrace((Throwable)throwable);
                }
            }
        }
        return bl;
    }

    public boolean isFacilityLoopback() {
        return this.isLoopback(2);
    }

    public boolean isTerminalLoopback() {
        return this.isLoopback(1);
    }

    protected boolean isCurrentlyActive() {
        boolean bl = false;
        if (this.dwdmM != null && this.retrieveIfModel() != null) {
            try {
                bl = this.retrieveIfModel().isCurrentlyActive();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                SDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        }
        return bl;
    }

    public void dispose() {
        if (this.dwdmM != null) {
            this.dwdmM.deleteObserver(this);
            this.dwdmM = null;
        }
        if (this.dwdmPortM != null) {
            this.dwdmPortM.deleteObserver(this);
            this.dwdmPortM = null;
        }
        super.dispose();
    }

    protected String getPhysicalMediumDescription() {
        return "";
    }

    protected void registerWithModel(InterfaceModel interfaceModel) {
        block4: {
            if (interfaceModel == null) {
                return;
            }
            if ((interfaceModel = interfaceModel.getHighestParent()) instanceof AbstractDwdmLineModel) {
                this.dwdmM = (AbstractDwdmLineModel)interfaceModel;
                this.dwdmM.addObserver(this);
                try {
                    this.dwdmPortM = (PortModel)this.dwdmM.getPortModel();
                    this.dwdmPortM.addObserver(this);
                    this.portModel.addObserver(this);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
    }

    protected String getProtectionDescription() {
        String string = "";
        if (this.dwdmM != null && this.retrieveIfModel() != null) {
            string = this.myPortRenderer.getDwdmLineProtectionDescription(this.retrieveIfModel(), true);
        }
        return string;
    }

    public String getTooltipText() {
        String string = super.getTooltipText();
        if (this.getIfModel() instanceof XPL2LineModel) {
            try {
                XPL2LineModel xPL2LineModel = (XPL2LineModel)this.getIfModel();
                if (xPL2LineModel.isTrunk()) {
                    DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)xPL2LineModel.getFirstLowerLayerModels();
                    string = string + ", WL: ";
                    string = string + Wavelength.getWlAttribute(dwdmTrkLineModel.getActualWaveLength()).getKey();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private InterfaceModel retrieveIfModel() {
        InterfaceModel interfaceModel = this.dwdmM;
        InterfaceModel interfaceModel2 = null;
        if (this.dwdmM != null) {
            interfaceModel2 = this.dwdmM.getPayloadModel();
            interfaceModel = interfaceModel2 instanceof TdmLineModel ? interfaceModel2 : this.dwdmM;
        }
        return interfaceModel;
    }
}

