/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ms.NppMultishelfLayoutPane;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.cms.ui.shelf.SppGeneralPane;
import cerent.cms.ui.shelf.SppMultishelfConfigPane;
import cerent.cms.ui.shelf.SppPowerMonitorPane;
import cerent.cms.ui.shelf.SppVoltageTempPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;

public class GeneralPane
extends AbstractPane {
    private static final SDebug db = new SDebug((KDebug)ShelfTabbedView.db, "GeneralPane");

    public GeneralPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        IModel iModel = this.getUiModel();
        this.subTabs = new SubTabbedView(iModel, tabbedView);
        this.subTabs.setTabPlacement(1);
        if (iModel instanceof IChassisModel) {
            IChassisModel iChassisModel = (IChassisModel)iModel;
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)iChassisModel.getNodeModel();
            IPlatform iPlatform = nodeModelDelegate.getPlatform();
            if (!nodeModelDelegate.isMultishelf()) {
                this.subTabs.add((Component)((Object)new SppGeneralPane("General", this.subTabs)));
            }
            if (iPlatform.supportsMultishelf()) {
                this.subTabs.add((Component)((Object)new SppMultishelfConfigPane("Multishelf Config", this.subTabs)));
            }
            this.subTabs.add((Component)((Object)new SppPowerMonitorPane("Power Monitor", this.subTabs)));
            this.subTabs.add((Component)((Object)new SppVoltageTempPane("Voltage/Temperature", this.subTabs)));
        } else {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)iModel;
            this.subTabs.add((Component)((Object)new SppGeneralPane("General", this.subTabs)));
            this.subTabs.add((Component)((Object)new NppMultishelfLayoutPane("Rack Layout Config", this.subTabs)));
        }
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    public void refresh() {
    }

    public void enteringPage() {
    }

    public void leavingPage() {
    }

    protected void displayErrorDialog(Pane pane, Exception exception, String string) {
    }
}

