/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.EtherMedia.eTransponderMode;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.HdGeModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.HdGePortGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class HdGeCard
extends CardGraphic {
    protected HdGePortGraphic[] portGraphics = null;
    protected Observer transponderChangeObserver;
    protected Collection transponderPairings;
    protected HdGeModuleModel.TransponderChangeNotifier tco = null;
    private boolean is327 = this.pci.is327();

    public HdGeCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        super(entityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "G1000:" + entityModel.getSlot()), true);
        if (entityModel instanceof ModuleModel) {
            List list = entityModel.getChildren();
            this.portGraphics = new HdGePortGraphic[list.size()];
            int n = this.is327 ? this.cardPainter.getOpticonXSpacing() : 0;
            for (int i = 0; i < list.size(); ++i) {
                this.portGraphics[i] = new HdGePortGraphic(this, n + this.cardPainter.getMiniMultiPortOticonXOffset() + this.cardPainter.getOpticonXSpacing() * i, this.cardPainter.getOpticonYOffset() + this.cardPainter.getOpticonYSpacing() * i, (PortModel)list.get(i));
            }
        }
        if (this.alarmStore != null) {
            this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
        }
        if (entityModel instanceof HdGeModuleModel) {
            this.transponderChangeObserver = new TransponderChangeObserver();
            this.tco = ((HdGeModuleModel)entityModel).getTransponderChangeNotifier();
            this.tco.addObserver(this.transponderChangeObserver);
            this.transponderPairings = this.tco.getCurrentTransponderPairingsWithoutDuplicates();
        }
    }

    private HdGePortGraphic lineIndexToHdgePortGraphic(int n) throws CmsObjectNotExistException {
        for (int i = 0; i < this.portGraphics.length; ++i) {
            if (this.portGraphics[i].getPortModel().getInterfaceModel().getIndex() != n) continue;
            return this.portGraphics[i];
        }
        return null;
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null || !this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return "";
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                PortModel portModel = this.portGraphics[i].getPortModel();
                IAlarmStatus iAlarmStatus = this.alarmStore.getEntityAlarmStatus(portModel);
                if (iAlarmStatus == null) continue;
                if (this.db.on()) {
                    int n = this.entityM.getSlot();
                    this.db.println("SlotNo=" + n + ", PortNo=" + portModel.getPort() + ", portEqType=" + portModel.getEqType() + ", AlarmStatus=" + iAlarmStatus + ", highest=" + iAlarmStatus.getHighestSeverity());
                }
                this.portGraphics[i].setAlarmState(iAlarmStatus.getHighestSeverity());
            }
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose HdGeCard");
        }
        if (this.transponderChangeObserver != null && this.tco != null) {
            this.tco.deleteObserver(this.transponderChangeObserver);
            this.transponderPairings = null;
            this.transponderChangeObserver = null;
        }
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].dispose();
            this.portGraphics[i] = null;
        }
        this.portGraphics = null;
        super.dispose();
    }

    private void drawTransponderCurves(Graphics2D graphics2D) {
        if (this.transponderPairings != null) {
            Iterator iterator = this.transponderPairings.iterator();
            HdGeModuleModel.sGmacLineAdminInfo_4_01_Key sGmacLineAdminInfo_4_01_Key2 = null;
            double[] dArray = new double[]{4.0, 3.0, 1.75, 1.75};
            boolean bl = false;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            while (iterator.hasNext()) {
                CubicCurve2D.Double double_;
                double d;
                double d2;
                double d3;
                double d4;
                sGmacLineAdminInfo_4_01_Key2 = (HdGeModuleModel.sGmacLineAdminInfo_4_01_Key)iterator.next();
                if (sGmacLineAdminInfo_4_01_Key2.getValue().mode == eTransponderMode.TRANSPONDER_NONE) continue;
                short s = (short)Math.abs(sGmacLineAdminInfo_4_01_Key2.getIndex() - sGmacLineAdminInfo_4_01_Key2.getValue().transpondingInterface);
                int n = Math.min(sGmacLineAdminInfo_4_01_Key2.getIndex(), sGmacLineAdminInfo_4_01_Key2.getValue().transpondingInterface);
                int n2 = Math.max(sGmacLineAdminInfo_4_01_Key2.getIndex(), sGmacLineAdminInfo_4_01_Key2.getValue().transpondingInterface);
                HdGePortGraphic hdGePortGraphic = null;
                HdGePortGraphic hdGePortGraphic2 = null;
                try {
                    hdGePortGraphic = this.lineIndexToHdgePortGraphic(n);
                    hdGePortGraphic2 = this.lineIndexToHdgePortGraphic(n2);
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                    continue;
                }
                if (sGmacLineAdminInfo_4_01_Key2.getValue().mode != eTransponderMode.TRANSPONDER_ONE_PORT_BIDIRECTIONAL) {
                    d4 = hdGePortGraphic.getCenterX();
                    d4 -= hdGePortGraphic.getWidth() / 2.0;
                    d3 = hdGePortGraphic.getCenterY();
                    d2 = hdGePortGraphic2.getCenterX();
                    d2 -= hdGePortGraphic2.getWidth() / 2.0;
                    d = hdGePortGraphic2.getCenterY();
                    if (this.is327) {
                        d = d3 = hdGePortGraphic.getCenterY() - hdGePortGraphic.getHeight() / 2.0;
                        d2 = hdGePortGraphic2.getCenterX() + hdGePortGraphic2.getWidth() / 2.0;
                        double_ = new CubicCurve2D.Double(d4, d3, d4 + (d2 - d4) / 100.0, d3 - 1.3 * hdGePortGraphic.getHeight(), d2 - (d2 - d4) / 100.0, d - 1.3 * hdGePortGraphic2.getHeight(), d2, d);
                    } else {
                        double_ = new CubicCurve2D.Double(d4, d3, d4 - hdGePortGraphic.getWidth() / dArray[s], Math.abs(d3 - d) / 100.0 + d3, d2 - hdGePortGraphic2.getWidth() / dArray[s], d - Math.abs(d3 - d) / 100.0, d2, d);
                    }
                    graphics2D.draw(double_);
                    continue;
                }
                if (sGmacLineAdminInfo_4_01_Key2.getValue().mode != eTransponderMode.TRANSPONDER_ONE_PORT_BIDIRECTIONAL) continue;
                d4 = hdGePortGraphic.getCenterX();
                d4 -= hdGePortGraphic.getWidth() / 2.0;
                d3 = hdGePortGraphic.getCenterY() - hdGePortGraphic.getHeight() / 2.0;
                d2 = hdGePortGraphic2.getCenterX();
                d2 -= hdGePortGraphic2.getWidth() / 2.0;
                d = hdGePortGraphic2.getCenterY() + hdGePortGraphic2.getHeight() / 2.0;
                if (this.is327) {
                    d = d3 = hdGePortGraphic.getCenterY() - hdGePortGraphic.getHeight() / 2.0;
                    d2 = hdGePortGraphic2.getCenterX() + hdGePortGraphic2.getWidth() / 2.0;
                    double_ = new CubicCurve2D.Double(d4, d3, d4 + (d2 - d4) / 100.0, d3 - 1.4 * hdGePortGraphic.getHeight(), d2 - (d2 - d4) / 100.0, d - 1.4 * hdGePortGraphic2.getHeight(), d2, d);
                } else {
                    double_ = new CubicCurve2D.Double(d4, d3, d4 - hdGePortGraphic.getWidth() / dArray[s], Math.abs(d3 - d) / 100.0 + d3, d2 - hdGePortGraphic2.getWidth() / dArray[s], d - Math.abs(d3 - d) / 100.0, d2, d);
                }
                graphics2D.draw(double_);
            }
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        for (int i = 0; i < this.portGraphics.length; ++i) {
            if (this.portGraphics[i] == null) continue;
            this.portGraphics[i].draw(graphics2D);
        }
        this.drawTransponderCurves(graphics2D);
    }

    private class TransponderChangeObserver
    implements Observer {
        private TransponderChangeObserver() {
        }

        public void update(Observable observable, Object object) {
            HdGeCard.this.transponderPairings = null;
            HdGeCard.this.repaint();
            HdGeCard.this.transponderPairings = (Collection)object;
            HdGeCard.this.repaint();
        }
    }
}

