/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.DwdmApcModel;
import cerent.cms.model.DwdmApcModels;
import cerent.cms.model.IDwdmApcModel;
import cerent.cms.model.IDwdmApcModels;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.DwdmSideRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.MaintApcDataSource;
import cerent.cms.ui.shelf.MaintApcTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class MaintApcPane
extends AbstractPane
implements Observer,
ActionListener {
    private static final String SIDE_LABEL = "Side: ";
    private static final String REFRESH = "Refresh";
    private static final String NO_SIDES = "No sides";
    private static final String ALL_SIDES = "All";
    private JComboBox sidesCB = new JComboBox();
    private JLabel sidesLabel = new JLabel("Side: ");
    private JButton refreshapcButton = new JButton("Refresh");
    private MaintApcDataSource dataSource;
    private boolean initialized = true;
    private int[] sortCols = new int[]{0};
    private boolean[] sortDir = new boolean[]{false};
    private NodeModelDelegate nodeModel;
    private DwdmApcModels apcModels;
    private IDwdmApcModel[] apcModelsArray;
    public static final int NO_SIDE = 0;
    private int fixedSide;
    private boolean isPluginPane;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "MaintApcPane");

    public MaintApcPane(String string, TabbedView tabbedView, DwdmApcModels dwdmApcModels, int n, boolean bl) {
        super(string, tabbedView);
        this.apcModels = dwdmApcModels;
        this.fixedSide = n;
        this.isPluginPane = bl;
    }

    private void init() {
        if (db.on()) {
            db.println("init");
        }
        this.nodeModel = (NodeModelDelegate)this.apcModels.getNodeModel();
        this.apcModelsArray = this.apcModels.getAllDwdmApcModel();
        this.apcModels.addObserver(this);
        for (int i = 0; i < this.apcModelsArray.length; ++i) {
            DwdmApcModel dwdmApcModel = (DwdmApcModel)this.apcModelsArray[i];
            dwdmApcModel.addObserver(this);
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.setLayout(new BorderLayout());
        this.dataSource = new MaintApcDataSource(this.apcModels);
        if (this.apcModels.getAllDwdmApcModel().length != 0 && this.isPluginPane) {
            try {
                DwdmApcModel dwdmApcModel = this.apcModels.getDwdmApcModel(this.fixedSide);
                this.dataSource.setCurrentSide(this.fixedSide);
                dwdmApcModel.addObserver(this.dataSource);
            }
            catch (WrongNodeSide wrongNodeSide) {
                SDebug.printStackTrace((Throwable)wrongNodeSide);
            }
        } else {
            this.loadSides();
            this.add(this.makeSidesPanel(), "North");
        }
        MaintApcTableModel maintApcTableModel = new MaintApcTableModel(this.dataSource, this.sortCols, this.sortDir);
        this.table = new UTable((TableModel)((Object)maintApcTableModel));
        ((MaintApcTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.add(this.makeControlPanel(), "South");
    }

    private JPanel makeSidesPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.sidesCB.addActionListener(this);
        this.sidesCB.setRenderer(new DwdmSideRenderer());
        jPanel.add(this.sidesLabel);
        jPanel.add(this.sidesCB);
        return jPanel;
    }

    private void loadSides() {
        if (this.apcModels.getAllDwdmApcModel().length != 0) {
            int n;
            Object object;
            int n2;
            String string = (String)this.sidesCB.getSelectedItem();
            for (n2 = 0; n2 < this.apcModelsArray.length; ++n2) {
                object = (String[])this.apcModelsArray[n2];
                object.deleteObserver((Observer)this);
            }
            this.apcModelsArray = this.apcModels.getAllDwdmApcModel();
            for (n2 = 0; n2 < this.apcModelsArray.length; ++n2) {
                object = (DwdmApcModel)this.apcModelsArray[n2];
                object.addObserver((Observer)this);
            }
            String[] stringArray = null;
            if (this.apcModelsArray.length > 1) {
                object = new String[this.apcModelsArray.length + 1];
                for (n = 0; n < this.apcModelsArray.length; ++n) {
                    object[n] = ((DwdmApcModel)this.apcModelsArray[n]).getSide();
                }
                object[((String[])object).length - 1] = ALL_SIDES;
                stringArray = object;
            } else {
                stringArray = this.apcModelsArray.length == 1 ? new String[]{((DwdmApcModel)this.apcModelsArray[0]).getSide()} : new String[]{};
            }
            object = new DefaultComboBoxModel<String>(stringArray);
            this.sidesCB.setModel(object);
            this.sidesCB.setEnabled(true);
            this.sidesLabel.setEnabled(true);
            if (string != null) {
                if (string.equals(ALL_SIDES)) {
                    this.sidesCB.setSelectedIndex(this.sidesCB.getItemCount() - 1);
                } else if (!string.equals(NO_SIDES) && (n = ((DefaultComboBoxModel)object).getIndexOf(string)) < this.apcModelsArray.length) {
                    this.sidesCB.setSelectedIndex(n);
                }
            } else if (this.sidesCB.getItemCount() > 0) {
                this.sidesCB.setSelectedIndex(this.sidesCB.getItemCount() - 1);
                String string2 = (String)this.sidesCB.getSelectedItem();
                int n3 = string2.equals(ALL_SIDES) ? 9 : (int)((short)DwdmSide.getIndexOf(string2));
                this.dataSource.setCurrentSide(n3);
                this.refresh();
            }
        } else {
            String[] stringArray = new String[]{NO_SIDES};
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
            this.sidesCB.setModel(defaultComboBoxModel);
            this.sidesLabel.setEnabled(false);
            this.sidesCB.setEnabled(false);
        }
    }

    private JPanel makeControlPanel() {
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.MaintApcPane);
        cSHelpButtonPane = this.isPluginPane ? new CSHelpButtonPane(null) : new CSHelpButtonPane(CSHelpConst.MaintApcPane);
        this.refreshapcButton.addActionListener(this);
        this.enableComponent(this.refreshapcButton, this.nodeModel, SecurityLevel.RETRIEVE);
        cSHelpButtonPane.addLeft(this.refreshapcButton);
        return cSHelpButtonPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.refreshapcButton) {
            try {
                this.refresh();
            }
            catch (Exception exception) {
                KDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_ANS);
            }
        } else if (object == this.sidesCB) {
            String string = (String)this.sidesCB.getSelectedItem();
            int n = string.equals(ALL_SIDES) ? 9 : DwdmSide.getIndexOf(string);
            this.dataSource.setCurrentSide(n);
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            if (this.sidesCB.getModel().getSize() > 1) {
                this.sidesCB.setSelectedItem(ALL_SIDES);
            }
            if (this.initialized) {
                this.readApcStatus();
                this.initialized = false;
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.initialized = true;
    }

    public void refresh() {
        this.readApcStatus();
    }

    public void readApcStatus() {
        Object object = this.sidesCB.getSelectedItem();
        try {
            if (object != null && (this.apcModels.getDwdmApcModel(this.dataSource.getCurrentSide()) != null || object.equals(ALL_SIDES))) {
                this.dataSource.getApcList();
            } else {
                this.loadSides();
            }
        }
        catch (WrongNodeSide wrongNodeSide) {
            SDebug.printStackTrace((Throwable)wrongNodeSide);
        }
    }

    public void destroy() {
        Object object;
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dataSource != null) {
            if (this.isPluginPane) {
                try {
                    object = this.apcModels.getDwdmApcModel(this.fixedSide);
                    object.deleteObserver((Observer)this.dataSource);
                }
                catch (WrongNodeSide wrongNodeSide) {
                    SDebug.printStackTrace((Throwable)wrongNodeSide);
                }
            }
            this.dataSource.dispose();
            this.dataSource = null;
        }
        object = this.apcModels.getAllDwdmApcModel();
        for (int i = 0; i < ((IDwdmApcModel[])object).length; ++i) {
            DwdmApcModel dwdmApcModel = (DwdmApcModel)object[i];
            dwdmApcModel.deleteObserver(this);
        }
        if (this.apcModels != null) {
            this.apcModels.deleteObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof IDwdmApcModel) {
            IDwdmApcModel iDwdmApcModel = (IDwdmApcModel)observable;
            int n = (Integer)object;
            if (db.on()) {
                db.println("update: received IDwdmApcModel event - eventType = " + n + ",  sideId = " + iDwdmApcModel.getApcNodeSide());
            }
            if (n == ModelUpdateType.DELETED) {
                this.loadSides();
            }
        } else if (observable instanceof IDwdmApcModels) {
            this.loadSides();
        }
    }
}

