/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OSI.sGriEntry;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.AbstractOsiRouterRibPane;
import cerent.cms.ui.shelf.GriTableRow;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;

public class OsiRouterGriPane
extends AbstractOsiRouterRibPane {
    public OsiRouterGriPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFromModel() throws Exception {
        block9: {
            this.tableData.clear();
            this.updateBottomPanel();
            if (this.osiModel.getRoutingMode() == 0) {
                return;
            }
            try {
                sGriEntry[] sGriEntryArray = this.routerModel.getGriTable(this.getSelectedRouterNumber());
                ArrayList arrayList = this.tableData;
                synchronized (arrayList) {
                    if (sGriEntryArray != null) {
                        for (int i = 0; i < sGriEntryArray.length; ++i) {
                            for (int j = 0; j < sGriEntryArray[i].grcbList.length; ++j) {
                                GriTableRow griTableRow = new GriTableRow(sGriEntryArray[i].routePriority, sGriEntryArray[i].destination, sGriEntryArray[i].grcbList[j].type, sGriEntryArray[i].grcbList[j].dccIndex, sGriEntryArray[i].grcbList[j].routeRank, sGriEntryArray[i].grcbList[j].snpa, this);
                                db.fine("GRI Entry " + i + "," + j + " " + griTableRow);
                                this.tableData.add(griTableRow);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                db.severe("Error in getting GRI table:" + exception);
                if (!db.on()) break block9;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.tableModel.dataSourceChanged();
    }

    protected String getStringValue(Object object, int n) {
        String string = "???";
        GriTableRow griTableRow = (GriTableRow)object;
        switch (n) {
            case 0: {
                string = this.subnetTypeStr(griTableRow.getSubnetType());
                break;
            }
            case 1: {
                string = this.locationStr(griTableRow.getSubnetType(), griTableRow.getDccIndex());
                break;
            }
            case 2: {
                string = OsiHelper.getNsapString((byte[])griTableRow.getDestNSAP(), (boolean)false);
                break;
            }
            case 3: {
                string = this.subnetAddrStr(griTableRow.getSubnetType(), griTableRow.getSnpa());
            }
        }
        return string;
    }

    protected AbstractRowDataSource createDataSource() {
        return new GriDataSource();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SmpOsiISRIBPane;
    }

    class GriDataSource
    extends AbstractRowDataSource {
        GriDataSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            ArrayList arrayList = OsiRouterGriPane.this.tableData;
            synchronized (arrayList) {
                var2_2 = OsiRouterGriPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            ArrayList arrayList = OsiRouterGriPane.this.tableData;
            synchronized (arrayList) {
                n = OsiRouterGriPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            ArrayList arrayList = OsiRouterGriPane.this.tableData;
            synchronized (arrayList) {
                return OsiRouterGriPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return GriTableRow.class;
        }
    }
}

