/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Node.eDccType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.DccBackBoneArea;
import cerent.cms.model.DccHasBlsr;
import cerent.cms.model.DccNumOutOfRange;
import cerent.cms.model.DuplicateDccNum;
import cerent.cms.model.DuplicateOspfAreaId;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IDccOspfArea;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LanRipAlreadyRun;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OspfLanConfig;
import cerent.cms.model.OspfLanConfigModel;
import cerent.cms.model.OspfMetricZero;
import cerent.cms.model.SdccTermConnectionModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.StandbyTccNotReady;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.ui.shelf.AuthEditDialog;
import cerent.cms.ui.shelf.AuthKeyDialog;
import cerent.cms.ui.shelf.OspfAreaRangePane;
import cerent.cms.ui.shelf.OspfVLinkPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.TextPanel;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.Document;

public class OspfPane
extends NodeProvPane
implements ActionListener,
DocumentListener {
    private static final SDebug db = new SDebug("OspfPane");
    public static String[] authChoices = new String[]{"No Authentication", "Simple Password"};
    private static final String adminString = "ADMIN";
    private static final String authTypeString = "AUTHTYPE";
    private static final int FROM_REFRESH = 0;
    private static final int FROM_PERFORMED = 1;
    private static boolean createEntry = false;
    private static final int SHELF_NUM = 0;
    private static final int SLOT_NUM = 1;
    private static final int PORT_NUM = 2;
    private static final int AREA_ID = 3;
    TabbedView parent;
    private boolean supportsOspfAreaRange = true;
    OspfAreaRangePane ospfAreaRangePane;
    OspfVLinkPane ospfVLinkPane;
    protected TDMTerminology tdmTerm;
    JCheckBox adminCB;
    JTextField areaIdTF;
    JTextField rtrPriorityTF;
    JTextField helloIntTF;
    JTextField deadIntTF;
    JTextField transitDelayTF;
    JTextField retransitIntTF;
    JTextField metricTF;
    JTextField sdccMetricTF;
    JTextField ldccMetricTF;
    JButton authButton;
    protected int authTypeInt;
    protected String authKeyStr;
    protected String BLSR_TERM;
    boolean adminDirty;
    boolean areaIdDirty;
    boolean rtrPriorityDirty;
    boolean helloIntDirty;
    boolean deadIntDirty;
    boolean transitDelayDirty;
    boolean retransitIntDirty;
    boolean metricDirty;
    boolean sdccMetricDirty;
    boolean ldccMetricDirty;
    boolean dccAreaIdDirty;
    boolean authTypeDirty;
    boolean authStringDirty;
    NodeModelDelegate nodeModel;
    OspfLanConfigModel ospfLanConfigModel;
    ArrayList areaIdTableData = new ArrayList();
    OspfAreaIdTableModel ospfAreaIdTableModel = null;

    public OspfPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.parent = tabbedView;
    }

    private void init() {
        JPanel jPanel;
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
        boolean bl = true;
        if (this.nodeModel != null && this.nodeModel.getPlatform().isSecureModeSupported() && this.nodeModel.isSecureMode()) {
            bl = this.isUserAuthorized(SecurityLevel.SUPERUSER);
        }
        this.ospfLanConfigModel = (OspfLanConfigModel)this.nodeModel.getOspfLanConfigModel();
        this.ospfLanConfigModel.addObserver((Observer)((Object)this));
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.tdmTerm = this.nodeModel.getTDMTerminology();
        this.BLSR_TERM = this.tdmTerm.getRingTerms(1);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel2);
        this.add((Component)uScrollPane);
        JPanel jPanel3 = OspfPane.createHorizontalPanel(null);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        JPanel jPanel4 = OspfPane.createHorizontalPanel("DCC/GCC OSPF Area Id Table");
        jPanel4.setPreferredSize(new Dimension(300, 150));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        jPanel2.add(jPanel3);
        this.ospfAreaIdTableModel = new OspfAreaIdTableModel();
        this.table = new UTable((TableModel)this.ospfAreaIdTableModel);
        UScrollPane uScrollPane2 = new UScrollPane((Component)this.table);
        jPanel4.add((Component)uScrollPane2);
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel3 = OspfPane.createHorizontalPanel(null);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        String string = this.tdmTerm.getGeneralTerms(8);
        String string2 = this.tdmTerm.getGeneralTerms(10);
        this.sdccMetricTF = this.getTextField(jPanel3, " " + string + " Metric: ", 4, null, null);
        jPanel3.add(this.sdccMetricTF);
        IPlatform iPlatform = this.nodeModel.getPlatform();
        if (iPlatform.supportsLDCC()) {
            this.ldccMetricTF = this.getTextField(jPanel3, "  " + string2 + " Metric: ", 4, null, null);
            jPanel3.add(this.ldccMetricTF);
        }
        jPanel3.add(Box.createHorizontalGlue());
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel3 = OspfPane.createHorizontalPanel(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JPanel jPanel5 = OspfPane.createHorizontalPanel("OSPF on LAN");
        jPanel5.setLayout(gridBagLayout);
        this.adminCB = new JCheckBox("OSPF active on LAN");
        this.adminCB.setActionCommand(adminString);
        this.adminCB.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.adminCB, gridBagConstraints);
        jPanel5.add(this.adminCB);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.areaIdTF = this.getTextField(jPanel5, "LAN Port Area ID: ", 12, gridBagLayout, gridBagConstraints);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        JLabel jLabel = new JLabel("Authentication Type: ");
        jPanel6.add(jLabel);
        this.authButton = new JButton("");
        this.authButton.setActionCommand(authTypeString);
        this.authButton.addActionListener(this);
        jPanel6.add(this.authButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        jPanel5.add(jPanel6);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.rtrPriorityTF = this.getTextField(jPanel5, "Router Priority:     ", 4, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.helloIntTF = this.getTextField(jPanel5, "Hello Interval (sec):  ", 8, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.deadIntTF = this.getTextField(jPanel5, "Dead Interval (sec): ", 8, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.transitDelayTF = this.getTextField(jPanel5, "Transmit Delay (sec): ", 4, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.retransitIntTF = this.getTextField(jPanel5, "Retransmit Interval (sec): ", 4, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.metricTF = this.getTextField(jPanel5, "LAN Metric:              ", 4, gridBagLayout, gridBagConstraints);
        jPanel3.add(jPanel5);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(5));
        if (this.supportsOspfAreaRange && bl) {
            jPanel = OspfPane.createHorizontalPanel("OSPF Area Range Table");
            jPanel.setPreferredSize(new Dimension(300, 150));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
            this.ospfAreaRangePane = new OspfAreaRangePane("", this.parent);
            jPanel.add((Component)((Object)this.ospfAreaRangePane));
            jPanel2.add(jPanel);
            jPanel2.add(Box.createVerticalGlue());
            jPanel2.add(Box.createVerticalStrut(5));
        }
        if (bl) {
            jPanel = OspfPane.createHorizontalPanel("OSPF Virtual Link Table");
            jPanel.setPreferredSize(new Dimension(300, 150));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
            this.ospfVLinkPane = new OspfVLinkPane("", this.parent);
            jPanel.add((Component)((Object)this.ospfVLinkPane));
            jPanel2.add(jPanel);
        }
        jPanel2.add(new JPanel(new BorderLayout()));
        if (((NodeModelDelegate)this.getUiModel().getNodeModel()).isSecureMode() || ((NodeModelDelegate)this.getUiModel().getNodeModel()).getIpConfig().getNodeMode()) {
            this.adminCB.setEnabled(false);
        } else {
            this.enableComponent(this.adminCB);
        }
        this.enableComponent(this.areaIdTF);
        this.enableComponent(this.rtrPriorityTF);
        this.enableComponent(this.helloIntTF);
        this.enableComponent(this.deadIntTF);
        this.enableComponent(this.transitDelayTF);
        this.enableComponent(this.retransitIntTF);
        this.enableComponent(this.metricTF);
        this.enableComponent(this.authButton);
        this.registerWithModel();
        if (this.getUiModel() instanceof IChassisModel) {
            this.removeColumn(0);
        }
    }

    private void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.ospfAreaIdTableModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    private JTextField getTextField(JPanel jPanel, String string, int n, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        TextPanel textPanel = new TextPanel(string, n);
        JTextField jTextField = textPanel.getTextField();
        if (gridBagLayout != null && gridBagConstraints != null) {
            gridBagLayout.setConstraints(textPanel, gridBagConstraints);
        }
        jPanel.add(textPanel);
        if (this.isUserAuthorized()) {
            jTextField.getDocument().addDocumentListener(this);
        } else {
            jTextField.setEditable(false);
        }
        return jTextField;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.OspfPane;
    }

    protected boolean authCheckSucceeded() {
        boolean bl;
        block8: {
            bl = false;
            if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
                return true;
            }
            try {
                if (this.authTypeInt == 0) {
                    return true;
                }
                if (this.authKeyStr.equals("")) {
                    return true;
                }
                JPasswordField jPasswordField = new JPasswordField();
                Object[] objectArray = new Object[]{"Enter Existing Authentication Key:", jPasswordField};
                String string = "OK";
                String string2 = "Cancel";
                Object[] objectArray2 = new Object[]{string, string2};
                JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
                ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
                arrayList.add(jOptionPane);
                arrayList.add(jPasswordField);
                AuthKeyDialog authKeyDialog = AuthKeyDialog.instance((Component)((Object)this), true, "Authentication Key Entry", arrayList);
                try {
                    authKeyDialog.show();
                    if (!jOptionPane.getValue().equals(string)) break block8;
                    String string3 = new String(jPasswordField.getPassword());
                    if (string3.equals(this.authKeyStr)) {
                        bl = true;
                        break block8;
                    }
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_AUTH_KEY_MISMATCH);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_AUTH_ERROR);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_AUTH_ERROR);
            }
        }
        return bl;
    }

    public boolean onValidate() {
        int n;
        if (this.sdccMetricDirty) {
            try {
                n = Integer.parseInt(this.sdccMetricTF.getText());
                if (n < 1 || n > 65535) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DCC_METRIC_RANGE);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_DCC_METRIC);
                return false;
            }
        }
        if (this.ldccMetricDirty) {
            try {
                n = Integer.parseInt(this.ldccMetricTF.getText());
                if (n < 1 || n > 65535) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DCC_METRIC_RANGE);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_DCC_METRIC);
                return false;
            }
        }
        if (this.adminCB.isSelected()) {
            String string = this.areaIdTF.getText().trim();
            if (this.areaIdDirty) {
                try {
                    InetUtil.makeIpAddr(string);
                }
                catch (Exception exception) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_IP_ADDR_PARAM_1, (Object)exception.getMessage());
                    return false;
                }
            }
            if (this.adminDirty && !CerentDialog.yesNoDialog((Component)((Object)this), (String)("<html>" + EMC.WID_OSPF_ON_LAN + "</html>" + "\nAre you sure you wish to continue?"), (String)"Enable OSPF on the LAN?")) {
                return false;
            }
            if (!this.validateForOspfOnLan(string)) {
                return false;
            }
        }
        if (this.rtrPriorityDirty) {
            try {
                int n2 = Integer.parseInt(this.rtrPriorityTF.getText());
                if (n2 < 0 || n2 > 255) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ROUTER_PRIORITY_RANGE);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_ROUTER_PRIORITY);
                return false;
            }
        }
        if (this.helloIntDirty || this.deadIntDirty) {
            int n3 = 0;
            int n4 = 0;
            try {
                n3 = Integer.parseInt(this.helloIntTF.getText());
                if (n3 < 1 || n3 > 65535) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_HELLO_INTVL_RANGE);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_HELLO_INTVL);
                return false;
            }
            try {
                n4 = Integer.parseInt(this.deadIntTF.getText());
                if (n4 < 1) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_DEAD_INTVL);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_DEAD_INTVL);
                return false;
            }
            if (n3 >= n4) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DEAD_LESS_THAN_HELLO);
                return false;
            }
        }
        if (this.transitDelayDirty) {
            try {
                int n5 = Integer.parseInt(this.transitDelayTF.getText());
                if (n5 < 1 || n5 > 3600) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_LAN_TRANSMIT_RANGE);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_LAN_TRANSMIT);
                return false;
            }
        }
        if (this.retransitIntDirty) {
            try {
                int n6 = Integer.parseInt(this.retransitIntTF.getText());
                if (n6 < 1 || n6 > 3600) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_RETRANSIT_RANGE);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_RETRANSIT);
                return false;
            }
        }
        if (this.metricDirty) {
            try {
                int n7 = Integer.parseInt(this.metricTF.getText());
                if (n7 < 1 || n7 > 65535) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_LAN_METRIC_RANGE);
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_LAN_METRIC);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateForOspfOnLan(String string) {
        int n = InetUtil.parseDottedString(string);
        if (this.areaIdTableData != null) {
            ArrayList arrayList = this.areaIdTableData;
            synchronized (arrayList) {
                for (int i = 0; i < this.areaIdTableData.size(); ++i) {
                    IDccOspfArea iDccOspfArea = (IDccOspfArea)this.areaIdTableData.get(i);
                    IIpAddr iIpAddr = iDccOspfArea.getAreaId();
                    int n2 = InetUtil.makeIpV4(iIpAddr);
                    if (n2 == 0) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_LAN_NO_DCC_BCAST);
                        return false;
                    }
                    if (n2 != n) continue;
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_LAN_DCC_IDS_DIFFERENT);
                    return false;
                }
            }
        }
        return true;
    }

    private String getDccBlsrExceptionMsg() {
        String string = "Both the East and West ports in a " + this.BLSR_TERM + " must have the same OSPF Area ID. \n";
        string = string + "This Area ID change does not meet this requirement.  Include both East and \n";
        string = string + "West " + this.BLSR_TERM + " ports in the OSPF Area ID change and try again.";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangesToModel() throws Exception {
        Object object;
        OspfLanConfig ospfLanConfig = this.ospfLanConfigModel.getLanOspfConf();
        boolean bl = false;
        boolean bl2 = this.adminCB.isSelected();
        String string = this.areaIdTF.getText().trim();
        if (db.on()) {
            db.println("adminCB.isSelected(): " + bl2);
            db.println("dotted areaID: " + (bl2 ? String.valueOf(InetUtil.parseDottedString(string)) : string));
        }
        if (this.adminDirty && ospfLanConfig.getIfAdminStat() != bl2) {
            ospfLanConfig.setIfAdminStat(bl2);
            bl = true;
        }
        if (this.authTypeDirty) {
            ospfLanConfig.setAuthType(this.authTypeInt);
            bl = true;
        }
        if (this.authStringDirty) {
            ospfLanConfig.setAuthKey(this.authKeyStr);
            bl = true;
        }
        if (this.areaIdDirty && bl2) {
            object = InetUtil.makeIpAddr(string);
            ospfLanConfig.setAreaId((IIpAddr)object);
            bl = true;
        }
        if (this.rtrPriorityDirty) {
            int n = Integer.parseInt(this.rtrPriorityTF.getText());
            ospfLanConfig.setIfRtrPriority((char)n);
            bl = true;
        }
        if (this.helloIntDirty) {
            int n = Integer.parseInt(this.helloIntTF.getText());
            ospfLanConfig.setIfHelloInterval(n);
            bl = true;
        }
        if (this.deadIntDirty) {
            int n = Integer.parseInt(this.deadIntTF.getText());
            ospfLanConfig.setIfRtrDeadInterval(n);
            bl = true;
        }
        if (this.transitDelayDirty) {
            int n = Integer.parseInt(this.transitDelayTF.getText());
            ospfLanConfig.setIfTransitDelay((short)n);
            bl = true;
        }
        if (this.retransitIntDirty) {
            int n = Integer.parseInt(this.retransitIntTF.getText());
            ospfLanConfig.setIfRetransitInterval((short)n);
            bl = true;
        }
        if (this.metricDirty) {
            int n = Integer.parseInt(this.metricTF.getText());
            ospfLanConfig.setIfMetric(n);
            bl = true;
        }
        if (this.sdccMetricDirty) {
            int n = Integer.parseInt(this.sdccMetricTF.getText());
            this.ospfLanConfigModel.setDccMet(eDccType.IF_SDCC, n);
        }
        if (this.ldccMetricDirty) {
            int n = Integer.parseInt(this.ldccMetricTF.getText());
            this.ospfLanConfigModel.setDccMet(eDccType.IF_LDCC, n);
        }
        if (bl && !bl2) {
            try {
                this.ospfLanConfigModel.setLanOspfConf(ospfLanConfig);
            }
            catch (LanRipAlreadyRun lanRipAlreadyRun) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_RIP_ACTIVE_ON_LAN);
            }
            catch (DuplicateOspfAreaId duplicateOspfAreaId) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DUPLICATE_OSPF_AREA_ID);
            }
            catch (OspfMetricZero ospfMetricZero) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_METRIC_ZERO);
            }
            catch (StandbyTccNotReady standbyTccNotReady) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_STBY_CONTROLLER_NOT_RDY_PARAM_1, (Object)this.pci.getControlCardName());
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_IP_ADDR_PARAM_1, (Object)exception.getMessage());
            }
        }
        if (this.dccAreaIdDirty) {
            object = this.areaIdTableData;
            synchronized (object) {
                if (this.areaIdTableData != null && this.areaIdTableData.size() > 0) {
                    IDccOspfArea[] iDccOspfAreaArray = new IDccOspfArea[this.areaIdTableData.size()];
                    for (int i = 0; i < this.areaIdTableData.size(); ++i) {
                        iDccOspfAreaArray[i] = (IDccOspfArea)this.areaIdTableData.get(i);
                        if (!db.on()) continue;
                        db.println("Set #" + i + " DCC=" + iDccOspfAreaArray[i].getDccIndex() + ", AID=" + InetUtil.makeDottedString(iDccOspfAreaArray[i].getAreaId(), false));
                    }
                    try {
                        this.ospfLanConfigModel.setDccOspfAreaId(iDccOspfAreaArray);
                    }
                    catch (DuplicateDccNum duplicateDccNum) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DUPLICATE_DCC_PARAM_1, (Object)duplicateDccNum.getMessage());
                    }
                    catch (DccHasBlsr dccHasBlsr) {
                        ErrorMsg.displayError((Component)((Object)this), EMC.EID_DCC_HAS_BLSR_PARAM_2, this.BLSR_TERM, this.getDccBlsrExceptionMsg());
                    }
                    catch (DuplicateOspfAreaId duplicateOspfAreaId) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DUPLICATE_OSPF_AREA_ID);
                    }
                    catch (DccNumOutOfRange dccNumOutOfRange) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DCC_NUM_OUT_OF_RANGE);
                    }
                    catch (DccBackBoneArea dccBackBoneArea) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DCC_BACK_BONE_AREA);
                    }
                    catch (StandbyTccNotReady standbyTccNotReady) {
                        ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_STBY_CONTROLLER_NOT_RDY_PARAM_1, (Object)this.pci.getControlCardName());
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                }
            }
        }
        if (bl && bl2) {
            try {
                this.ospfLanConfigModel.setLanOspfConf(ospfLanConfig);
                if (this.adminDirty && createEntry) {
                    this.ospfAreaRangePane.createEntryIfEmptyTable();
                }
            }
            catch (LanRipAlreadyRun lanRipAlreadyRun) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_RIP_ACTIVE_ON_LAN);
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        if (db.on()) {
            db.println("apply...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFromModel() throws Exception {
        createEntry = false;
        OspfLanConfig ospfLanConfig = this.ospfLanConfigModel.getLanOspfConf();
        this.sdccMetricTF.setText(String.valueOf(this.ospfLanConfigModel.getDccMet(eDccType.IF_SDCC)));
        if (this.ldccMetricTF != null) {
            this.ldccMetricTF.setText(String.valueOf(this.ospfLanConfigModel.getDccMet(eDccType.IF_LDCC)));
        }
        if (db.on()) {
            db.println("refresh: lanconfig is " + ospfLanConfig.getIfAdminStat());
        }
        if (((NodeModelDelegate)this.getUiModel().getNodeModel()).isSecureMode() || ((NodeModelDelegate)this.getUiModel().getNodeModel()).getIpConfig().getNodeMode()) {
            this.adminCB.setEnabled(false);
        } else {
            this.adminCB.setSelected(ospfLanConfig.getIfAdminStat());
        }
        IIpAddr iIpAddr = ospfLanConfig.getAreaId();
        if (iIpAddr != null) {
            this.areaIdTF.setText(InetUtil.makeDottedString(iIpAddr, false));
        } else {
            this.areaIdTF.setText("");
        }
        this.authTypeInt = ospfLanConfig.getAuthType();
        this.authButton.setText(authChoices[this.authTypeInt]);
        this.authKeyStr = ospfLanConfig.getAuthKey();
        this.enableAdmin(0);
        if (db.on()) {
            db.println("router priority refresh is " + ospfLanConfig.getIfRtrPriority());
        }
        this.rtrPriorityTF.setText(String.valueOf(ospfLanConfig.getIfRtrPriority()));
        this.helloIntTF.setText(String.valueOf(ospfLanConfig.getIfHelloInterval()));
        this.deadIntTF.setText(String.valueOf(ospfLanConfig.getIfRtrDeadInterval()));
        this.transitDelayTF.setText(String.valueOf(ospfLanConfig.getIfTransitDelay()));
        this.retransitIntTF.setText(String.valueOf(ospfLanConfig.getIfRetransitInterval()));
        this.metricTF.setText(String.valueOf(ospfLanConfig.getIfMetric()));
        this.areaIdTableData.clear();
        IDccOspfArea[] iDccOspfAreaArray = this.ospfLanConfigModel.getDccOspfAreaIdArray();
        ArrayList arrayList = this.areaIdTableData;
        synchronized (arrayList) {
            if (iDccOspfAreaArray != null) {
                for (int i = 0; i < iDccOspfAreaArray.length; ++i) {
                    int n = iDccOspfAreaArray[i].getDccIndex();
                    String string = InetUtil.makeDottedString(iDccOspfAreaArray[i].getAreaId(), false);
                    if (db.on()) {
                        db.println("Refresh #" + i + " has DCC " + n + " and Area ID " + string);
                    }
                    this.areaIdTableData.add(iDccOspfAreaArray[i]);
                }
            }
        }
        this.ospfAreaIdTableModel.fireTableDataChanged();
        this.authStringDirty = false;
        this.authTypeDirty = false;
        this.metricDirty = false;
        this.retransitIntDirty = false;
        this.transitDelayDirty = false;
        this.deadIntDirty = false;
        this.helloIntDirty = false;
        this.rtrPriorityDirty = false;
        this.areaIdDirty = false;
        this.adminDirty = false;
        this.ldccMetricDirty = false;
        this.sdccMetricDirty = false;
        this.dccAreaIdDirty = false;
        if (db.on()) {
            db.println("refresh...");
        }
    }

    protected void documentModified(DocumentEvent documentEvent) {
        this.setDirty();
        Document document = documentEvent.getDocument();
        if (document == this.areaIdTF.getDocument()) {
            this.areaIdDirty = true;
            this.enableAdmin(1);
        } else if (document == this.rtrPriorityTF.getDocument()) {
            this.rtrPriorityDirty = true;
        } else if (document == this.helloIntTF.getDocument()) {
            this.helloIntDirty = true;
        } else if (document == this.deadIntTF.getDocument()) {
            this.deadIntDirty = true;
        } else if (document == this.transitDelayTF.getDocument()) {
            this.transitDelayDirty = true;
        } else if (document == this.retransitIntTF.getDocument()) {
            this.retransitIntDirty = true;
        } else if (document == this.metricTF.getDocument()) {
            this.metricDirty = true;
        } else if (document == this.sdccMetricTF.getDocument()) {
            this.sdccMetricDirty = true;
        } else if (document == this.ldccMetricTF.getDocument()) {
            this.ldccMetricDirty = true;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void enteringPage() throws Exception {
        if (this.adminCB == null) {
            this.init();
        } else if (((NodeModelDelegate)this.getUiModel().getNodeModel()).isSecureMode()) {
            this.adminCB.setEnabled(false);
        } else {
            this.enableComponent(this.adminCB);
        }
        if (this.supportsOspfAreaRange && this.ospfAreaRangePane != null) {
            this.ospfAreaRangePane.enteringPage();
        }
        if (this.ospfVLinkPane != null) {
            this.ospfVLinkPane.enteringPage();
        }
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        if (this.supportsOspfAreaRange && this.ospfAreaRangePane != null) {
            this.ospfAreaRangePane.leavingPage();
        }
        if (this.ospfVLinkPane != null) {
            this.ospfVLinkPane.leavingPage();
        }
    }

    public void destroy() {
        if (this.supportsOspfAreaRange && this.ospfAreaRangePane != null) {
            this.ospfAreaRangePane.destroy();
            this.ospfAreaRangePane = null;
        }
        if (this.ospfVLinkPane != null) {
            this.ospfVLinkPane.destroy();
            this.ospfVLinkPane = null;
        }
        if (this.ospfLanConfigModel != null) {
            this.ospfLanConfigModel.deleteObserver((Observer)((Object)this));
            this.ospfLanConfigModel = null;
        }
        this.areaIdTableData.clear();
        this.ospfAreaIdTableModel = null;
        super.destroy();
        this.nodeModel = null;
    }

    private void enableAdmin(int n) {
        boolean bl = this.adminCB.isSelected();
        this.areaIdTF.setEnabled(bl && this.isUserAuthorized());
        this.rtrPriorityTF.setEnabled(bl && this.isUserAuthorized());
        this.helloIntTF.setEnabled(bl && this.isUserAuthorized());
        this.deadIntTF.setEnabled(bl && this.isUserAuthorized());
        this.transitDelayTF.setEnabled(bl && this.isUserAuthorized());
        this.retransitIntTF.setEnabled(bl && this.isUserAuthorized());
        this.metricTF.setEnabled(bl && this.isUserAuthorized());
        this.authButton.setEnabled(bl && this.isUserAuthorized());
        if (!bl && this.areaIdTableData != null && this.areaIdTableData.size() > 1) {
            String string;
            IDccOspfArea iDccOspfArea = (IDccOspfArea)this.areaIdTableData.get(0);
            String string2 = InetUtil.makeDottedString(iDccOspfArea.getAreaId(), false);
            for (int i = 1; i < this.areaIdTableData.size() && string2.equals(string = InetUtil.makeDottedString((iDccOspfArea = (IDccOspfArea)this.areaIdTableData.get(i)).getAreaId(), false)); ++i) {
            }
        }
        createEntry = bl && n == 1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(adminString)) {
            this.setDirty();
            this.adminDirty = true;
            this.enableAdmin(1);
            if (db.on()) {
                db.println("admincb: " + this.adminCB.isSelected());
                db.println("createEntry: " + createEntry);
            }
        } else if (string.equals(authTypeString)) {
            if (this.authCheckSucceeded()) {
                try {
                    final JPasswordField jPasswordField = new JPasswordField();
                    final JPasswordField jPasswordField2 = new JPasswordField();
                    final JComboBox<String> jComboBox = new JComboBox<String>(authChoices);
                    jComboBox.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            boolean bl;
                            boolean bl2 = bl = jComboBox.getSelectedIndex() == 0;
                            if (bl) {
                                jPasswordField.setText("");
                                jPasswordField2.setText("");
                            }
                            jPasswordField.setEnabled(!bl);
                            jPasswordField2.setEnabled(!bl);
                        }
                    });
                    jComboBox.setSelectedIndex(this.authTypeInt);
                    jPasswordField.setText("");
                    Object[] objectArray = new Object[]{"Authentication Type", jComboBox, "Enter Authentication Key", jPasswordField, "Confirm Authentication Key", jPasswordField2};
                    String string2 = "OK";
                    String string3 = "Cancel";
                    Object[] objectArray2 = new Object[]{string2, string3};
                    JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
                    ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
                    arrayList.add(jOptionPane);
                    arrayList.add(jPasswordField);
                    arrayList.add(jPasswordField2);
                    arrayList.add(jComboBox);
                    AuthEditDialog authEditDialog = AuthEditDialog.instance((Component)((Object)this), true, "Edit Authentication Key", arrayList);
                    try {
                        authEditDialog.show();
                        if (jOptionPane.getValue().equals(string2)) {
                            this.authTypeInt = jComboBox.getSelectedIndex();
                            this.authKeyStr = String.valueOf(jPasswordField.getPassword());
                            this.authButton.setText(authChoices[this.authTypeInt]);
                            this.setDirty();
                            this.authTypeDirty = true;
                            this.authStringDirty = true;
                        }
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                catch (Exception exception) {
                    db.println("auth check succeeded, but setting failed.");
                    SDebug.printStackTrace((Throwable)exception);
                }
            } else {
                db.println("Authentication failed.");
            }
        }
    }

    class OspfAreaIdTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Shelf", "Slot", "Port", "Area Id"};

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return OspfPane.this.areaIdTableData.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            String string = "?";
            if (n < OspfPane.this.areaIdTableData.size()) {
                IPortModel iPortModel;
                IDccOspfArea iDccOspfArea;
                block10: {
                    iDccOspfArea = (IDccOspfArea)OspfPane.this.areaIdTableData.get(n);
                    int n3 = iDccOspfArea.getDccIndex();
                    SdccTermConnectionModel sdccTermConnectionModel = (SdccTermConnectionModel)OspfPane.this.nodeModel.getDccTermConnectionModel();
                    iPortModel = null;
                    try {
                        IEntityModel iEntityModel = sdccTermConnectionModel.getPortModelByLineIndex(n3);
                        if (iEntityModel instanceof IPortModel) {
                            iPortModel = (IPortModel)iEntityModel;
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) break block10;
                        db.println("no such model for " + n3);
                    }
                }
                switch (n2) {
                    case 0: {
                        if (iPortModel == null) break;
                        string = String.valueOf(iPortModel.getShelfId());
                        break;
                    }
                    case 1: {
                        if (iPortModel == null) break;
                        string = String.valueOf(iPortModel.getSlot());
                        break;
                    }
                    case 2: {
                        if (iPortModel == null) break;
                        string = PortHelper.getPortNumString((IPortModel)iPortModel);
                        break;
                    }
                    case 3: {
                        string = InetUtil.makeDottedString(iDccOspfArea.getAreaId(), false);
                    }
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n < OspfPane.this.areaIdTableData.size()) {
                block3: {
                    try {
                        String string = (String)object;
                        IIpAddr iIpAddr = InetUtil.makeIpAddr(string);
                        IDccOspfArea iDccOspfArea = (IDccOspfArea)OspfPane.this.areaIdTableData.get(n);
                        iDccOspfArea.setAreaId(iIpAddr);
                        OspfPane.this.setDirty();
                        OspfPane.this.dccAreaIdDirty = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!db.on()) break block3;
                        db.println("NumberFormatException of " + object + " at row " + n + ", col " + n2);
                    }
                }
                this.fireTableCellUpdated(n, n2);
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return AbstractPane.isUserAuthorized(OspfPane.this.nodeModel, SecurityLevel.PROVISIONING) && n2 == 3;
        }
    }
}

