/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.cms.ui.shelf.PassiveCreationDialog;
import cerent.cms.ui.shelf.PassivePortsTableModel;
import cerent.cms.ui.shelf.PassiveTableModel;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PassivePane
extends NodeProvPane
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private PassiveModuleModel[] _models = this.getPassiveModuleModels();
    private int _numModels = this._models == null ? 0 : this._models.length;
    private static final SDebug _db = new SDebug("PassivePane");
    private ChassisModel cm = this.getChassisModel();
    public static final String CREATE = "Create...";
    public static final String DELETE = "Delete...";
    private PassiveTableModel _passiveTableModel;
    private PassiveModuleModel selectedPM = null;
    private PassivePortsTableModel _portTableModel;
    private JButton _createPB;
    private JButton _deletePB;
    private JTable portTable = null;

    public PassivePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.init();
        this.registerWithModel();
    }

    public void dispose() {
        this._passiveTableModel.dispose();
        this._portTableModel.dispose();
        super.dispose();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
    }

    private void init() {
        this.createPanel();
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.prepareModuleColumns();
        this.preparePortColumns();
    }

    private void createPanel() {
        int n;
        this.setLayout(new BorderLayout());
        this.table = new UTable((TableModel)this.getPassiveTableModel());
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        for (n = 0; n < this.table.getColumnCount(); ++n) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
            tableColumn.setCellRenderer((TableCellRenderer)((Object)this.getRenderer()));
        }
        ((PassiveTableModel)this.table.getModel()).addTableModelListener(this);
        this.portTable = new UTable((TableModel)this.getPortTableModel());
        this.portTable.setRowSelectionAllowed(false);
        for (n = 0; n < this.portTable.getColumnCount(); ++n) {
            this.portTable.getColumnModel().getColumn(n).setCellRenderer((TableCellRenderer)((Object)this.getRenderer()));
        }
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagPanel.fillBoth();
        gridBagPanel.add((Component)new UScrollPane((Component)this.table), 0, 1);
        gridBagPanel.add((Component)new UScrollPane((Component)this.portTable), 1, 1);
        this.add(gridBagPanel, "Center");
        this.add(this.getButtonBar(), "South");
    }

    private void prepareModuleColumns() {
        TableColumn tableColumn = this.table.getColumn(PassiveTableModel._columnNames[1]);
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(PassiveTableModel._columnNames[0]);
        tableColumn.setPreferredWidth(70);
        tableColumn = this.table.getColumn(PassiveTableModel._columnNames[2]);
        tableColumn.setPreferredWidth(120);
        tableColumn = this.table.getColumn(PassiveTableModel._columnNames[3]);
        tableColumn.setPreferredWidth(200);
    }

    private void preparePortColumns() {
        TableColumn tableColumn = this.portTable.getColumn(PassivePortsTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.portTable.getColumn(PassivePortsTableModel.columnNames[1]);
        tableColumn.setPreferredWidth(150);
    }

    protected JPanel getButtonBar() {
        this._createPB = new JButton(CREATE);
        this._deletePB = new JButton(DELETE);
        JPanel jPanel = PassivePane.createHorizontalPanel(null);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(this.getHelpID());
        cSHelpButtonPane.addLeft(this._createPB);
        cSHelpButtonPane.addLeft(this._deletePB);
        jPanel.add(cSHelpButtonPane);
        if (this.isUserAuthorized()) {
            this._createPB.addActionListener(this);
            this._deletePB.addActionListener(this);
        }
        this.adjustButtons();
        return jPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.table.getSelectedRow();
        this.selectedPM = n != -1 ? this._models[n] : null;
        this.getPortTableModel().refreshMyLines(this.getPorts(this.selectedPM));
        this.adjustButtons();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._createPB) {
            this.doCreate();
        } else if (object == this._deletePB) {
            this.doDelete(this.table.getSelectedRow());
        }
    }

    private PassiveTableModel getPassiveTableModel() {
        if (this._passiveTableModel == null) {
            this._passiveTableModel = new PassiveTableModel(this._models, _db, this.cm);
        }
        return this._passiveTableModel;
    }

    private PassivePortsTableModel getPortTableModel() {
        if (this._portTableModel == null) {
            this._portTableModel = new PassivePortsTableModel(this.getPorts(this.selectedPM), _db);
        }
        return this._portTableModel;
    }

    private OpticsPortModel[] getPorts(PassiveModuleModel passiveModuleModel) {
        OpticsPortModel[] opticsPortModelArray = null;
        opticsPortModelArray = passiveModuleModel != null ? passiveModuleModel.getChildrenOfType(eClass.PORT).toArray(new OpticsPortModel[0]) : null;
        return opticsPortModelArray;
    }

    private ChassisModel getChassisModel() {
        boolean bl = this.getUiModel().getNodeModel().isMultishelf();
        ChassisModel chassisModel = null;
        chassisModel = bl ? (ChassisModel)((NodeModelDelegate)this.getUiModel()).getNcChassis() : (ChassisModel)this.getUiModel();
        return chassisModel;
    }

    protected void doCreate() {
        PassiveCreationDialog.instance(this).show();
    }

    protected void doDelete(int n) {
        PassiveModuleModel passiveModuleModel;
        if (_db.on()) {
            _db.println("deleteSelectedTableEntry row: " + n);
        }
        if (n >= 0 && n < this._numModels && (passiveModuleModel = this._models[n]) != null) {
            NodeModelDelegate nodeModelDelegate = passiveModuleModel.getNodeModelDelegate();
            CardBehavior cardBehavior = nodeModelDelegate.getPlatform().getCardBehavior(nodeModelDelegate, _db);
            if (nodeModelDelegate.getNodeModel().isVersionUpStateEnabled()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_NODE_UPGRADING_EXCEPTION);
            } else {
                cardBehavior.deleteCard((Component)((Object)this), passiveModuleModel);
            }
        }
    }

    private PassiveModuleModel[] getPassiveModuleModels() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        ArrayList arrayList = (ArrayList)nodeModelDelegate.getEntityTableModel().getModuleEntities();
        ArrayList<PassiveModuleModel> arrayList2 = new ArrayList<PassiveModuleModel>();
        for (EntityModel entityModel : arrayList) {
            if (!(entityModel instanceof PassiveModuleModel)) continue;
            arrayList2.add((PassiveModuleModel)entityModel);
        }
        return arrayList2.toArray(new PassiveModuleModel[0]);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.table.clearSelection();
        this.adjustButtons();
        this._models = this.getPassiveModuleModels();
        this._numModels = this._models.length;
        this.selectedPM = null;
        this.getPassiveTableModel().refreshMyLines(this._models);
        this.getPortTableModel().refreshMyLines(this.getPorts(this.selectedPM));
    }

    private void adjustButtons() {
        int n = this.table.getSelectedRow();
        if (n != -1) {
            this._deletePB.setEnabled(true);
        } else {
            this._deletePB.setEnabled(false);
        }
    }

    public EntityCellRenderer getRenderer() {
        return new EntityCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                return jLabel;
            }
        };
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.PassiveCardsPane;
    }
}

