/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ChassisModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class PassiveTableModel
extends AbstractTableModel
implements Observer {
    private PassiveModuleModel[] _models;
    private SDebug _db;
    private int _numLines;
    private int _numCols;
    private ChassisModel cModel;
    private String[] _cardName;
    private String[] _cardId;
    private String[] _location;
    private String[] _desc;
    public static final int CARD_NAME_INDEX = 1;
    public static final int PASSIVE_NUM_INDEX = 0;
    public static final int LOCATION_INDEX = 2;
    public static final int DESC_INDEX = 3;
    public static final String[] _columnNames = new String[]{"Passive", "Equipment Type", "Location", "Description"};

    public PassiveTableModel(PassiveModuleModel[] passiveModuleModelArray, SDebug sDebug, ChassisModel chassisModel) {
        this._models = passiveModuleModelArray;
        this._db = sDebug;
        this.cModel = chassisModel;
        this.init();
    }

    protected void init() {
        this._numCols = _columnNames.length;
        this.cModel.addObserver(this);
        this._numLines = this._models == null ? 0 : this._models.length;
        this.addPassiveObsModels();
        this._cardName = new String[this._numLines];
        this._cardId = new String[this._numLines];
        this._location = new String[this._numLines];
        this._desc = new String[this._numLines];
    }

    public int getRowCount() {
        return this._numLines;
    }

    public int getColumnCount() {
        return this._numCols;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public String getColumnName(int n) {
        return _columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block8: {
            string = null;
            try {
                switch (n2) {
                    case 0: {
                        string = this.getCardId(n);
                        break;
                    }
                    case 1: {
                        string = this.getCardName(n);
                        break;
                    }
                    case 2: {
                        string = this.getLocation(n);
                        break;
                    }
                    case 3: {
                        string = this.getDescription(n);
                    }
                }
            }
            catch (Exception exception) {
                this._db.println("Caught Exception in getValueAt");
                if (!this._db.on()) break block8;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private String getCardName(int n) {
        if (this._cardName[n] == null) {
            this._cardName[n] = this._models[n].getEqTypeName();
        }
        return this._cardName[n];
    }

    private String getCardId(int n) {
        if (this._cardId[n] == null) {
            this._cardId[n] = Integer.toString(this._models[n].getID());
        }
        return this._cardId[n];
    }

    private String getLocation(int n) throws NoSuchInterface {
        if (this._location[n] == null) {
            this._location[n] = this._models[n].getChassisLocation();
        }
        return this._location[n];
    }

    private String getDescription(int n) throws NoSuchInterface {
        if (this._desc[n] == null) {
            this._desc[n] = this._models[n].getDescription();
        }
        return this._desc[n];
    }

    public void refreshMyLines(PassiveModuleModel[] passiveModuleModelArray) {
        this.removePassiveObsModels();
        this._models = passiveModuleModelArray;
        this._numLines = this._models == null ? 0 : this._models.length;
        this.addPassiveObsModels();
        this._cardName = new String[this._numLines];
        this._cardId = new String[this._numLines];
        this._location = new String[this._numLines];
        this._desc = new String[this._numLines];
    }

    private void removePassiveObsModels() {
        for (int i = 0; i < this._models.length; ++i) {
            this._models[i].deleteObserver(this);
        }
    }

    private void addPassiveObsModels() {
        for (int i = 0; i < this._models.length; ++i) {
            this._models[i].addObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        int n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
        block0 : switch (n) {
            case 0: {
                break;
            }
            case 1: {
                if (!(observable instanceof PassiveModuleModel)) break;
                for (int i = 0; i < this._models.length; ++i) {
                    if (this._models[i] != observable) continue;
                    this._location[i] = null;
                    this._desc[i] = null;
                    break block0;
                }
                break;
            }
            case 2: {
                break;
            }
        }
        this.fireTableDataChanged();
    }

    public void dispose() {
        this.cModel.deleteObserver(this);
    }
}

