/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.ui.shelf.PgRowObject;
import cerent.util.ComparisonUtil;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.plaf.LabelUI;
import javax.swing.table.DefaultTableCellRenderer;

public class PgColumnRenderer
extends AbstractColumnRenderer {
    public static final int TYPE = 0;
    public static final int NAME = 1;
    public static final int PROTECT = 2;
    public static final int WORKING = 3;
    public static final int BIDIR_SWITCH = 4;
    public static final int REVERTIVE = 5;
    public static final int REV_TIME = 6;
    public static final int VERIFICATION_TIME = 7;
    public static final int RECOVERY_TIME = 8;
    public static final int DETECTION_TIME = 9;
    private static final String[] columnNames = new String[]{"Type", "Name", "Protect", "Working", "Bidir Switch", "Revertive", "Rev Time (min)", "Verification Guard Time (sec)", "Recovery Guard Time (sec)", "Detection Guard Time (sec)"};
    private static final int numColumns = columnNames.length;
    private static final int[] columnWidths = new int[]{100, 190, 190, 190, 85, 60, 110, 165, 160, 160};
    private static final String CK_IMG_PATH = "/images/check_blue.gif";
    private static final Icon CHK_ICON = WindowHelper.getIcon(PgColumnRenderer.class, (String)"/images/check_blue.gif", (String)"yes");
    private DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
    private int mode;
    private static final int SINGLE_ROW_HEIGHT = 20;

    public PgColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.cellRenderer.setUI((LabelUI)new MultiLineLabelUI());
        this.cellRenderer.setForeground(null);
        this.cellRenderer.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        int n3;
        PgRowObject pgRowObject = (PgRowObject)object;
        int n4 = 2;
        Icon icon = null;
        String string = null;
        if (pgRowObject != null) {
            switch (this.mode) {
                case 0: {
                    string = pgRowObject.pType;
                    n4 = 0;
                    break;
                }
                case 1: {
                    string = pgRowObject.name;
                    break;
                }
                case 2: {
                    string = pgRowObject.protect;
                    break;
                }
                case 3: {
                    if (pgRowObject.working.length <= 0) break;
                    string = pgRowObject.working[0];
                    if (pgRowObject.working.length <= 1) break;
                    for (n3 = 1; n3 < pgRowObject.working.length; ++n3) {
                        string = string + " \n" + pgRowObject.working[n3];
                    }
                    break;
                }
                case 4: {
                    if (!pgRowObject.bidirSwitch) break;
                    icon = CHK_ICON;
                    n4 = 0;
                    break;
                }
                case 5: {
                    if (!pgRowObject.revertive) break;
                    icon = CHK_ICON;
                    n4 = 0;
                    break;
                }
                case 6: {
                    string = pgRowObject.revTime;
                    n4 = 0;
                    break;
                }
                case 7: {
                    string = pgRowObject.verificationTime;
                    n4 = 0;
                    break;
                }
                case 8: {
                    string = pgRowObject.recoveryTime;
                    n4 = 0;
                    break;
                }
                case 9: {
                    string = pgRowObject.detectionTime;
                    n4 = 0;
                }
            }
        }
        this.cellRenderer.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        this.cellRenderer.setHorizontalAlignment(n4);
        this.cellRenderer.setIcon(icon);
        if (this.mode == 3) {
            n3 = 20;
            if (pgRowObject.working.length > 0) {
                n3 = this.cellRenderer.getPreferredSize().height;
            }
            if (jTable.getRowHeight(n) != n3) {
                jTable.setRowHeight(n, n3);
            }
        }
        return this.cellRenderer;
    }

    public static ColumnRenderer[] createColumnRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            columnRendererArray[i] = new PgColumnRenderer(i, columnNames[i], columnWidths[i], true, 0);
        }
        return columnRendererArray;
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        PgRowObject pgRowObject = (PgRowObject)object;
        PgRowObject pgRowObject2 = (PgRowObject)object2;
        switch (n) {
            case 1: {
                n2 = pgRowObject.name.compareTo(pgRowObject2.name);
                break;
            }
            case 0: {
                n2 = WindowHelper.compare((int)pgRowObject.pTypeIndex, (int)pgRowObject2.pTypeIndex);
                break;
            }
            case 2: {
                n2 = pgRowObject.protect.compareTo(pgRowObject2.protect);
                break;
            }
            case 3: {
                n2 = ComparisonUtil.compare((String[])pgRowObject.working, (String[])pgRowObject2.working);
                break;
            }
            case 4: {
                n2 = WindowHelper.compare((boolean)pgRowObject.bidirSwitch, (boolean)pgRowObject2.bidirSwitch);
                break;
            }
            case 5: {
                n2 = WindowHelper.compare((boolean)pgRowObject.revertive, (boolean)pgRowObject2.revertive);
                break;
            }
            case 6: {
                n2 = WindowHelper.compare((int)pgRowObject.revTimeSec, (int)pgRowObject2.revTimeSec);
                break;
            }
            case 8: {
                n2 = pgRowObject.recoveryTime.compareTo(pgRowObject2.recoveryTime);
                break;
            }
            case 7: {
                n2 = pgRowObject.verificationTime.compareTo(pgRowObject2.verificationTime);
                break;
            }
            case 9: {
                n2 = pgRowObject.detectionTime.compareTo(pgRowObject2.detectionTime);
            }
        }
        return n2;
    }
}

