/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.YCableModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.shelf.PgAttrsPane;
import cerent.util.SDebug;
import cerent.util.gui.WindowHelper;

class PgRowObject
implements Comparable {
    Model model;
    String name;
    String protect;
    String[] working = new String[0];
    boolean bidirSwitch;
    boolean revertive;
    String revTime;
    int revTimeSec;
    String verificationTime = "";
    String recoveryTime = "";
    String detectionTime = "";
    int pTypeIndex;
    String pType;
    private static EntityCellRenderer entityCellRenderer = new EntityCellRenderer();

    public PgRowObject(Model model, SDebug sDebug) {
        this.model = model;
        if (model instanceof OnePlusOneModel) {
            this.initFromOpoModel((OnePlusOneModel)model, sDebug);
        } else if (model instanceof ProtectionGroupModel) {
            this.initFromPgModel((ProtectionGroupModel)model, sDebug);
        } else if (model instanceof YCableModel) {
            this.initFromYcModel((YCableModel)model, sDebug);
        }
        this.pType = PgRowObject.getProtType(this.pTypeIndex);
    }

    private void initFromOpoModel(OnePlusOneModel onePlusOneModel, SDebug sDebug) {
        block12: {
            block11: {
                EntityModel entityModel;
                block10: {
                    this.name = onePlusOneModel.getName();
                    try {
                        entityModel = (EntityModel)onePlusOneModel.getProtectEntityModel();
                        this.protect = entityCellRenderer.getString(entityModel, "slot ");
                        eOnePlusOneType eOnePlusOneType2 = onePlusOneModel.getOnePlusOneType();
                        if (eOnePlusOneType2 == eOnePlusOneType.ONEPLUSONE_STANDARD) {
                            this.pTypeIndex = 2;
                        } else {
                            this.pTypeIndex = 3;
                            this.verificationTime = PgAttrsPane.vgTimerStrings[onePlusOneModel.getVerificationGuardTimer().value()];
                            this.recoveryTime = PgAttrsPane.rgTimerStrings[onePlusOneModel.getRecoveryGuardTimer().value()];
                            this.detectionTime = PgAttrsPane.dgTimerStrings[onePlusOneModel.getDetectionGuardTimer().value()];
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!sDebug.on()) break block10;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                try {
                    entityModel = (EntityModel)onePlusOneModel.getMainEntityModel();
                    this.working = new String[1];
                    this.working[0] = entityCellRenderer.getString(entityModel, "slot ");
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (sDebug.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!sDebug.on()) break block11;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            try {
                this.bidirSwitch = onePlusOneModel.isBidirectional();
                this.initRevertiveBehavior(onePlusOneModel.getReversion());
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!sDebug.on()) break block12;
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    private void initFromPgModel(ProtectionGroupModel protectionGroupModel, SDebug sDebug) {
        this.name = protectionGroupModel.getName();
        switch (protectionGroupModel.getProtectType().value()) {
            case 1: {
                this.pTypeIndex = 0;
                break;
            }
            default: {
                this.pTypeIndex = 1;
            }
        }
        ModuleModel moduleModel = (ModuleModel)protectionGroupModel.getProtectModuleModel();
        if (moduleModel != null) {
            this.protect = entityCellRenderer.getString(moduleModel, "slot ");
            ModuleModel[] moduleModelArray = (ModuleModel[])protectionGroupModel.getMainModuleModels();
            if (sDebug.on()) {
                sDebug.println("initFromPgModel: found " + moduleModelArray.length + " main modules");
            }
            this.working = new String[moduleModelArray.length];
            for (int i = 0; i < this.working.length; ++i) {
                this.working[i] = entityCellRenderer.getString(moduleModelArray[i], "slot ");
            }
            this.initRevertiveBehavior(protectionGroupModel.getReversion());
        }
    }

    private void initFromYcModel(YCableModel yCableModel, SDebug sDebug) {
        block14: {
            block13: {
                EntityModel entityModel;
                String string;
                block12: {
                    string = "slot ";
                    this.name = yCableModel.getName();
                    if (yCableModel.getType() == 4) {
                        this.pTypeIndex = 4;
                    } else if (yCableModel.getType() == 5) {
                        this.pTypeIndex = 5;
                    } else {
                        this.pTypeIndex = 6;
                        string = "shelf ";
                    }
                    try {
                        entityModel = (EntityModel)yCableModel.getProtectEntityModel();
                        this.protect = entityCellRenderer.getString(entityModel, string);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!sDebug.on()) break block12;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                try {
                    entityModel = (EntityModel)yCableModel.getMainEntityModel();
                    this.working = new String[1];
                    this.working[0] = entityCellRenderer.getString(entityModel, string);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (sDebug.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!sDebug.on()) break block13;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            try {
                this.bidirSwitch = yCableModel.isBidirectional();
                this.initRevertiveBehavior(yCableModel.getReversion());
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!sDebug.on()) break block14;
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    private void initRevertiveBehavior(IRevertiveBehavior iRevertiveBehavior) {
        boolean bl = this.revertive = iRevertiveBehavior.getReversionMode() == 2;
        if (this.revertive || this.pTypeIndex == 3) {
            this.revTimeSec = iRevertiveBehavior.getReversionTime();
            this.revTime = RevertiveBehaviorPanel.getReversionTimeString(this.revTimeSec);
        }
    }

    protected static String getProtType(int n) {
        String string = n >= 0 && n < PgAttrsPane.protTypeStrings.length ? PgAttrsPane.protTypeStrings[n] : "";
        int n2 = string.indexOf(" (");
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public int compareTo(Object object) {
        PgRowObject pgRowObject = (PgRowObject)object;
        int n = WindowHelper.compare((int)this.pTypeIndex, (int)pgRowObject.pTypeIndex);
        if (n == 0) {
            n = this.name.compareTo(pgRowObject.name);
        }
        return n;
    }
}

