/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AdminState;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ServiceState;
import cerent.cms.ui.shelf.ShelfInventoryPane;
import cerent.cms.ui.shelf.ShelfInventoryRowObject;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class ShelfInventoryColumnRenderer
extends AbstractColumnRenderer {
    public static final int LOCATION = 0;
    public static final int PROV_TYPE = 1;
    public static final int ADMIN_STATE = 2;
    public static final int SERVICE_STATE = 3;
    public static final int ACTUAL_TYPE = 4;
    public static final int HW_PART_NUM = 5;
    public static final int HW_REVISION = 6;
    public static final int SERIAL_NUM = 7;
    public static final int CLEI_CODE = 8;
    public static final int USER_CODE = 9;
    public static final int FW_REVISION = 10;
    public static final int PID = 11;
    public static final int VID = 12;
    public static final String[] columnNames = new String[]{"Location", "Eqpt Type", "Admin State", "Service State", "Actual Eqpt Type", "HW Part #", "HW Rev", "Serial #", "CLEI Code", "User Code", "Bootrom Rev", "Product ID", "Version ID"};
    private static final int numColumns = columnNames.length;
    private static final int[] columnWidths = new int[]{75, 100, 100, 100, 100, 75, 50, 75, 65, 70, 125, 75, 75};
    private JLabel cellEditor;
    private int mode;
    private static final EmptyBorder emptyBorder = new EmptyBorder(0, 5, 0, 2);
    public static final String COL_USER_CODE = "User Code";
    private static final SDebug db = new SDebug((KDebug)ShelfInventoryPane.db, "ShelfInventoryColumnRenderer");

    public ShelfInventoryColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.cellEditor = new JLabel();
        this.cellEditor.setOpaque(true);
        this.cellEditor.setBorder(emptyBorder);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        ShelfInventoryRowObject shelfInventoryRowObject = (ShelfInventoryRowObject)object;
        if (shelfInventoryRowObject == null) {
            this.cellEditor.setText("<null info>");
            return this.cellEditor;
        }
        this.setRowColor(jTable, bl, shelfInventoryRowObject);
        String string = "Unknown";
        switch (this.mode) {
            case 0: {
                string = shelfInventoryRowObject.location;
                break;
            }
            case 1: {
                string = shelfInventoryRowObject.eqType;
                break;
            }
            case 2: {
                if (this.displayStateNotApplicable(shelfInventoryRowObject)) {
                    string = "";
                    break;
                }
                string = shelfInventoryRowObject.getAdminStateString();
                break;
            }
            case 3: {
                if (this.displayStateNotApplicable(shelfInventoryRowObject)) {
                    string = "";
                    break;
                }
                string = shelfInventoryRowObject.getServiceStateString();
                break;
            }
            case 4: {
                string = shelfInventoryRowObject.mfgData.name;
                break;
            }
            case 5: {
                string = shelfInventoryRowObject.mfgData.partNumber;
                break;
            }
            case 6: {
                string = shelfInventoryRowObject.mfgData.revision;
                break;
            }
            case 7: {
                string = shelfInventoryRowObject.mfgData.serialNumber;
                break;
            }
            case 8: {
                string = shelfInventoryRowObject.mfgData.cleiCode;
                break;
            }
            case 9: {
                string = shelfInventoryRowObject.mfgData.userCode;
                break;
            }
            case 10: {
                string = shelfInventoryRowObject.mfgData.firmwareVersion;
                break;
            }
            case 11: {
                string = shelfInventoryRowObject.mfgData.productId;
                break;
            }
            case 12: {
                string = shelfInventoryRowObject.mfgData.versionId;
            }
        }
        this.cellEditor.setText(string);
        return this.cellEditor;
    }

    private boolean displayStateNotApplicable(ShelfInventoryRowObject shelfInventoryRowObject) {
        eEqType eEqType2 = shelfInventoryRowObject.entity.getEqTypeEnum();
        return AdminState.notApplicable(eEqType2);
    }

    public static ColumnRenderer[] createColumnRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            columnRendererArray[i] = new ShelfInventoryColumnRenderer(i, columnNames[i], columnWidths[i], true, i == 0 ? 0 : 2);
        }
        return columnRendererArray;
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        ShelfInventoryRowObject shelfInventoryRowObject = (ShelfInventoryRowObject)object;
        ShelfInventoryRowObject shelfInventoryRowObject2 = (ShelfInventoryRowObject)object2;
        switch (n) {
            case 0: {
                n2 = ShelfInventoryColumnRenderer.compareLocation(shelfInventoryRowObject.location, shelfInventoryRowObject2.location);
                break;
            }
            case 2: {
                n2 = shelfInventoryRowObject.getAdminStateString().compareTo(shelfInventoryRowObject2.getAdminStateString());
                break;
            }
            case 3: {
                n2 = shelfInventoryRowObject.getServiceStateString().compareTo(shelfInventoryRowObject2.getServiceStateString());
                break;
            }
            case 1: {
                n2 = shelfInventoryRowObject.eqType.compareTo(shelfInventoryRowObject2.eqType);
                break;
            }
            case 4: {
                n2 = shelfInventoryRowObject.mfgData.name.compareTo(shelfInventoryRowObject2.mfgData.name);
                break;
            }
            case 5: {
                n2 = shelfInventoryRowObject.mfgData.partNumber.compareTo(shelfInventoryRowObject2.mfgData.partNumber);
                break;
            }
            case 6: {
                n2 = shelfInventoryRowObject.mfgData.revision.compareTo(shelfInventoryRowObject2.mfgData.revision);
                break;
            }
            case 7: {
                n2 = shelfInventoryRowObject.mfgData.serialNumber.compareTo(shelfInventoryRowObject2.mfgData.serialNumber);
                break;
            }
            case 8: {
                n2 = shelfInventoryRowObject.mfgData.cleiCode.compareTo(shelfInventoryRowObject2.mfgData.cleiCode);
                break;
            }
            case 9: {
                n2 = shelfInventoryRowObject.mfgData.userCode.compareTo(shelfInventoryRowObject2.mfgData.userCode);
                break;
            }
            case 10: {
                n2 = shelfInventoryRowObject.mfgData.firmwareVersion.compareTo(shelfInventoryRowObject2.mfgData.firmwareVersion);
                break;
            }
            case 11: {
                n2 = shelfInventoryRowObject.mfgData.productId.compareTo(shelfInventoryRowObject2.mfgData.productId);
                break;
            }
            case 12: {
                n2 = shelfInventoryRowObject.mfgData.versionId.compareTo(shelfInventoryRowObject2.mfgData.versionId);
            }
        }
        return n2;
    }

    public static int compareLocation(String string, String string2) {
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            int n2 = stringTokenizer.countTokens();
            Integer[] integerArray = new Integer[n2];
            for (int i = 0; i < n2; ++i) {
                integerArray[i] = Integer.valueOf(stringTokenizer.nextToken());
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
            n2 = stringTokenizer2.countTokens();
            Integer[] integerArray2 = new Integer[n2];
            for (n = 0; n < n2; ++n) {
                integerArray2[n] = Integer.valueOf(stringTokenizer2.nextToken());
            }
            n = integerArray.length < integerArray2.length ? integerArray.length : integerArray2.length;
            for (int i = 0; i < n; ++i) {
                if (integerArray[i].compareTo(integerArray2[i]) == 0) continue;
                return integerArray[i].compareTo(integerArray2[i]);
            }
            return integerArray.length < integerArray2.length ? -1 : (integerArray.length == integerArray2.length ? 0 : 1);
        }
        catch (NumberFormatException numberFormatException) {
            return string.compareTo(string2);
        }
    }

    private void setRowColor(JTable jTable, boolean bl, ShelfInventoryRowObject shelfInventoryRowObject) {
        ServiceState serviceState;
        eEqState eEqState2;
        boolean bl2;
        boolean bl3;
        block17: {
            block16: {
                bl3 = false;
                bl2 = false;
                eEqState2 = null;
                try {
                    if (shelfInventoryRowObject.entity.getParent() == shelfInventoryRowObject.entity.getChassis()) {
                        eEqState2 = ((MfgEntityModel)((Object)shelfInventoryRowObject.entity.getChassis())).getState();
                    }
                }
                catch (Exception exception) {
                    db.println("Caught exception in setRowColor!");
                    if (!db.on()) break block16;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (eEqState2 == null) {
                try {
                    eEqState2 = shelfInventoryRowObject.entity.getState();
                }
                catch (Exception exception) {
                    db.println("Caught exception in setRowColor!");
                    if (!db.on()) break block17;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (eEqState2 != null) {
            bl3 = eEqState2.value() == 0 || eEqState2.value() == 1;
            bl2 = eEqState2.value() == 6;
        }
        boolean bl4 = false;
        if (shelfInventoryRowObject.entity.getGenericClass() == 6 && (serviceState = (ServiceState)shelfInventoryRowObject.entity.getServiceSt()).isFormOfMT()) {
            bl4 = true;
        }
        if (!bl) {
            if (bl4) {
                this.cellEditor.setForeground(ElementDefaults.PRE_PROVISION_FG);
                this.cellEditor.setBackground(ElementDefaults.OOS_MT_COLOR);
            } else if (bl3) {
                this.cellEditor.setForeground(ElementDefaults.PRE_PROVISION_FG);
                this.cellEditor.setBackground(ElementDefaults.PRE_PROVISION_BG);
            } else if (bl2) {
                this.cellEditor.setForeground(ElementDefaults.DELETED_FG);
                this.cellEditor.setBackground(ElementDefaults.DELETED_BG);
            } else {
                this.cellEditor.setForeground(jTable.getForeground());
                this.cellEditor.setBackground(jTable.getBackground());
            }
        } else {
            this.cellEditor.setForeground(ElementDefaults.SELECTION_FG);
            this.cellEditor.setBackground(ElementDefaults.SELECTION_BG);
        }
    }

    private static Integer getInteger(String string) {
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new Integer(0);
        }
    }
}

