/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IStringTag;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.util.AnnotatedException;
import cerent.util.BlockingModeController;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.List;
import java.util.Observable;

public class ShelfProvAlarmsTableModel
extends AbstractProvTableModel
implements BlockingModeController {
    protected static final int CARDNUMBER_INDEX = 0;
    protected static final int CARDTYPE_INDEX = 1;
    protected static final int PROFILE_INDEX = 2;
    protected static final int SUPPRESS_INDEX = 3;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    private static SDebug db = new SDebug("ShelfProvAlarmsTableModel");
    private String[] availableProfileNames;
    private IChassisModel model;
    protected List entities;
    private int[] portsOverridden;
    private String[] profileNames;
    private String shelfProfileName;
    private Boolean[] suppressFlags;
    private Boolean shelfSuppressFlag;
    private String[] modulePositions;
    private boolean shelfProfileDirty;
    private boolean is600;

    public ShelfProvAlarmsTableModel(boolean bl, IChassisModel iChassisModel) {
        super(new PluggableModel[0], true, "");
        if (db.on()) {
            db.println("<init>");
        }
        this.shelfProfileDirty = false;
        this.columnNames = new String[]{"Location", "Eqpt Type", "Profile", "Suppress Alarms"};
        this.model = iChassisModel;
        this.is600 = this.model.getPlatform().is600();
    }

    protected void init() {
        this.initEntities();
        this.observableManager.setBlockingModeController((BlockingModeController)this);
    }

    protected void initEntities() {
        if (ShelfProvAlarmsTableModel.db.on) {
            db.println("Refresh from Node...");
        }
        this.getProfiles();
        this.observableManager.setObservable(null);
        this.observableManager.addObservable((Observable)this.model.getAlarmModel());
        this.observableManager.addObservable((Observable)((Object)this.model));
        this.observableManager.addObservable(this.model.getProvAlarmObservables());
        this.entities = this.model.isMultishelf() ? this.model.getCardsProvAlarmEntities() : this.model.getProvAlarmEntities();
        this.initFields();
    }

    protected void initFields() {
        this.numLines = this.entities.size();
        this.profileNames = new String[this.numLines];
        this.suppressFlags = new Boolean[this.numLines];
        this.rowDirty = new boolean[this.numLines];
        this.portsOverridden = new int[this.numLines];
        this.updateOverridingChildren(false);
        this.modulePositions = new String[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.modulePositions[i] = ((MfgEntityModel)this.entities.get(i)).getLocation();
        }
    }

    protected String getEqTypeStringFor(int n) {
        return ((EntityModel)this.entities.get(n)).getEqTypeName();
    }

    public String[] getProfileNames() {
        return this.availableProfileNames;
    }

    public String getShelfProfileName() {
        return this.shelfProfileName;
    }

    public Boolean getShelfSuppressFlag() {
        return this.shelfSuppressFlag;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 3: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(n);
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            switch (n2) {
                case 2: {
                    String string = (String)object;
                    if (this.profileNames[n].equals(string)) {
                        return;
                    }
                    this.profileNames[n] = string;
                    break;
                }
                case 3: {
                    Boolean bl = (Boolean)object;
                    if (this.suppressFlags[n].equals(bl)) {
                        return;
                    }
                    this.suppressFlags[n] = bl;
                    break;
                }
                default: {
                    return;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized((EntityModel)this.entities.get(n), SecurityLevel.PROVISIONING) && (n2 == 2 || n2 == 3)) {
                    EntityModel entityModel = (EntityModel)this.entities.get(n);
                    return entityModel.getEqType() != 125;
                }
            }
            catch (Exception exception) {
                db.finer("Exception in isCellEditable() " + exception);
            }
        }
        return bl;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                String string = this.modulePositions[n];
                if (this.modulePositions[n].equals("Chassis")) {
                    string = "Backplane";
                }
                return string;
            }
            case 1: {
                String string = this.getEqTypeStringFor(n);
                if (this.is600) {
                    if (string.startsWith("BACKPLANE_")) {
                        return "All non-card objects";
                    }
                    return string;
                }
                if (this.modulePositions[n].equals("Chassis")) {
                    return "All non-card objects";
                }
                return string;
            }
            case 2: {
                EntityModel entityModel = (EntityModel)this.entities.get(n);
                if (entityModel.getEqType() == 125) {
                    return "N/A";
                }
                return this.getAlarmProfileName(n);
            }
            case 3: {
                return this.getSuppressAlarm(n);
            }
        }
        return "ERROR: INDEX OF " + n2;
    }

    public int getNumOverriddenPorts(int n) {
        if (n > -1 && n < this.getRowCount()) {
            return this.portsOverridden[n];
        }
        return -1;
    }

    public void refreshFromModel(int n) throws Exception {
        if (n == -1 || n == 2) {
            if (db.on()) {
                db.println("refresh from model, mode " + n);
            }
            this.initEntities();
        }
        super.refreshFromModel(n);
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.profileNames[i] = null;
            this.suppressFlags[i] = null;
            this.rowDirty[i] = false;
        }
        this.shelfProfileDirty = false;
        this.shelfProfileName = this.model.getAlarmProfileName();
        this.shelfSuppressFlag = this.model.isMultishelf() ? this.model.getNodeModelDelegate().getNcChassis().getSuppressAlarmsFlag() : this.model.getSuppressAlarmsFlag();
        super.refreshFromModel();
    }

    public void applyToModel() throws Exception {
        if (db.on()) {
            db.println("applyToModel");
        }
        int n = 0;
        this.observableManager.setPassing(false);
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (!this.rowDirty[n]) continue;
                if (this.isCellEditable(n, 2)) {
                    ((EntityModel)this.entities.get(n)).setAlarmProfileName(this.getAlarmProfileName(n));
                }
                ((EntityModel)this.entities.get(n)).setSuppressAlarms(this.getSuppressAlarm(n));
                this.rowDirty[n] = false;
            }
            if (this.shelfProfileDirty) {
                this.model.setAlarmProfileName(this.shelfProfileName);
                if (this.shelfSuppressFlag != null) {
                    this.model.setSuppressAlarms(this.shelfSuppressFlag);
                }
                this.shelfProfileDirty = false;
            }
        }
        catch (Exception exception) {
            this.observableManager.setPassing(true);
            throw new AnnotatedException("An error occurred while applying the changes.", exception);
        }
        this.observableManager.setPassing(true);
    }

    public boolean isDirty() {
        boolean bl = false;
        for (int i = 0; i < this.rowDirty.length; ++i) {
            if (!this.rowDirty[i] && !this.shelfProfileDirty) continue;
            bl = true;
            break;
        }
        if (db.on()) {
            db.println("isDirty( ) -> " + bl);
        }
        return bl;
    }

    public void triggerShelfProfileChanged(Object object) {
        if (db.on()) {
            db.println("triggerShelfProfileChanged( " + this.shelfProfileName + " )");
        }
        this.shelfProfileName = (String)object;
        this.shelfProfileDirty = true;
        this.fireTableDataChanged();
    }

    public void triggerSuppressChanged(Boolean bl) {
        if (db.on()) {
            db.println("triggerSuppressChanged( " + bl + " )");
        }
        this.shelfSuppressFlag = bl;
        this.shelfProfileDirty = true;
        this.fireTableDataChanged();
    }

    public void updateOverridingChildren(boolean bl) {
        int n = this.availableProfileNames.length;
        for (int i = 0; i < this.numLines; ++i) {
            EntityModel entityModel = (EntityModel)this.entities.get(i);
            int n2 = 0;
            if (n != 1) {
                EntityModel[] entityModelArray = null;
                if (entityModel instanceof IChassisModel) {
                    entityModelArray = ((IChassisModel)((Object)entityModel)).getProvAlarmEntities().toArray(new EntityModel[0]);
                } else if (entityModel instanceof PluggableModel) {
                    entityModelArray = ((PluggableModel)entityModel).getAlarmablePorts();
                }
                if (entityModelArray != null) {
                    for (int j = 0; j < entityModelArray.length; ++j) {
                        String string = entityModelArray[j].getAlarmProfileName();
                        if (string.equals("None") || string.equals("Inherited")) continue;
                        ++n2;
                    }
                }
            }
            if (this.portsOverridden[i] == n2) continue;
            this.portsOverridden[i] = n2;
            if (!bl) continue;
            this.fireTableCellUpdated(i, 2);
        }
    }

    protected void getProfiles() {
        IStringTag[] iStringTagArray = this.model.getAlarmModel().getAlarmProfileList();
        this.availableProfileNames = new String[iStringTagArray.length];
        for (int i = 0; i < iStringTagArray.length; ++i) {
            this.availableProfileNames[i] = iStringTagArray[i].getFirst();
        }
    }

    public ElAttributeMaps getAttributeMap() {
        TDMTerminology tDMTerminology = this.model.getTDMTerminology();
        int n = this.model.getTdmProtocolTypeObj().getEnum();
        return ElementDefaults.getAttributeMap(n, tDMTerminology);
    }

    public void update(Observable observable, Object object) {
        block5: {
            if (db.on()) {
                db.println("Update: from = " + observable + " arg = " + object);
            }
            if (object == ModelUpdateType.CHANGED) {
                this.updateOverridingChildren(true);
            } else {
                this.initEntities();
            }
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                db.println("Caught exception in update");
                if (!db.on()) break block5;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void disposeDataSource() {
        if (this.entities != null) {
            this.entities.clear();
        }
        super.disposeDataSource();
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        int n2;
        if (ShelfProvAlarmsTableModel.db.on) {
            db.println("processBlockedEvent: src " + observable + ", event = " + object + ", previousState = " + n);
        }
        if ((n2 = this.entities.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }

    protected String getAlarmProfileName(int n) {
        if (this.profileNames[n] == null) {
            String string = ((EntityModel)this.entities.get(n)).getAlarmProfileName();
            if (string == null) {
                string = "";
            }
            this.profileNames[n] = string;
        }
        return this.profileNames[n];
    }

    protected Boolean getSuppressAlarm(int n) {
        if (this.suppressFlags[n] == null) {
            this.suppressFlags[n] = new Boolean(((EntityModel)this.entities.get(n)).getSuppressAlarms());
        }
        return this.suppressFlags[n];
    }
}

