/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IDwdmApcModel;
import cerent.cms.model.IDwdmApcModels;
import cerent.cms.model.ISideModel;
import cerent.cms.model.IpConfig;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecureIpConfig;
import cerent.cms.model.SideModels;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.ApcRenderer;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.VitalStatsPane;
import cerent.util.IObservable;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class ShelfVitalStatsPane
extends VitalStatsPane
implements Observer {
    private IChassisModel chassis;
    private NodeModelDelegate nodeM;
    private List slots;
    private HashSet<EntityModel> cards = new HashSet();
    private boolean isApcSite = false;
    private IDwdmApcModel[] apcModels;
    private SideModels sideModels = null;
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    private static final SDebug db = new SDebug("ShelfVitalStatsPane");
    private String emptySpaces = "            ";
    private static final String sideLocationStr = "Side      : ";

    public ShelfVitalStatsPane(IChassisModel iChassisModel) {
        super(iChassisModel.getShelfAlarmStore());
        this.chassis = iChassisModel;
        this.nodeM = (NodeModelDelegate)iChassisModel.getNodeModel();
        this.isApcSite = iChassisModel.getPlatform().supportsDWDM();
        if (this.isApcSite) {
            this.nodeM.getDwdmApcModels().addObserver(this);
            this.apcModels = this.nodeM.getDwdmApcModels().getAllDwdmApcModel();
            this.registerApcObserver();
        }
        if (this.nodeM.isMultishelf()) {
            EntityModel entityModel = (EntityModel)iChassisModel.getChildren().get(0);
            this.slots = entityModel.getChildren();
            for (EntityModel entityModel2 : this.slots) {
                entityModel2.addObserver(this);
            }
        } else {
            this.nodeM.addObserver(this);
        }
        if (this.nodeM.isDwdmNodeType()) {
            this.sideModels = this.nodeM.getSideModelsModel();
            this.sideModels.addObserver(this);
            this.registerSidesObserver();
        }
        this.updateTextArea();
    }

    private void registerApcObserver() {
        if (this.apcModels != null) {
            for (int i = 0; i < this.apcModels.length; ++i) {
                IDwdmApcModel iDwdmApcModel = this.apcModels[i];
                ((IObservable)iDwdmApcModel).addObserver((Observer)this);
            }
        }
    }

    private void registerSidesObserver() {
        if (this.sideModels != null) {
            ISideModel[] iSideModelArray = this.sideModels.getSides();
            for (int i = 0; i < iSideModelArray.length; ++i) {
                ((Model)iSideModelArray[i]).addObserver(this);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Received event " + object.hashCode() + " from " + observable.toString());
        }
        if (observable instanceof IDwdmApcModel || observable instanceof IDwdmApcModels) {
            if (this.apcModels != null) {
                for (int i = 0; i < this.apcModels.length; ++i) {
                    ((IObservable)this.apcModels[i]).deleteObserver((Observer)this);
                }
            }
            this.apcModels = this.nodeM.getDwdmApcModels().getAllDwdmApcModel();
            this.registerApcObserver();
        }
        if (observable instanceof SideModels) {
            this.registerSidesObserver();
        }
        if (object != ModelUpdateType.DELETED || !(observable instanceof IDwdmApcModel)) {
            this.updateTextArea();
        }
        if (this.cards.contains(observable) && object == ModelUpdateType.DELETED) {
            observable.deleteObserver(this);
            this.cards.remove(observable);
        }
    }

    private void updateTextArea() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        StringBuilder stringBuilder2 = new StringBuilder();
        String string9 = null;
        if (!this.nodeM.isMultishelf()) {
            block33: {
                block32: {
                    block31: {
                        string = this.nodeM.getName();
                        if (string == null) {
                            string = "unknown node";
                        }
                        string2 = this.getNodeIpAddr();
                        string6 = this.getIPv6Address();
                        if (this.nodeM.getPlatform().isSecureModeSupported() && this.nodeM.isSecureMode()) {
                            string3 = this.getSecureIpAddr();
                        }
                        string4 = this.nodeM.getUserName();
                        string5 = ElementDefaults.securityLevelToString(this.nodeM.getSecurityLevel());
                        try {
                            string7 = this.nodeM.getSwVersion();
                        }
                        catch (Exception exception) {
                            if (!db.isFineEnabled()) break block31;
                            db.fine("Exception received when getting node sw version");
                        }
                    }
                    try {
                        string8 = this.nodeM.getDefaultsDescription();
                    }
                    catch (Exception exception) {
                        if (!db.isFineEnabled()) break block32;
                        db.fine("Exception received when getting defaults description: " + exception);
                    }
                }
                try {
                    string9 = dateFormat.format(this.nodeM.getBootTime());
                }
                catch (Exception exception) {
                    if (!db.isFineEnabled()) break block33;
                    db.fine("Exception received when getting boot time: " + exception);
                }
            }
            if (this.isApcSite && (this.nodeM.getNodeType() == 2 || this.nodeM.getNodeType() == 1)) {
                if (this.anyApcStateValid(this.apcModels)) {
                    stringBuilder2 = this.getApcStatus(!this.nodeM.isMultishelf(), this.anyApcStateValid(this.apcModels));
                }
                stringBuilder2.append((CharSequence)this.sideLocation());
            }
            if (string2 == null) {
                string2 = "unavailable";
            }
            if (string3 == null) {
                string3 = "unavailable";
            }
            if (string4 == null) {
                string4 = "unavailable";
            }
            if (string5 == null) {
                string5 = "unavailable";
            }
            if (string7 == null) {
                string7 = "unavailable";
            }
            if (string8 == null) {
                string8 = "unavailable";
            }
            if (string9 == null) {
                string9 = "unknown";
            }
            boolean bl = false;
            if (this.nodeM != null) {
                if (this.nodeM.getPlatform().isSecureModeSupported() && this.nodeM.isSecureMode() && this.nodeM.allowIpDisplayed(false)) {
                    if (this.nodeM.allowIpDisplayed(true)) {
                        stringBuilder.append("Node Addr          : ").append(string2).append('\n');
                        if (string6 != null) {
                            stringBuilder.append("IPv6 Addr          : ").append(string6).append('\n');
                        }
                    }
                    stringBuilder.append("Backplane Node Addr: ").append(string3).append('\n');
                    bl = true;
                } else if (this.nodeM.allowIpDisplayed(true)) {
                    stringBuilder.append("Node Addr : ").append(string2).append('\n');
                    if (string6 != null) {
                        stringBuilder.append("IPv6 Addr : ").append(string6).append('\n');
                    }
                }
            }
            if (bl) {
                stringBuilder.append("Booted             : ").append(string9).append('\n').append("User               : ").append(string4).append('\n').append("Authority          : ").append(string5).append('\n').append("SW Version         : ").append(string7).append('\n').append("Defaults           : ").append(string8).append((CharSequence)stringBuilder2);
            } else {
                stringBuilder.append("Booted    : ").append(string9).append('\n').append("User      : ").append(string4).append('\n').append("Authority : ").append(string5).append('\n').append("SW Version: ").append(string7).append('\n').append("Defaults  : ").append(string8).append((CharSequence)stringBuilder2);
            }
        } else {
            string = this.nodeM.getName() + ", Shelf " + this.chassis.getShelfId();
            if (string == null) {
                string = "Unknown, Shelf " + this.chassis.getShelfId();
            }
            for (EntityModel entityModel : this.slots) {
                if (entityModel.getChildren().size() != 1) continue;
                EntityModel entityModel2 = (EntityModel)entityModel.getChildren().get(0);
                int n = entityModel.getSlot();
                stringBuilder.append("\nSlot " + (n < 10 ? " " : "") + Integer.toString(n) + ": " + entityModel2.getEqLabel());
                entityModel2.addObserver(this);
                this.cards.add(entityModel2);
            }
            if (this.anyApcStateValid(this.apcModels)) {
                stringBuilder.append(this.getApcStatus(!this.nodeM.isMultishelf(), this.anyApcStateValid(this.apcModels)).toString());
            }
            stringBuilder.append((CharSequence)this.sideLocation());
        }
        this.setTitle(string);
        this.setText(stringBuilder.toString());
    }

    private StringBuilder getApcStatus(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        if (bl2) {
            stringBuilder.append("\nAPC state : ");
            string = this.emptySpaces;
        } else {
            stringBuilder.append("\nSide      : ");
            string = this.emptySpaces + "    ";
        }
        if (this.apcModels != null) {
            int n;
            HashMap<Integer, ISideModel> hashMap = new HashMap<Integer, ISideModel>();
            ISideModel[] iSideModelArray = this.nodeM.getSideModels().getSides();
            for (n = 0; n < iSideModelArray.length; ++n) {
                hashMap.put(iSideModelArray[n].getId(), iSideModelArray[n]);
            }
            n = 1;
            for (int i = 0; i < this.apcModels.length; ++i) {
                IDwdmApcModel iDwdmApcModel = this.apcModels[i];
                try {
                    if (!bl && this.associatedSide((ISideModel)hashMap.get(iDwdmApcModel.getApcNodeSide())) == null) continue;
                    if (n != 0) {
                        stringBuilder.append("Side ");
                        n = 0;
                    } else {
                        stringBuilder.append(string).append("Side ");
                    }
                    if (bl2) {
                        int n2 = iDwdmApcModel.getApcState();
                        String string2 = ApcRenderer.getAPCStateAsString(n2);
                        stringBuilder.append(DwdmSide.getSideFromOffset(iDwdmApcModel.getApcNodeSide())).append(" - ").append(string2);
                    }
                    stringBuilder.append("\n");
                    continue;
                }
                catch (Exception exception) {
                    if (!db.isFineEnabled()) continue;
                    db.fine("Caught " + exception);
                }
            }
        }
        return stringBuilder;
    }

    private StringBuilder sideLocation() {
        int n;
        String string = "            ";
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        ISideModel[] iSideModelArray = this.nodeM.getSideModels().getSides();
        int n2 = 0;
        if (iSideModelArray.length != 0) {
            stringBuilder.append("\nSide      : ");
        }
        for (n = 0; n < iSideModelArray.length; ++n) {
            try {
                if (this.nodeM.isMultishelf() && this.associatedSide(iSideModelArray[n]) == null) continue;
                StringBuffer stringBuffer = new StringBuffer();
                PortModel portModel = (PortModel)this.nodeM.getEntityTableModel().getEntityModelByIndex(iSideModelArray[n].getLineIn());
                stringBuffer.append(DwdmSide.getSideFromOffset(iSideModelArray[n].getId()) + " In (Slot " + portModel.getSlot() + ")\n");
                portModel = (PortModel)this.nodeM.getEntityTableModel().getEntityModelByIndex(iSideModelArray[n].getLineOut());
                stringBuffer.append(string + "  Out (Slot " + portModel.getSlot() + ")\n");
                hashMap.put(n2, stringBuffer.toString());
                ++n2;
                continue;
            }
            catch (Exception exception) {
                if (!db.isFineEnabled()) continue;
                db.fine("Caught " + exception);
            }
        }
        if (hashMap.size() > 0) {
            stringBuilder.append((String)hashMap.get(0));
            for (n = 1; n < hashMap.size(); ++n) {
                stringBuilder.append("\n" + string).append((String)hashMap.get(n));
            }
        }
        return stringBuilder;
    }

    private EntityModel associatedSide(ISideModel iSideModel) {
        int n;
        block3: {
            n = 0;
            int n2 = iSideModel.getLineIn();
            PortModel portModel = null;
            try {
                portModel = (PortModel)this.nodeM.getEntityTableModel().getEntityModelByIndex(n2);
                n = portModel.getModuleModel().getIndex();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                n = 0;
                if (!db.isFineEnabled()) break block3;
                db.fine("Wrong card for provisioned Side" + (Object)((Object)abstractCmsNoSuchEntityException));
            }
        }
        for (EntityModel entityModel : this.slots) {
            EntityModel entityModel2;
            if (entityModel.getChildren().size() != 1 || (entityModel2 = (EntityModel)entityModel.getChildren().get(0)).getIndex() != n) continue;
            return entityModel2;
        }
        return null;
    }

    private String getSecureIpAddr() {
        SecureIpConfig secureIpConfig;
        String string = null;
        if (this.nodeM != null && (secureIpConfig = (SecureIpConfig)this.nodeM.getSecureIpConfig()) != null) {
            string = InetUtil.makeDottedString(secureIpConfig.getIpAddress());
        }
        return string;
    }

    private String getNodeIpAddr() {
        String string = null;
        if (this.nodeM != null) {
            IpConfig ipConfig = (IpConfig)this.nodeM.getIpConfig();
            string = InetUtil.makeDottedString(ipConfig.getIpAddress());
        }
        return string;
    }

    private String getIPv6Address() {
        IpConfig ipConfig;
        String string = null;
        if (this.nodeM != null && (ipConfig = (IpConfig)this.nodeM.getIpConfig()).getNodeMode()) {
            string = InetUtil.makeDottedString(ipConfig.getIpv6Address());
        }
        return string;
    }

    public void dispose() {
        if (this.slots != null) {
            for (EntityModel entityModel : this.slots) {
                entityModel.deleteObserver(this);
            }
            this.slots = null;
        }
        if (this.cards != null) {
            for (EntityModel entityModel : this.cards) {
                entityModel.deleteObserver(this);
            }
            this.cards = null;
        }
        if (this.nodeM != null) {
            this.nodeM.deleteObserver(this);
            this.nodeM.getSideModelsModel().deleteObserver(this);
        }
        if (this.isApcSite) {
            this.nodeM.getDwdmApcModels().deleteObserver(this);
            if (this.apcModels != null) {
                for (int i = 0; i < this.apcModels.length; ++i) {
                    ((IObservable)this.apcModels[i]).deleteObserver((Observer)this);
                }
            }
        }
        if (this.sideModels != null) {
            this.sideModels.deleteObserver(this);
            ISideModel[] iSideModelArray = this.sideModels.getSides();
            for (int i = 0; i < iSideModelArray.length; ++i) {
                ((Model)iSideModelArray[i]).deleteObserver(this);
            }
        }
        super.dispose();
    }

    private boolean anyApcStateValid(IDwdmApcModel[] iDwdmApcModelArray) {
        boolean bl = false;
        for (IDwdmApcModel iDwdmApcModel : iDwdmApcModelArray) {
            try {
                if (iDwdmApcModel.getApcState() == 0) continue;
                bl = true;
                break;
            }
            catch (WrongNodeSide wrongNodeSide) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)wrongNodeSide);
            }
        }
        return bl;
    }
}

