/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ISecurityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.Operation;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.CompleteDBInfoDialog;
import cerent.cms.ui.shelf.DbInfoDialog;
import cerent.util.BoolHolder;
import cerent.util.DatabaseHeader;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.PersistentFileChooserDialog;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SmpDBPane
extends AbstractPane
implements ActionListener,
IJobListener {
    protected static final String BACKUP_TT = "Copies database to a file from the ";
    protected static final String RESTORE_TT = "Copies database from a file to the ";
    protected static final String BACKUP_DB = "Backup Database";
    protected static final String RESTORE_DB = "Restore Database";
    protected static final String BACKUP_MSG = "Select file for saving backup";
    protected static final String RESTORE_MSG = "Select file to restore from";
    protected static final String BACKUP_RESTORE_PROP = "ctc";
    protected static final String BACKUP_RESTORE_PATH = "backup-restore.file.path";
    protected static String restore_Message1 = "Restoring a database from another node or\nfrom an earlier backup might result in a loss\nof traffic.\n\nIs it OK to continue?";
    private JPanel row;
    protected JButton restoreButton;
    protected JButton backupButton;
    private File dbFile = null;
    private JobProgressDialog progressDlg;
    protected NodeModelDelegate nodeModel;
    protected ISecurityModel secModel;
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpDBPane");

    public SmpDBPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.nodeModel = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.secModel = this.nodeModel.getSecurityModel();
        JPanel jPanel = SmpDBPane.createVerticalPanel(null);
        this.setLayout(new BorderLayout());
        this.add(jPanel, "North");
        this.row = SmpDBPane.createHorizontalPanel("Database");
        this.backupButton = new JButton("Backup...");
        this.restoreButton = new JButton("Restore...");
        if (this.isUserAuthorized(SecurityLevel.MAINTENANCE)) {
            this.backupButton.addActionListener(this);
        } else {
            this.backupButton.setEnabled(false);
        }
        this.restoreButton.addActionListener(this);
        this.enableOperationButton(this.restoreButton, Operation.RESTORE_DB);
        String string = this.nodeModel.getPlatform().getControlCardName();
        this.backupButton.setToolTipText(BACKUP_TT + string);
        this.restoreButton.setToolTipText(RESTORE_TT + string);
        this.row.add(this.backupButton);
        this.row.add(Box.createHorizontalStrut(20));
        this.row.add(this.restoreButton);
        this.row.setAlignmentX(0.5f);
        jPanel.add(this.row);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpDBPane);
        this.add(Box.createVerticalGlue(), "Center");
        this.add(cSHelpButtonPane, "South");
        if (this.secModel != null) {
            this.secModel.addObserver((Observer)((Object)this));
        }
        if (db.on()) {
            db.println("init: finish");
        }
    }

    protected void enableOperationButton(JComponent jComponent, Operation operation) {
        if (this.nodeModel.isInited() && this.secModel != null) {
            SecurityLevel securityLevel = this.secModel.getOperationPrivilege(operation);
            this.enableComponent(jComponent, this.nodeModel, securityLevel);
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: start");
        }
        this.requestRefresh(this, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = null;
        boolean bl = this.nodeSupportsCompleteDB();
        boolean bl2 = false;
        BoolHolder boolHolder = new BoolHolder();
        if (object == this.restoreButton) {
            this.dbFile = PersistentFileChooserDialog.getFile((Component)((Object)this), (String)RESTORE_DB, (Object)RESTORE_MSG, (byte)1, (String)BACKUP_RESTORE_PROP, (String)BACKUP_RESTORE_PATH, (int)20, (boolean)bl, (BoolHolder)boolHolder);
            if (boolHolder != null) {
                bl2 = boolHolder.booleanValue();
            }
            if (this.dbFile == null) {
                return;
            }
            string = this.dbFile.getAbsolutePath();
            if (!this.dbFile.exists() || !this.dbFile.canRead()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FILE_NOT_EXIST_OR_READ_PARAM_1, (Object)string);
                return;
            }
            if (this.dbFile.length() == 0L) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FILE_SIZE_ZERO_PARAM_1, (Object)string);
                return;
            }
            if (!this.checkSwVersion(this.nodeModel.getSwVersion().substring(0, 5))) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_UNABLE_TO_RESTORE_DATABASE);
                return;
            }
            DatabaseHeader databaseHeader = new DatabaseHeader(string);
            if (databaseHeader.isCompatible()) {
                JDialog jDialog;
                if (bl2 && !((CompleteDBInfoDialog)(jDialog = new CompleteDBInfoDialog((JComponent)((Object)this)))).isOk()) {
                    return;
                }
                jDialog = new DbInfoDialog((JComponent)((Object)this), this.nodeModel, databaseHeader);
                if (!((DbInfoDialog)jDialog).isOk()) {
                    return;
                }
            } else if (!this.showRestoreDialog()) {
                return;
            }
            int n = bl2 ? 8 : 2;
            this.restoreDB(this.nodeModel, string, n);
        } else if (object == this.backupButton) {
            PersistentFileChooserDialog.setNodeName((String)this.nodeModel.getName());
            this.dbFile = PersistentFileChooserDialog.getFile((Component)((Object)this), (String)BACKUP_DB, (Object)BACKUP_MSG, (byte)6, (String)BACKUP_RESTORE_PROP, (String)BACKUP_RESTORE_PATH, (int)20);
            if (this.dbFile == null) {
                return;
            }
            string = this.dbFile.getAbsolutePath();
            this.backupDB(this.nodeModel, string);
        }
    }

    public void enteringPage() {
        if (this.backupButton == null && this.restoreButton == null) {
            this.init();
        }
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() {
        this.enableOperationButton(this.restoreButton, Operation.RESTORE_DB);
    }

    public void destroy() {
        if (this.restoreButton != null) {
            this.restoreButton.removeActionListener(this);
        }
        if (this.backupButton != null) {
            this.backupButton.removeActionListener(this);
        }
        if (this.secModel != null) {
            this.secModel.deleteObserver((Observer)((Object)this));
        }
        super.destroy();
    }

    private void restoreDB(NodeModelDelegate nodeModelDelegate, String string, int n) {
        IJobControl iJobControl;
        this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), RESTORE_DB, "restoring...");
        JobController jobController = JobControllerFactory.createJC((int)1);
        try {
            iJobControl = nodeModelDelegate.createDataTransferJob(string, n, (IJobProgressControl)this.progressDlg);
        }
        catch (Exception exception) {
            this.progressDlg.dispose();
            this.progressDlg = null;
            JobControllerFactory.disposeJC((JobController)jobController);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DB_RESTORE_EXCEPTION_PARAM_1, (Object)exception.getClass().getName());
            return;
        }
        this.progressDlg.setJob(iJobControl);
        this.progressDlg.setProgressText(nodeModelDelegate.getName() + ": Restoring ...");
        jobController.submitJob(new JobGroup(iJobControl, (IJobListener)this, (Object)jobController));
    }

    private void backupDB(NodeModelDelegate nodeModelDelegate, String string) {
        this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), BACKUP_DB, "backing up...", false, true);
        JobController jobController = JobControllerFactory.createJC((int)1);
        IJobControl iJobControl = nodeModelDelegate.createDataTransferJob(string, 1, (IJobProgressControl)this.progressDlg);
        this.progressDlg.setJob(iJobControl);
        this.progressDlg.setProgressText(nodeModelDelegate.getName() + ": Backing up ...");
        jobController.submitJob(new JobGroup(iJobControl, (IJobListener)this, (Object)jobController));
    }

    public boolean showRestoreDialog() {
        return CerentDialog.yesNoDialog((Component)((Object)this), (String)restore_Message1, (String)"DB Restore");
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, final JobStatus jobStatus, final Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SmpDBPane.this.finishJob(jobStatus, (JobController)object);
            }
        });
    }

    private void finishJob(JobStatus jobStatus, JobController jobController) {
        String string = this.progressDlg.getTitle();
        boolean bl = string.equals(BACKUP_DB);
        if (db.on()) {
            db.println("jobFinished; title was " + string);
        }
        this.progressDlg.dispose();
        this.progressDlg = null;
        if (jobStatus.value() == 3) {
            CerentDialog.infoDialog((Component)((Object)this), (String)(string + " aborted"), (String)string);
            if (db.on()) {
                db.println("JobStatus.ABORT");
            }
        } else if (jobStatus.value() == 2) {
            Exception exception = (Exception)jobStatus.getResult();
            if (db.on()) {
                db.println("JobStatus.FAILED");
                SDebug.printStackTrace((Throwable)exception);
            }
            if (exception != null) {
                if (bl) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DB_BACKUP_FAILED_PARAM_1, (Object)exception.getMessage());
                } else {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_DB_RESTORE_FAILED_PARAM_1, (Object)exception.getMessage());
                }
            }
        } else if (jobStatus.value() == 4 && string.equals(BACKUP_DB)) {
            if (db.on()) {
                db.println("JobStatus.COMPLETE FOR BACKUP");
            }
            CerentDialog.infoDialog((Component)((Object)this), (String)(string + " complete"), (String)string);
        }
        if (jobController != null && jobController.isIdle()) {
            JobControllerFactory.disposeJC((JobController)jobController);
        }
    }

    private boolean nodeSupportsCompleteDB() {
        return this.nodeModel.getPlatform().is454() || this.nodeModel.getPlatform().is310ma() || this.nodeModel.getPlatform().is310maSDH() || this.nodeModel.getPlatform().is455();
    }

    private boolean checkSwVersion(String string) {
        if (string.length() != 5 || string.charAt(2) != '.') {
            return false;
        }
        try {
            Integer.parseInt(string.substring(0, 2));
            Integer.parseInt(string.substring(3));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

