/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AlreadyLocked;
import cerent.cms.model.Busy;
import cerent.cms.model.ChassisModel;
import cerent.cms.model.DuplexLocked;
import cerent.cms.model.DuplexUnlocked;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ProtectActive;
import cerent.cms.model.ProtectFailedOrMissing;
import cerent.cms.model.ProtectLocked;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WorkingFailedOrMissing;
import cerent.cms.model.WorkingLocked;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractSmpDiagnosticPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.omg.CORBA.BAD_OPERATION;

public class SmpDiagnosticPane
extends AbstractSmpDiagnosticPane {
    private static final String LAMPTEST_TT = "Perform Lamp Test";
    private JButton lampTestButton;
    private boolean inited = false;

    public SmpDiagnosticPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected void init() {
        JPanel jPanel;
        if (db.on()) {
            db.println("init: start");
        }
        if (this.inited) {
            return;
        }
        this.inited = true;
        super.init();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = SmpDiagnosticPane.createVerticalPanel(null);
        this.setLayout(new BorderLayout());
        jPanel2.add(jPanel3);
        this.add(jPanel2, "North");
        if (this.isDiagnosticAvailable()) {
            jPanel = new JPanel();
            ((FlowLayout)jPanel.getLayout()).setHgap(10);
            jPanel3.add(Box.createVerticalStrut(10));
            jPanel3.add(jPanel);
            jPanel.setBorder(BorderFactory.createTitledBorder("Controller"));
            this.diagnosticButton = new JButton("Retrieve Tech Support Logs...");
            this.diagnosticButton.addActionListener(this);
            this.diagnosticButton.setDefaultCapable(false);
            this.diagnosticButton.setToolTipText("Request a diagnostic file from the " + this.nodeModel.getPlatform().getControlCardName());
            this.diagnosticButton.setAlignmentX(0.5f);
            jPanel.add(this.diagnosticButton);
        }
        if (this.isLampTestAvailable()) {
            jPanel = new JPanel();
            jPanel3.add(Box.createVerticalStrut(10));
            jPanel3.add(jPanel);
            jPanel.setBorder(BorderFactory.createTitledBorder("Lamp Test"));
            this.lampTestButton = new JButton("Lamp Test");
            this.lampTestButton.addActionListener(this);
            this.lampTestButton.setDefaultCapable(false);
            this.lampTestButton.setToolTipText(LAMPTEST_TT);
            this.lampTestButton.setAlignmentX(0.5f);
            jPanel.add(this.lampTestButton);
        }
        if (this.isDiagnosticAvailable()) {
            this.enableComponent(this.diagnosticButton);
        }
        if (this.isLampTestAvailable()) {
            this.enableComponent(this.lampTestButton, this.uiModel, SecurityLevel.MAINTENANCE);
        }
        jPanel = new CSHelpButtonPane(CSHelpConst.SmpDiagnosticPane);
        this.add(Box.createVerticalGlue(), "Center");
        this.add(jPanel, "South");
        if (db.on()) {
            db.println("init: finish");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.lampTestButton) {
            boolean bl = false;
            if (!this.nodeModel.isMultishelf()) {
                try {
                    this.nodeModel.getEntityTableModel().doLampTest();
                    bl = true;
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_LAMP_TEST_NOT_SUPPORTED);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)abstractCmsIOException.getMessage());
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)exception.getMessage());
                }
            } else {
                ChassisModel chassisModel = (ChassisModel)this.getUiModel();
                try {
                    chassisModel.testChassisLamp();
                    bl = true;
                }
                catch (ProvisionError provisionError) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_LAMP_TEST_NOT_SUPPORTED);
                }
                catch (WorkingFailedOrMissing workingFailedOrMissing) {
                    SDebug.printStackTrace((Throwable)workingFailedOrMissing);
                }
                catch (AlreadyLocked alreadyLocked) {
                    SDebug.printStackTrace((Throwable)alreadyLocked);
                }
                catch (ProtectLocked protectLocked) {
                    SDebug.printStackTrace((Throwable)protectLocked);
                }
                catch (WorkingLocked workingLocked) {
                    SDebug.printStackTrace((Throwable)workingLocked);
                }
                catch (ProtectActive protectActive) {
                    SDebug.printStackTrace((Throwable)protectActive);
                }
                catch (InvalidState invalidState) {
                    SDebug.printStackTrace((Throwable)invalidState);
                }
                catch (DuplexLocked duplexLocked) {
                    SDebug.printStackTrace((Throwable)duplexLocked);
                }
                catch (DuplexUnlocked duplexUnlocked) {
                    SDebug.printStackTrace((Throwable)duplexUnlocked);
                }
                catch (ProtectFailedOrMissing protectFailedOrMissing) {
                    SDebug.printStackTrace((Throwable)protectFailedOrMissing);
                }
                catch (Busy busy) {
                    SDebug.printStackTrace((Throwable)busy);
                }
            }
            if (bl) {
                CerentDialog.infoDialog((Component)((Object)this), (String)"The lamp test has been run.\n All module LEDs should illuminate for several seconds then revert to pre-test state.", (String)"Lamp Test Run");
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void enteringPage() {
        this.init();
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        if (this.isDiagnosticAvailable()) {
            this.diagnosticButton.setSelected(false);
        } else if (this.isLampTestAvailable()) {
            this.lampTestButton.setSelected(false);
        }
    }

    private boolean isDiagnosticAvailable() {
        if (this.getUiModel() instanceof IChassisModel && this.nodeModel.isMultishelf()) {
            return false;
        }
        if (this.nodeModel.isMultishelf()) {
            return true;
        }
        return true;
    }

    private boolean isLampTestAvailable() {
        if (this.getUiModel() instanceof IChassisModel && this.nodeModel.isMultishelf()) {
            return true;
        }
        return !this.nodeModel.isMultishelf();
    }
}

