/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Feature;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.UnimplementedPane;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.MaintSpTreePane;
import cerent.cms.ui.shelf.SmpEtherStatsPane;
import cerent.cms.ui.shelf.SmpMacAddrPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;

public class SmpEtherPane
extends AbstractPane
implements ITabName {
    private static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpEtherPane");

    public SmpEtherPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.subTabs = new SubTabbedView(tabbedView.getUiModel(), tabbedView);
        this.subTabs.setTabPlacement(1);
        this.subTabs.add((Component)this.getSpTreePane("Spanning Trees"));
        this.subTabs.add((Component)this.getSmpMacAddrPane("MAC Table"));
        if (nodeModelDelegate.provides(Feature.IDL_RMON)) {
            this.subTabs.add((Component)this.getSmpEtherStatsPane("Trunk Utilization"));
        }
        this.subTabs.add((Component)this.getVlanStpPane("Circuits"));
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    private Pane getSpTreePane(String string) {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (iChassisModel.getEtherBridgeModel() == null) {
            return new UnimplementedPane(string, this.subTabs);
        }
        return new MaintSpTreePane(string, this.subTabs, iChassisModel.getEtherBridgeModel());
    }

    private Pane getSmpMacAddrPane(String string) {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (iChassisModel.getEtherBridgeModel() == null) {
            return new UnimplementedPane(string, this.subTabs);
        }
        return new SmpMacAddrPane(string, this.subTabs, iChassisModel);
    }

    private Pane getSmpEtherStatsPane(String string) {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (iChassisModel.getEtherBridgeModel() == null) {
            return new UnimplementedPane(string, this.subTabs);
        }
        return new SmpEtherStatsPane(string, this.subTabs, iChassisModel);
    }

    private Pane getVlanStpPane(String string) {
        IChassisModel iChassisModel = (IChassisModel)this.getUiModel();
        if (iChassisModel.getEtherBridgeModel() == null) {
            return new UnimplementedPane(string, this.subTabs);
        }
        return (Pane)this.uiToolkit.getGuestPane(10, this.subTabs);
    }

    public void refresh() {
    }

    public void enteringPage() {
    }

    public void leavingPage() {
    }
}

