/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.HoTapModel;
import cerent.cms.model.HoTapModels;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LoTapModel;
import cerent.cms.model.LoTapModels;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.TapModel;
import cerent.cms.model.TapModelCollection;
import cerent.cms.ui.RoDataSourceControl;
import cerent.cms.ui.shelf.SmpTestAccessPane;
import cerent.cms.ui.shelf.SmpTestAccessRowObject;
import cerent.util.BlockingModeController;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class SmpTestAccessDataSource
extends AbstractRowDataSource
implements Observer,
RoDataSourceControl,
BlockingModeController {
    private NodeModelDelegate node;
    private ArrayList tapModels;
    private HashMap entities;
    private SmpTestAccessRowObject[] rowObjects;
    private ObservableManager observableManager;
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    private static final SDebug db = new SDebug((KDebug)SmpTestAccessPane.db, "SmpTestAccessDataSource");

    public SmpTestAccessDataSource(INodeModel iNodeModel) {
        this.node = (NodeModelDelegate)iNodeModel;
        this.tapModels = new ArrayList();
        this.entities = new HashMap();
        this.observableManager = new ObservableManager(this, true);
        this.observableManager.setBlockingModeController(this);
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.rowObjects != null ? this.rowObjects[n] : null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (SmpTestAccessDataSource.db.on) {
                db.println("getObjectAtRow " + n + " out of bounds");
            }
            return null;
        }
    }

    public int getRowCount() {
        return this.rowObjects != null ? this.rowObjects.length : 0;
    }

    public Collection getAllObjects() {
        return this.rowObjects != null ? Arrays.asList(this.rowObjects) : new ArrayList();
    }

    public void refreshFromModel(int n) throws Exception {
        if (n == -1 || n == 2) {
            this.resetFromNodeModel();
        }
        this.refreshFromModel();
    }

    private void unwatchPath(String string) {
        Model model = (Model)this.entities.get(string);
        if (model != null) {
            if (SmpTestAccessDataSource.db.on) {
                db.println("unwatch(" + string + ", " + model + ")");
            }
            this.observableManager.removeObservable((Observable)((Object)model));
            this.entities.remove(string);
        }
    }

    private void watchPath(String string, IHoPathDefModel iHoPathDefModel) {
        if (iHoPathDefModel != null) {
            try {
                Model model;
                EntityModel entityModel = (EntityModel)iHoPathDefModel.getPool().getEntityModel();
                if (entityModel != null && !entityModel.equals(model = (Model)this.entities.get(string))) {
                    if (model != null) {
                        if (SmpTestAccessDataSource.db.on) {
                            db.println("unwatch(" + string + ", " + model + ")");
                        }
                        this.observableManager.removeObservable((Observable)((Object)model));
                    }
                    if (SmpTestAccessDataSource.db.on) {
                        db.println("watch(" + string + ", " + entityModel + ")");
                    }
                    this.observableManager.addObservable((Observable)((Object)entityModel));
                    this.entities.put(string, entityModel);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("watch(" + string + "): cannot find " + iHoPathDefModel);
            }
        } else {
            this.unwatchPath(string);
        }
    }

    private void watchTap(HoTapModel hoTapModel) {
        short s = hoTapModel.getTapNumber();
        this.watchPath("HO-" + s + "-A", hoTapModel.getTapA());
        this.watchPath("HO-" + s + "-B", hoTapModel.getTapB());
        this.watchPath("HO-" + s + "-E", hoTapModel.getPathE());
        this.watchPath("HO-" + s + "-F", hoTapModel.getPathF());
    }

    private void unwatchTap(HoTapModel hoTapModel) {
        short s = hoTapModel.getTapNumber();
        this.unwatchPath("HO-" + s + "-A");
        this.unwatchPath("HO-" + s + "-B");
        this.unwatchPath("HO-" + s + "-E");
        this.unwatchPath("HO-" + s + "-F");
    }

    private void watchPath(String string, ILoDefModel iLoDefModel) {
        if (iLoDefModel != null) {
            try {
                Model model;
                EntityTableModel entityTableModel = this.node.getEntityTableModel();
                EntityModel entityModel = (EntityModel)entityTableModel.getEntityModelByIndex(iLoDefModel.getPortIndex());
                if (entityModel != null && !entityModel.equals(model = (Model)this.entities.get(string))) {
                    if (model != null) {
                        if (SmpTestAccessDataSource.db.on) {
                            db.println("unwatch(" + string + ", " + model + ")");
                        }
                        this.observableManager.removeObservable((Observable)((Object)model));
                    }
                    if (SmpTestAccessDataSource.db.on) {
                        db.println("watch(" + string + ", " + entityModel + ")");
                    }
                    this.observableManager.addObservable((Observable)((Object)entityModel));
                    this.entities.put(string, entityModel);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("watch(" + string + "): cannot find " + iLoDefModel);
            }
        } else {
            this.unwatchPath(string);
        }
    }

    private void watchTap(LoTapModel loTapModel) {
        short s = loTapModel.getTapNumber();
        this.watchPath("LO-" + s + "-A", loTapModel.getTapA());
        this.watchPath("LO-" + s + "-B", loTapModel.getTapB());
        this.watchPath("LO-" + s + "-E", loTapModel.getPathE());
        this.watchPath("LO-" + s + "-F", loTapModel.getPathF());
    }

    private void unwatchTap(LoTapModel loTapModel) {
        short s = loTapModel.getTapNumber();
        this.unwatchPath("LO-" + s + "-A");
        this.unwatchPath("LO-" + s + "-B");
        this.unwatchPath("LO-" + s + "-E");
        this.unwatchPath("LO-" + s + "-F");
    }

    private void watchParent(EntityModel entityModel) {
        if (SmpTestAccessDataSource.db.on) {
            db.println("unwatch-all(" + entityModel + ")");
        }
        this.observableManager.removeObservable((Observable)((Object)entityModel));
        try {
            Model model = (EntityModel)entityModel.getParent();
            if (model == null) {
                model = ChassisModels.getInstance((NodeModelDelegate)entityModel.getNodeModel());
            }
            for (Map.Entry entry : this.entities.entrySet()) {
                if (!entry.getValue().equals(entityModel)) continue;
                if (SmpTestAccessDataSource.db.on) {
                    db.println("watch(" + entry.getKey() + ", " + model + ")");
                }
                this.observableManager.addObservable((Observable)((Object)model));
                entry.setValue((EntityModel)model);
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            db.println("watch-parent(): cannot find parent of " + entityModel);
        }
    }

    private void resetFromNodeModel() {
        if (SmpTestAccessDataSource.db.on) {
            db.println("resetFromNodeModel");
        }
        this.observableManager.removeObservable(this.tapModels.toArray(new Observable[this.tapModels.size()]));
        if (this.node != null) {
            TapModelCollection tapModelCollection = this.node.getTapModels();
            this.tapModels.clear();
            if (tapModelCollection != null) {
                HoTapModels hoTapModels = tapModelCollection.getHoTapModels();
                this.observableManager.addObservable((Observable)((Object)hoTapModels));
                HoTapModel[] hoTapModelArray = hoTapModels.getHoTapModels();
                if (SmpTestAccessDataSource.db.on) {
                    db.println("resetFromNodeModel: " + hoTapModelArray.length + " HO TAPs");
                }
                this.observableManager.addObservable((Observable[])hoTapModelArray);
                for (int i = 0; i < hoTapModelArray.length; ++i) {
                    this.watchTap(hoTapModelArray[i]);
                }
                this.tapModels.addAll(Arrays.asList(hoTapModelArray));
                LoTapModels loTapModels = tapModelCollection.getLoTapModels();
                this.observableManager.addObservable((Observable)((Object)loTapModels));
                LoTapModel[] loTapModelArray = loTapModels.getLoTapModels();
                if (SmpTestAccessDataSource.db.on) {
                    db.println("resetFromNodeModel: " + loTapModelArray.length + " LO TAPs");
                }
                this.observableManager.addObservable((Observable[])loTapModelArray);
                for (int i = 0; i < loTapModelArray.length; ++i) {
                    this.watchTap(loTapModelArray[i]);
                }
                this.tapModels.addAll(Arrays.asList(loTapModelArray));
            }
        }
    }

    public void refreshFromModel() {
        if (SmpTestAccessDataSource.db.on) {
            db.println("refreshFromModel()");
        }
        this.rowObjects = new SmpTestAccessRowObject[this.tapModels.size()];
        int n = 0;
        for (Object e : this.tapModels) {
            TapModel tapModel;
            if (SmpTestAccessDataSource.db.on) {
                db.println("tapModels[" + n + "] = " + String.valueOf(e));
            }
            if (e instanceof HoTapModel) {
                tapModel = (HoTapModel)e;
                this.watchTap((HoTapModel)tapModel);
                this.rowObjects[n++] = new SmpTestAccessRowObject(tapModel);
                continue;
            }
            if (e instanceof LoTapModel) {
                tapModel = (LoTapModel)e;
                this.watchTap((LoTapModel)tapModel);
                this.rowObjects[n++] = new SmpTestAccessRowObject(tapModel);
                continue;
            }
            if (SmpTestAccessDataSource.db.on) {
                db.println("tapModels[" + n + "] is not a TAP!");
            }
            this.rowObjects[n++] = null;
        }
        if (SmpTestAccessDataSource.db.on) {
            db.println("refreshFromModel(): fireDataSourceChanged");
        }
        this.fireDataSourceChanged();
    }

    public IObservableManager getObservableManager() {
        if (SmpTestAccessDataSource.db.on) {
            db.println("getObservableManager: state = " + this.observableManager.getBlockingModeControllerState());
        }
        return this.observableManager;
    }

    public void disposeDataSource() {
        this.tapModels.clear();
        this.rowObjects = null;
    }

    public void update(Observable observable, Object object) {
        boolean bl = false;
        if (SmpTestAccessDataSource.db.on) {
            db.println("update: src=(" + observable + "), evt=" + object);
        }
        if (object == ModelUpdateType.ADDED) {
            bl = true;
        } else if (object == ModelUpdateType.CHANGED) {
            if (observable instanceof HoTapModels) {
                bl = true;
            } else if (observable instanceof LoTapModels) {
                bl = true;
            }
        } else if (object == ModelUpdateType.DELETED) {
            if (observable instanceof HoTapModel) {
                this.unwatchTap((HoTapModel)((Object)observable));
            } else if (observable instanceof LoTapModel) {
                this.unwatchTap((LoTapModel)((Object)observable));
            } else if (observable instanceof EntityModel) {
                this.watchParent((EntityModel)((Object)observable));
            }
            bl = true;
        }
        if (bl) {
            this.resetFromNodeModel();
        }
        this.refreshFromModel();
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        int n2;
        if (SmpTestAccessDataSource.db.on) {
            db.println("processBlockedEvent: src " + observable + ", event = " + object + ", previousState = " + n);
        }
        if ((n2 = this.tapModels.indexOf(observable)) == -1 || object == ModelUpdateType.DELETED) {
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }
}

