/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.WrongPortType;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.OpticsPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Observable;

public class Smr240Card
extends CardGraphic {
    private static final int OADMPORTSNUM = 8;
    protected OpticsPortGraphic[] portGraphics = null;

    public Smr240Card(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug, true);
        this.addPortGraphics(entityModel);
        if (this.alarmStore != null) {
            this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
        }
    }

    protected void addPortGraphics(EntityModel entityModel) {
        if (entityModel instanceof ModuleModel) {
            int n;
            List list = entityModel.getChildren();
            int n2 = list.size();
            this.portGraphics = new OpticsPortGraphic[n2];
            int n3 = this.cardPainter.getMiniPortHeight();
            int n4 = this.cardPainter.getMiniPortWidth();
            int n5 = this.cardPainter.getMultiPortOpticonXOffset();
            int n6 = this.cardPainter.getMiniOpticonYSpacing();
            int n7 = this.cardPainter.getMiniOpticonYOffset();
            int n8 = this.cardPainter.getOpticonXSpacing();
            for (n = 0; n < n2; ++n) {
                int n9;
                int n10;
                OpticsPortModel opticsPortModel = (OpticsPortModel)list.get(n);
                int n11 = opticsPortModel.getPort();
                if (((AbstractOpticsLineModel)opticsPortModel.getInterfaceModel()).isPortTypeRX()) {
                    n10 = n5 + n8 * n11 - 6;
                    n9 = n7 + (n6 - 7) * n11;
                } else {
                    n10 = n5 + n8 * n11 + 6;
                    n9 = n7 + (n6 - 7) * (n11 - 1);
                }
                this.portGraphics[n11 - 1] = new OpticsPortGraphic((CardGraphic)this, n10, n9, n4, n3, opticsPortModel);
            }
            n = 2;
            int n12 = n7 + (n6 - 7) * 6 + n3 * 2;
            int n13 = (this.cardPainter.getCardWidth() - 4) / 4;
            for (int i = 8; i < n2; ++i) {
                this.portGraphics[i] = new OpticsPortGraphic((CardGraphic)this, n, n12, n13, n13, (OpticsPortModel)list.get(i));
                n += n13;
            }
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        if (this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                OpticalPortType opticalPortType = null;
                try {
                    opticalPortType = ((OpticsPortModel)this.portGraphics[i].getPortModel()).getOptPortType();
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    this.db.println("No Such Equipment");
                }
                catch (WrongPortType wrongPortType) {
                    this.db.println("wrong equipment");
                }
                if (opticalPortType == OpticalPortType.IN_EXPRESS || opticalPortType == OpticalPortType.OUT_EXPRESS) {
                    this.portGraphics[i].drawOnlyOneConnector(graphics2D, true, true);
                    continue;
                }
                this.portGraphics[i].drawOnlyOneConnector(graphics2D, true, false);
            }
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus && this.portGraphics != null) {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null) continue;
                this.portGraphics[i].update(observable, this.alarmStore);
            }
        }
    }
}

