/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ISpanCheckModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RamanModuleModel;
import cerent.cms.model.RamanSpanCheckModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.LeavePageException;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ans.FloatNumberField;
import cerent.cms.ui.shelf.RamanSpanCheckTableModel;
import cerent.cms.ui.shelf.SpanCheckTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.WindowHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Observable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class SpanCheckPane
extends AbstractPane
implements ITabName,
TableModelListener,
ActionListener,
Runnable {
    public static final String APPLY = "Apply";
    public static final String RESET = "Reset";
    public static final String HELP = "Help";
    private JButton applyButton;
    private JButton resetButton;
    private JButton retrieveButton;
    private CSHelpButton helpButton;
    private boolean isDirty = false;
    private JLabel retrieveLabel;
    private boolean notInited = true;
    private NodeModelDelegate nodeModel;
    private static final String TT_RETRIEVE = "<html>Retrieve span loss values from node(s)</html>";
    private Date lastUpdate;
    private static final int MIN_EXP_SPAN_LOSS = 0;
    private static final int MAX_EXP_SPAN_LOSS = 800;
    private boolean disposed = false;
    protected static final SDebug db = new SDebug("SpanCheckPane");

    public SpanCheckPane(String string, TabbedView tabbedView) {
        super(string, tabbedView.getUiModel(), tabbedView);
        this.nodeModel = (NodeModelDelegate)tabbedView.getUiModel().getNodeModel();
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(SpanCheckTableModel.columnNames[n]);
        this.table.removeColumn(tableColumn);
    }

    public boolean hasSubTabs() {
        return false;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.stopTableCellEditing();
        if (this.isDirty) {
            switch (CerentDialog.questionDialog((Component)((Object)this), (String)"Is it OK to apply these changes?", (String)"Changes Not Applied", (int)0)) {
                case 0: {
                    if (db.on()) {
                        db.println("leavingPage: applying " + this.getName());
                    }
                    this.apply();
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("leavingPage: abandoning changes to " + this.getName());
                    }
                    this.resetDirty();
                    break;
                }
                default: {
                    if (db.on()) {
                        db.println("leavingPage: canceling change from " + this.getName());
                    }
                    this.deleteObservers();
                    throw this.createLeavePageException("Page change canceled by user");
                }
            }
        }
        this.deleteObservers();
    }

    public final void setDirty() {
        this.setDirty(true);
    }

    public final void resetDirty() {
        this.setDirty(false);
    }

    public final boolean isProvPaneDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean bl) {
        if (db.on()) {
            db.println("setDirty: " + this.getName() + ": " + this.isDirty + " -> " + bl);
        }
        this.isDirty = bl;
        if (this.applyButton != null) {
            this.applyButton.setEnabled(this.isDirty);
        }
    }

    protected boolean queryRemainDirty() {
        return false;
    }

    public boolean onValidate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void apply() {
        try {
            if (this.isDirty) {
                this.setCursor(3);
                this.stopTableCellEditing();
                if (!this.onValidate()) {
                    return;
                }
                this.applyChangesToModel();
                if (!this.queryRemainDirty()) {
                    this.resetDirty();
                }
            }
            EventBus.instance().notifyEvent((Object)this.getFullName(), (Object)APPLY);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.println("caught " + (Object)((Object)abstractCmsIOException) + " in Pane.apply");
            }
        }
        catch (EMCProvisionError eMCProvisionError) {
            if (db.on()) {
                db.println("caught " + (Object)((Object)eMCProvisionError) + " in Pane.apply");
            }
            ErrorMsg.displayError((Component)((Object)this), (EID)eMCProvisionError.getEID(), (Object)eMCProvisionError.getEIDMsg());
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_APPLY_CHANGES, exception.getMessage());
        }
        finally {
            this.setCursor(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refresh() {
        try {
            this.setCursor(3);
            this.cancelTableCellEditing();
            this.refreshFromModel();
            this.resetDirty();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_PANE);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_REFRESH_PANE);
        }
        finally {
            this.setCursor(0);
        }
    }

    public void help() {
    }

    protected AbstractLeavePageException createLeavePageException(String string) {
        if (db.on()) {
            db.println("createLeavePageException");
        }
        return new LeavePageException(string);
    }

    protected void init() {
        this.table = this.createTableFactory();
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){
            boolean flag = true;

            public void mouseReleased(MouseEvent mouseEvent) {
                SpanCheckPane.this.sortAllRowsBy(SpanCheckPane.this.getTableModel(), 0, this.flag);
                this.flag = !this.flag;
            }
        });
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(true);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.notInited = false;
        this.createButtonPanel();
    }

    private JTable createTableFactory() {
        ISideModel[] iSideModelArray = this.nodeModel.getSideModelsModel().getSides();
        IEntityTableModel iEntityTableModel = this.nodeModel.getEntityTable();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            int n = iSideModelArray[i].getLineIn();
            try {
                if (!(iEntityTableModel.getEntityModelByIndex(n).getParent() instanceof RamanModuleModel)) continue;
                return new JTable(new RamanSpanCheckTableModel(this.nodeModel, iSideModelArray));
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
        return new JTable(new SpanCheckTableModel(this.nodeModel));
    }

    protected void prepareColumns() {
        TableColumn tableColumn = this.table.getColumn(SpanCheckTableModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(100);
        FloatNumberField floatNumberField = new FloatNumberField(32, 0.0f, 800.0f);
        tableColumn = this.table.getColumn(SpanCheckTableModel.columnNames[2]);
        tableColumn.setCellEditor(new DefaultCellEditor(floatNumberField));
        tableColumn.setPreferredWidth(200);
        FloatNumberField floatNumberField2 = new FloatNumberField(32, 0.0f, 800.0f);
        tableColumn = this.table.getColumn(SpanCheckTableModel.columnNames[3]);
        tableColumn.setCellEditor(new DefaultCellEditor(floatNumberField2));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(SpanCheckTableModel.columnNames[4]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(SpanCheckTableModel.columnNames[5]);
        tableColumn.setCellEditor(new DefaultCellEditor(new FixedLengthField(32)));
        tableColumn.setPreferredWidth(200);
    }

    protected SpanCheckTableModel getTableModel() {
        if (this.table != null) {
            return (SpanCheckTableModel)this.table.getModel();
        }
        return null;
    }

    public void applyChangesToModel() throws Exception {
        this.getTableModel().applyToModel();
        this.resetDirty();
    }

    public void sortAllRowsBy(SpanCheckTableModel spanCheckTableModel, int n, boolean bl) {
        Vector vector = spanCheckTableModel.getSpanCheckList();
        Collections.sort(vector, new ColumnSorter(n, bl));
        spanCheckTableModel.fireTableDataChanged();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.getTableModel().isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    public synchronized void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Got update from " + observable + " arg=" + object);
        }
    }

    public void destroy() {
        this.disposed = true;
        super.destroy();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.getTableModel().refreshFromModel();
        this.resetDirty();
        if (this.getTableModel().getRowCount() == 0) {
            this.retrieveButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        } else {
            this.retrieveButton.setEnabled(true);
            this.resetButton.setEnabled(true);
        }
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        if (this.isDirty && db.on()) {
            db.println("enteringPage: " + this.getName() + " is dirty");
        }
        if (db.on()) {
            db.println("enteringPage: refreshing " + this.getName());
        }
        ((SpanCheckTableModel)this.table.getModel()).addTableModelListener(this);
        this.refresh();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.getTableModel().refreshFromModel();
    }

    protected void createButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.retrieveButton = new JButton("Retrieve Span Loss values");
        this.retrieveButton.addActionListener(this);
        this.resetButton = new JButton(RESET);
        this.resetButton.addActionListener(this);
        this.retrieveLabel = new JLabel(" ");
        this.retrieveButton.setToolTipText(TT_RETRIEVE);
        this.applyButton = new JButton(APPLY);
        this.applyButton.addActionListener(this);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SpanCheckPane);
        cSHelpButtonPane.addLeft(this.retrieveButton);
        cSHelpButtonPane.addLeft(this.resetButton);
        cSHelpButtonPane.addLeft(this.applyButton);
        cSHelpButtonPane.addRight(this.retrieveLabel);
        this.add(cSHelpButtonPane, "South");
        this.applyButton.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this.retrieveButton) {
                this.uiToolkit.setCursor(3);
                this.updateConditions();
                this.getTableModel().fireTableDataChanged();
            } else if (object == this.resetButton) {
                this.getTableModel().refreshFromModel();
            } else if (object == this.applyButton) {
                this.apply();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.uiToolkit.setCursor(0);
        }
    }

    private void updateConditions() {
        this.retrieveButton.setEnabled(false);
        WindowHelper.setLabelText((JLabel)this.retrieveLabel, (String)"Retrieving values...");
        new Thread((Runnable)this, "Span Loss Retriever Thread").start();
    }

    public void run() {
        ISpanCheckModel iSpanCheckModel;
        ISpanCheckModel[] iSpanCheckModelArray = this.nodeModel.getSpanCheckModels().getSpanCheckModel();
        WindowHelper.setEnabled((JComponent)this.resetButton, (boolean)false);
        for (int i = 0; i < iSpanCheckModelArray.length; ++i) {
            iSpanCheckModel = iSpanCheckModelArray[i];
            try {
                if (iSpanCheckModel instanceof RamanSpanCheckModel) continue;
                iSpanCheckModel.calculateSpanLoss();
                continue;
            }
            catch (CannotPerform cannotPerform) {
                SDebug.printStackTrace((Throwable)cannotPerform);
            }
        }
        this.waitResponse();
        if (!this.disposed) {
            String string = "Not able to perform calculation for side:\n";
            boolean bl = false;
            for (int i = 0; i < iSpanCheckModelArray.length; ++i) {
                iSpanCheckModel = iSpanCheckModelArray[i];
                if (iSpanCheckModel.isCalcSuccessful()) continue;
                string = string + iSpanCheckModel.getSide() + "\n";
                bl = true;
            }
            if (bl) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_ERROR_MEAS_SPAN_LOSS_INPUT, string);
            }
            this.updateWatchLabel(new Date());
            WindowHelper.setEnabled((JComponent)this.retrieveButton, (boolean)true);
            WindowHelper.setEnabled((JComponent)this.resetButton, (boolean)true);
            this.getTableModel().fireTableDataChanged();
        }
    }

    private synchronized void waitResponse() {
        try {
            this.wait(6000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void updateWatchLabel(Date date) {
        this.lastUpdate = date;
        WindowHelper.setLabelText((JLabel)this.retrieveLabel, (String)("Retrieved: " + SpanCheckPane.getFormattedDateTime(this.lastUpdate)));
    }

    public void dispose() {
        this.disposed = true;
    }

    private void deleteObservers() {
        if (this.getTableModel() != null) {
            this.getTableModel().removeTableModelListener(this);
        }
    }

    class ColumnSorter
    implements Comparator {
        int colIndex;
        boolean ascending;

        ColumnSorter(int n, boolean bl) {
            this.colIndex = n;
            this.ascending = bl;
        }

        public int compare(Object object, Object object2) {
            SpanCheckTableModel.SpanCheckInfo spanCheckInfo = (SpanCheckTableModel.SpanCheckInfo)object;
            SpanCheckTableModel.SpanCheckInfo spanCheckInfo2 = (SpanCheckTableModel.SpanCheckInfo)object2;
            if (spanCheckInfo == null && spanCheckInfo2 == null) {
                return 0;
            }
            if (spanCheckInfo == null) {
                return 1;
            }
            if (spanCheckInfo2 == null) {
                return -1;
            }
            if (spanCheckInfo instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)((Object)spanCheckInfo)).compareTo(spanCheckInfo2);
                }
                return ((Comparable)((Object)spanCheckInfo2)).compareTo(spanCheckInfo);
            }
            if (this.ascending) {
                switch (this.colIndex) {
                    case 0: {
                        return spanCheckInfo.sideVal.compareTo(spanCheckInfo2.sideVal);
                    }
                    case 2: {
                        return spanCheckInfo.expMinSpanLossVal.compareTo(spanCheckInfo2.expMinSpanLossVal);
                    }
                    case 3: {
                        return spanCheckInfo.expMaxSpanLossVal.compareTo(spanCheckInfo2.expMaxSpanLossVal);
                    }
                    case 4: {
                        return spanCheckInfo.measSpanLossVal.compareTo(spanCheckInfo2.measSpanLossVal);
                    }
                    case 5: {
                        return spanCheckInfo.resolutionVal.compareTo(spanCheckInfo2.resolutionVal);
                    }
                }
                return spanCheckInfo.toString().compareTo(spanCheckInfo2.toString());
            }
            switch (this.colIndex) {
                case 0: {
                    return spanCheckInfo2.sideVal.compareTo(spanCheckInfo.sideVal);
                }
                case 2: {
                    return spanCheckInfo2.expMinSpanLossVal.compareTo(spanCheckInfo.expMinSpanLossVal);
                }
                case 3: {
                    return spanCheckInfo2.expMaxSpanLossVal.compareTo(spanCheckInfo.expMaxSpanLossVal);
                }
                case 4: {
                    return spanCheckInfo2.measSpanLossVal.compareTo(spanCheckInfo.measSpanLossVal);
                }
                case 5: {
                    return spanCheckInfo2.resolutionVal.compareTo(spanCheckInfo.resolutionVal);
                }
            }
            return spanCheckInfo2.toString().compareTo(spanCheckInfo.toString());
        }
    }
}

