/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.IntPatchCreationDialog;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ans.AnsConnColumnRenderer;
import cerent.cms.ui.ans.AnsConnDataSource;
import cerent.cms.ui.ans.AnsConnTableModel;
import cerent.cms.ui.functional.FunctionalEditDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class SppAnsIntPatchPane
extends AbstractPane
implements ActionListener,
ListSelectionListener {
    private static final SDebug db = new SDebug("SppAnsIntPatchPane");
    private static final String CREATE = "Create...";
    private static final String DELETE = "Delete";
    private static final String MPO_FILTER = "MPO Filter";
    private JButton createButton = new JButton("Create...");
    private JButton deleteButton = new JButton("Delete");
    private JCheckBox mpoFilterCB = new JCheckBox("MPO Filter");
    private AnsConnTableModel dataModel;
    private AnsConnDataSource dataSource;
    private boolean initialized = true;
    private static final int[] sortCols = new int[]{0, 1, 2};
    private static final boolean[] sortDir = new boolean[]{true, true, true};
    private NodeModelDelegate nodeModel;
    protected OpticalPatchCordModel optPatchModel;

    public SppAnsIntPatchPane(String string, TabbedView tabbedView, OpticalPatchCordModel opticalPatchCordModel) {
        super(string, tabbedView);
        this.optPatchModel = opticalPatchCordModel;
    }

    private void init() {
        if (db.on()) {
            db.println("init");
        }
        this.setLayout(new BorderLayout());
        this.nodeModel = (NodeModelDelegate)this.optPatchModel.getNodeModel();
        this.dataSource = new AnsConnDataSource(this.optPatchModel);
        this.dataModel = new AnsConnTableModel(this.dataSource, sortCols, sortDir);
        this.table = new UTable((TableModel)((Object)this.dataModel));
        this.table.setSelectionMode(2);
        ((AnsConnTableModel)((Object)this.table.getModel())).initTable(this.table);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    int n = SppAnsIntPatchPane.this.table.getSelectedRow();
                    IOptLinkModel iOptLinkModel = (IOptLinkModel)SppAnsIntPatchPane.this.dataModel.getValueAt(n, 0);
                    if (iOptLinkModel != null && iOptLinkModel.getChildren().size() > 0) {
                        ShowMPOChildrenDialog.instance(JOptionPane.getFrameForComponent(mouseEvent.getComponent()), SppAnsIntPatchPane.this.parentTV.getUiModel(), iOptLinkModel.getChildren());
                    }
                }
            }
        });
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.add(this.makeControlPanel(), "South");
        this.add((Component)new UScrollPane((Component)this.table), "Center");
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        this.mpoFilterCB.setSelected(true);
        this.createButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.mpoFilterCB.addActionListener(this);
        jPanel2.add(this.createButton);
        jPanel2.add(this.deleteButton);
        jPanel2.add(this.mpoFilterCB);
        jPanel3.add(new CSHelpButton(CSHelpConst.SppAnsConnPane));
        this.enableComponent(this.createButton, this.nodeModel, SecurityLevel.PROVISIONING);
        this.enableComponent(this.deleteButton, this.nodeModel, SecurityLevel.PROVISIONING);
        this.deleteButton.setEnabled(false);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FunctionalEditDialog functionalEditDialog;
        Object object = actionEvent.getSource();
        if (object == this.createButton) {
            IntPatchCreationDialog intPatchCreationDialog = this.getIntPatchCreationDialog();
            intPatchCreationDialog.showModal();
        } else if (object == this.deleteButton) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length == 0) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_OPTICAL_LINK_SEL);
                return;
            }
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Delete selected optical patchcord" + (this.table.getSelectedColumn() == -1 ? "" : "s") + "?"), (String)"Confirmation Dialog")) {
                return;
            }
            this.deleteOptLink();
        } else if (object == this.mpoFilterCB) {
            this.dataSource.getOpticalLinkList(this.mpoFilterCB.isSelected());
        } else if (object == FunctionalEditDialog.getButton(this.nodeModel.getName())) {
            if (this.nodeModel instanceof INodeModel) {
                FunctionalEditDialog functionalEditDialog2 = FunctionalEditDialog.instance((JPanel)((Object)this), this.nodeModel);
                functionalEditDialog2.setVisible(true);
            }
        } else if (actionEvent.getActionCommand() == "Functional View" && (functionalEditDialog = FunctionalEditDialog.instance((JPanel)((Object)this), this.nodeModel)) != null) {
            functionalEditDialog.setVisible(true);
        }
    }

    protected IntPatchCreationDialog getIntPatchCreationDialog() {
        return IntPatchCreationDialog.instance(this, this.nodeModel, this.dataSource, this.optPatchModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.dataSource == null) {
                this.init();
            }
            if (this.initialized) {
                this.dataSource.init(this.mpoFilterCB.isSelected());
                this.initialized = false;
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
            this.table.getSelectionModel().addListSelectionListener(this);
        }
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.table.getSelectionModel().removeListSelectionListener(this);
    }

    public void refresh() {
    }

    public void deleteOptLink() {
        int n;
        int[] nArray = this.table.getSelectedRows();
        boolean bl = false;
        if (nArray.length == 0) {
            return;
        }
        ArrayList<IOptLinkModel> arrayList = new ArrayList<IOptLinkModel>();
        Object[] objectArray = new String[]{"Continue", "No more messages", "Cancel"};
        for (n = 0; n < nArray.length; ++n) {
            IOptLinkModel iOptLinkModel = (IOptLinkModel)this.dataModel.getValueAt(nArray[n], 0);
            arrayList.add(iOptLinkModel);
        }
        if (this.isOchPatchSelectionUnComplete() && (n = (int)(ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_DEL_PATCH_INCOMPLETE_OCH, "Deletion") ? 1 : 0)) == 0) {
            return;
        }
        if (this.isTrunk2TrunkPatchSelectionUnComplete() && (n = (int)(ErrorMsg.displayWarningYesNo((Component)((Object)this), (EID)EMC.WID_DEL_PATCH_INCOMPLETE_T2T, "Deletion") ? 1 : 0)) == 0) {
            return;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                int n2 = 0;
                IOptLinkModel iOptLinkModel = (IOptLinkModel)iterator.next();
                try {
                    this.dataSource.deleteOptLink(iOptLinkModel);
                }
                catch (Exception exception) {
                    if (arrayList.size() > 1) {
                        if (!bl) {
                            String string = "Unable to delete internal patchcord\r\nfrom port " + iOptLinkModel.getFromPortName(false) + " to port " + iOptLinkModel.getToPortName(false) + ".";
                            if (exception instanceof Busy) {
                                string = string + ErrorMsg.getString((EID)EMC.EID_DEL_PATCH_BUSY);
                            }
                            n2 = CerentDialog.optionDialog((Component)((Object)this), (String)string, (String)"Internal optical patchcord warning", (Object[])objectArray, (Object)"continue");
                        }
                        if (n2 == 0) {
                            if (!SppAnsIntPatchPane.db.on) continue;
                            db.println("exception deleting patch select yes -> continue");
                            continue;
                        }
                        if (n2 == 1) {
                            bl = true;
                            continue;
                        }
                        if (!SppAnsIntPatchPane.db.on) break;
                        db.println("exception deleting patch select no-> break");
                        break;
                    }
                    if (exception instanceof Busy) {
                        ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_DEL_OPTICAL_LINK, ErrorMsg.getString((EID)EMC.EID_DEL_PATCH_BUSY));
                        continue;
                    }
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_DEL_OPTICAL_LINK);
                }
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_DEL_OPTICAL_LINK);
            }
        }
        this.dataSource.updateTable();
    }

    private boolean isOchPatchSelectionUnComplete() {
        boolean bl = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int n;
            block8: {
                IOptLinkModel object = (IOptLinkModel)this.dataModel.getValueAt(i, 0);
                n = -1;
                try {
                    if (object.getFromModel().getEqType() == 123 || object.getFromModel().getEqType() == 30 || object.getFromModel().getEqType() == 61) {
                        n = object.getFromModel().getEntityIndex();
                    } else if (object.getToModel().getEqType() == 123 || object.getToModel().getEqType() == 30 || object.getToModel().getEqType() == 61) {
                        n = object.getToModel().getEntityIndex();
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!SppAnsIntPatchPane.db.on) break block8;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            if (n == -1) continue;
            if (this.table.isRowSelected(i)) {
                arrayList2.add(new Integer(n));
                continue;
            }
            arrayList.add(new Integer(n));
        }
        for (Integer n : arrayList2) {
            if (!arrayList.contains(n)) continue;
            bl = true;
        }
        return bl;
    }

    boolean isTrunk2TrunkPatchSelectionUnComplete() {
        boolean bl = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int n;
            int n2;
            block6: {
                IOptLinkModel object = (IOptLinkModel)this.dataModel.getValueAt(i, 0);
                n2 = -1;
                n = -1;
                try {
                    if (object.getFromModel().getEqType() == 123 && object.getToModel().getEqType() == 123) {
                        n = object.getFromModel().getEntityIndex();
                        n2 = object.getToModel().getEntityIndex();
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!SppAnsIntPatchPane.db.on) break block6;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
            if (n == -1 || n2 == -1) continue;
            if (this.table.isRowSelected(i)) {
                arrayList2.add(new Integer(n));
                arrayList2.add(new Integer(n2));
                continue;
            }
            arrayList.add(new Integer(n));
            arrayList.add(new Integer(n2));
        }
        for (Integer n : arrayList2) {
            if (!arrayList.contains(n)) continue;
            bl = true;
        }
        return bl;
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
        if (this.dataSource != null) {
            this.dataSource.dispose();
            this.dataSource = null;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length > 0) {
                this.enableComponent(this.deleteButton, this.nodeModel, SecurityLevel.PROVISIONING);
            }
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatchCordDataSource
    extends AbstractRowDataSource {
        private List<IOptLinkModel> optLinkList = new ArrayList<IOptLinkModel>();

        void setOptLinks(List<IOptLinkModel> list) {
            this.optLinkList = list;
            this.fireDataSourceChanged();
        }

        public Object getObjectAtRow(int n) {
            return this.optLinkList.get(n);
        }

        public int getRowCount() {
            return this.optLinkList.size();
        }

        public Collection getAllObjects() {
            return this.optLinkList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ShowMPOChildrenDialog
    extends UDialog {
        private static final String DIALOG_TITLE = "MPO Patch-cords detail";
        private PatchCordDataSource dataSource;

        public static ShowMPOChildrenDialog instance(Frame frame, IModel iModel, List<IOptLinkModel> list) {
            return new ShowMPOChildrenDialog(frame, iModel, list);
        }

        private ShowMPOChildrenDialog(Frame frame, IModel iModel, List<IOptLinkModel> list) {
            super(frame, DIALOG_TITLE, true);
            this.dataSource.setOptLinks(list);
            if (db.on()) {
                db.println(((Object)((Object)this)).getClass().toString() + " ShowMPOChildrenDialog constructor");
            }
            this.setVisible(true);
        }

        private JPanel getButtonPanel() {
            if (db.on()) {
                db.println(((Object)((Object)this)).getClass().toString() + " getButtonPanel");
            }
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ShowMPOChildrenDialog.this.dispose();
                }
            });
            jButton.setEnabled(true);
            jPanel2.add(jButton);
            jPanel.add(jPanel2);
            return jPanel;
        }

        private JPanel getParamPanel() {
            if (db.on()) {
                db.println(((Object)((Object)this)).getClass().toString() + " getLocalePanel");
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.dataSource = new PatchCordDataSource();
            SortableRowTableModel sortableRowTableModel = new SortableRowTableModel((RowDataSource)this.dataSource, AnsConnColumnRenderer.createTableRenderers(), IOptLinkModel.class, sortCols, sortDir);
            UTable uTable = new UTable((TableModel)((Object)sortableRowTableModel));
            sortableRowTableModel.initTable((JTable)uTable);
            uTable.setPreferredScrollableViewportSize(new Dimension(uTable.getPreferredSize().width, 180));
            JScrollPane jScrollPane = new JScrollPane((Component)uTable, 20, 30);
            jPanel.add(jScrollPane);
            return jPanel;
        }

        protected void initContentPane(JPanel jPanel, Object object) {
            this.setSize(new Dimension(350, 500));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.getParamPanel(), "North");
            jPanel.add((Component)this.getButtonPanel(), "South");
        }
    }
}

