/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.UnimplementedPane;
import cerent.cms.ui.shelf.DwdmPassivePane;
import cerent.cms.ui.shelf.ProvSpPathPane;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.cms.ui.shelf.SidePane;
import cerent.cms.ui.shelf.SppAnsIntPatchPane;
import cerent.cms.ui.shelf.SppAnsNeUpdatePane;
import cerent.cms.ui.shelf.SppNodeSetupPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;

public class SppAnsPane
extends AbstractPane
implements ITabName {
    private static final SDebug db = new SDebug((KDebug)ShelfTabbedView.db, "SppOnsPane");

    public SppAnsPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.subTabs = new SubTabbedView(tabbedView.getUiModel(), tabbedView);
        this.subTabs.setTabPlacement(1);
        this.subTabs.add((Component)this.getAnsParamsPane("Provisioning"));
        this.subTabs.add((Component)this.getSpIntPatchPane("Internal Patchcords"));
        this.subTabs.add((Component)this.getSpPathPane("Port Status"));
        this.subTabs.add((Component)this.getNodeSetupPane("Node Setup"));
        this.subTabs.add((Component)this.getSidePane("Optical Side"));
        this.subTabs.add((Component)this.getPassiveCardPane("Passive Cards"));
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    protected Pane getSpPathPane(String string) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        return new ProvSpPathPane(string, this.subTabs, nodeModelDelegate.getDwdmOpticalSetupModel());
    }

    private Pane getSpIntPatchPane(String string) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        if (nodeModelDelegate.getOpticalPatchCordModel() == null) {
            return new UnimplementedPane(string, this.subTabs);
        }
        return new SppAnsIntPatchPane(string, this.subTabs, nodeModelDelegate.getOpticalPatchCordModel());
    }

    private Pane getAnsParamsPane(String string) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        if (nodeModelDelegate.getDwdmOpticalSetupModel() == null) {
            return new UnimplementedPane(string, this.subTabs);
        }
        return new SppAnsNeUpdatePane(string, this.subTabs);
    }

    private Pane getAnsNeUpdatePane(String string) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        if (nodeModelDelegate.getDwdmOpticalSetupModel() == null) {
            return new UnimplementedPane(string, this.subTabs);
        }
        return new SppAnsNeUpdatePane(string, this.subTabs);
    }

    private Pane getNodeSetupPane(String string) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        if (nodeModelDelegate.getDwdmOpticalSetupModel() == null) {
            return new UnimplementedPane(string, this.subTabs);
        }
        return new SppNodeSetupPane(string, this.subTabs);
    }

    private Pane getSidePane(String string) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        if (nodeModelDelegate.getDwdmOpticalSetupModel() == null) {
            return new UnimplementedPane(string, this.subTabs);
        }
        return new SidePane(string, this.subTabs);
    }

    private Pane getPassiveCardPane(String string) {
        return new DwdmPassivePane(string, this.subTabs);
    }

    public void refresh() {
    }

    public void enteringPage() {
    }

    public void leavingPage() {
    }
}

