/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.FirewallTunnelsModel;
import cerent.cms.model.FtpHostsImplModel;
import cerent.cms.model.FtpHostsModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProxyTunnelsModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TunnelsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NoPrivilegePane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.FtpHostPane;
import cerent.cms.ui.shelf.OspfPane;
import cerent.cms.ui.shelf.RipPane;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.cms.ui.shelf.SppNetworkGeneralPane;
import cerent.cms.ui.shelf.StaticRoutePane;
import cerent.cms.ui.shelf.TunnelsPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridLayout;

public class SppNetworkPane
extends AbstractPane
implements ITabName {
    protected static final SDebug db = new SDebug((KDebug)ShelfTabbedView.db, "SppNetworkPane");
    private TunnelsPane _firewallTunnelsPane = null;
    private TunnelsPane _proxyTunnelsPane = null;
    private FtpHostPane _ftpHostPane = null;
    private boolean _showingTunnels = false;
    protected IGuestPaneFactory gpf;

    public SppNetworkPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        super(string, tabbedView);
        this.gpf = iGuestPaneFactory;
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel().getNodeModel();
        this.subTabs = new SubTabbedView(tabbedView.getUiModel(), tabbedView);
        this.subTabs.setTabPlacement(1);
        this.subTabs.add((Component)this.getIpPane("General"));
        boolean bl = true;
        if (nodeModelDelegate.getPlatform().isSecureModeSupported() && nodeModelDelegate.isSecureMode()) {
            bl = this.isUserAuthorized(SecurityLevel.SUPERUSER);
        }
        if (bl) {
            this.subTabs.add((Component)this.getStaticRoutePane("Static Routing"));
        } else {
            this.subTabs.add((Component)((Object)new NoPrivilegePane("Static Routing", tabbedView)));
        }
        this.subTabs.add((Component)this.getOspfPane("OSPF"));
        if (nodeModelDelegate.getPlatform().isRIPPaneSupported()) {
            this.subTabs.add((Component)this.getRipPane("RIP"));
        }
        this.subTabs.add((Component)this.getFtpHostsPane());
        Pane pane = nodeModelDelegate.getPlatform().getInternalSubnetPane("Internal Subnet", this.subTabs, iGuestPaneFactory, (NodeModelDelegate)this.getUiModel().getNodeModel());
        if (pane != null) {
            this.subTabs.add((Component)pane);
        }
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)this.subTabs);
    }

    protected Pane getIpPane(String string) {
        return new SppNetworkGeneralPane(string, this.subTabs, this.gpf);
    }

    protected Pane getStaticRoutePane(String string) {
        return new StaticRoutePane(string, this.subTabs);
    }

    protected Pane getOspfPane(String string) {
        return new OspfPane(string, this.subTabs);
    }

    protected Pane getRipPane(String string) {
        return new RipPane(string, this.subTabs);
    }

    protected synchronized Pane getProxyTunnelsPane() {
        if (this._proxyTunnelsPane == null) {
            this._proxyTunnelsPane = new TunnelsPane("Proxy", CSHelpConst.ProxyTunnelsPane, this.subTabs, this.getProxyTunnelsModel());
        }
        return this._proxyTunnelsPane;
    }

    protected Pane getFtpHostsPane() {
        if (this._ftpHostPane == null) {
            this._ftpHostPane = new FtpHostPane("FTP Hosts", CSHelpConst.FtpHostPane, this.subTabs, this.getFtpHostsModel());
        }
        return this._ftpHostPane;
    }

    private FtpHostsModel getFtpHostsModel() {
        return FtpHostsImplModel.getInstance(this.getNode());
    }

    private TunnelsModel getProxyTunnelsModel() {
        return ProxyTunnelsModel.getInstance(this.getNode());
    }

    protected synchronized Pane getFirewallTunnelsPane() {
        if (this._firewallTunnelsPane == null) {
            this._firewallTunnelsPane = new TunnelsPane("Firewall", CSHelpConst.FirewallTunnelsPane, this.subTabs, this.getFirewallTunnelsModel());
        }
        return this._firewallTunnelsPane;
    }

    private TunnelsModel getFirewallTunnelsModel() {
        return FirewallTunnelsModel.getInstance(this.getNode());
    }

    private boolean allowTunnels() {
        return !this.getNode().getSecureIpConfig().isSecureMode();
    }

    private NodeModelDelegate getNode() {
        return (NodeModelDelegate)this.subTabs.getUiModel().getNodeModel();
    }

    public void refresh() {
    }

    public void enteringPage() {
        if (this.allowTunnels()) {
            if (!this._showingTunnels) {
                this._showingTunnels = true;
                this.subTabs.add((Component)this.getProxyTunnelsPane());
                this.subTabs.add((Component)this.getFirewallTunnelsPane());
            }
        } else if (this._showingTunnels) {
            this._showingTunnels = false;
            this.subTabs.remove((Component)this.getProxyTunnelsPane());
            this.subTabs.remove((Component)this.getFirewallTunnelsPane());
        }
    }

    public void leavingPage() {
    }
}

