/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.SonetTopology.eBlsrProtectionOp;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.Busy;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.IBlsrLimits;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.SquelchTableDialog;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.BlsrCreationDialog;
import cerent.cms.ui.shelf.BlsrRingMapDialog;
import cerent.cms.ui.shelf.BlsrRipTblDialog;
import cerent.cms.ui.shelf.BlsrTableModel;
import cerent.cms.ui.shelf.BlsrTablePane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IgnorableDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SppRingPane
extends BlsrTablePane
implements ActionListener,
ListSelectionListener {
    static final String CREATE = "Create...";
    static final String DELETE = "Delete...";
    static final String RINGMAP = "Ring Map...";
    static final String SQUELCHTABLE = "Squelch Table...";
    static final String RIPTABLE = "Rip Table...";
    static final String UPGRADE = "Upgrade...";
    static final String IGNORABLE_CREATE_PREF = "IgnoreBlsrWizardCreateMessage";
    static final String IGNORABLE_DELETE_PREF = "IgnoreBlsrWizardDeleteMessage";
    static final String IGNORABLE_UPGRADE_PREF = "IgnoreBlsrWizardUpgradeMessage";
    static final String IGNORABLE_SUGGEST_DESCR = "Suggest use of wizard for Ring";
    private JButton createPB;
    private JButton deletePB;
    private JButton ringMapPB;
    private JButton squelchTablePB;
    private JButton ripTablePB;
    private JButton upgradePB;
    private int maxRings;
    private boolean userAuthorized;
    private boolean mayCreate4Fiber;
    private boolean mayUpgradeTo4Fiber;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppRingPane");
    private IBlsrLimits blsrLimits;

    public SppRingPane(String string, TabbedView tabbedView) {
        super(string, tabbedView, 1);
    }

    private void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.blsrLimits = ((IChassisModel)this.getUiModel()).getElementModels().getBlsrLimits();
        this.maxRings = this.blsrLimits.getMaxBlsr();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(7);
        TableColumn tableColumn2 = tableColumnModel.getColumn(9);
        tableColumnModel.removeColumn(tableColumn);
        tableColumnModel.removeColumn(tableColumn2);
        this.table.sizeColumnsToFit(-1);
        this.userAuthorized = this.isUserAuthorized();
        this.add(this.createButtonPanel(), "South");
        if (db.on()) {
            db.println("init: finish");
        }
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        SppRingPane sppRingPane = this;
        synchronized (sppRingPane) {
            if (this.table != null) {
                boolean bl;
                boolean bl2 = bl = this.table.getSelectedRowCount() > 0;
                if (SppRingPane.db.on) {
                    db.println("valueChanged: rowSelected = " + bl);
                }
                if (this.deletePB != null) {
                    this.deletePB.setEnabled(this.userAuthorized && bl);
                } else if (SppRingPane.db.on) {
                    db.println("error: deletePB is null");
                }
                if (this.ringMapPB != null) {
                    this.ringMapPB.setEnabled(bl);
                } else if (SppRingPane.db.on) {
                    db.println("error: ringMapPB is null");
                }
                if (this.squelchTablePB != null) {
                    this.squelchTablePB.setEnabled(bl);
                } else if (SppRingPane.db.on) {
                    db.println("error: squelchTablePB is null");
                }
                if (this.ripTablePB != null) {
                    this.ripTablePB.setEnabled(bl);
                } else if (SppRingPane.db.on) {
                    db.println("error: ripTablePB is null");
                }
                if (this.upgradePB != null) {
                    this.upgradePB.setEnabled(this.userAuthorized && bl && this.upgradeAllowed());
                } else if (SppRingPane.db.on) {
                    db.println("error: upgradePB is null");
                }
            }
        }
    }

    private boolean upgradeAllowed() {
        boolean bl;
        block5: {
            int n;
            bl = false;
            if (this.mayUpgradeTo4Fiber && (n = this.table.getSelectedRow()) > -1) {
                BlsrModel blsrModel = this.getBlsrModel(n);
                try {
                    if (blsrModel.getTypeEnum() == eElementType.BLSR_2_WIRE && blsrModel.getWestEntityModel().getEqType() != 29) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    if (!SppRingPane.db.on) break block5;
                    db.println("upgradeAllowed: unable to get west entity model from selected BLSR");
                }
            }
        }
        if (SppRingPane.db.on) {
            db.println("upgradeAllowed: returning " + bl);
        }
        return bl;
    }

    private BlsrModel getBlsrModel(int n) {
        return ((BlsrTableModel)this.table.getModel()).getBlsrModel(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableChanged(TableModelEvent tableModelEvent) {
        short s = 0;
        SppRingPane sppRingPane = this;
        synchronized (sppRingPane) {
            if (this.table != null) {
                boolean bl;
                boolean bl2 = bl = this.userAuthorized && this.table.getRowCount() < this.maxRings;
                if (SppRingPane.db.on) {
                    db.println("tableChanged: mayCreate = " + bl);
                }
                if (this.createPB != null) {
                    this.createPB.setEnabled(bl);
                } else if (SppRingPane.db.on) {
                    db.println("createPB is null");
                }
                this.mayCreate4Fiber = bl;
                this.mayUpgradeTo4Fiber = true;
                for (int i = 0; i < this.table.getRowCount(); ++i) {
                    if (this.getBlsrModel(i) != null) {
                        if (this.getBlsrModel(i).getTypeEnum() != eElementType.BLSR_4_WIRE) continue;
                        s = (short)(s + 1);
                        continue;
                    }
                    if (!SppRingPane.db.on) continue;
                    db.println("blsrModel #" + i + " was null!");
                }
                this.mayUpgradeTo4Fiber = this.mayCreate4Fiber = this.blsrLimits.getMax4FBlsr() > s;
                if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                    this.table.clearSelection();
                }
            }
        }
        super.tableChanged(tableModelEvent);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = SppRingPane.createHorizontalPanel(null);
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        this.createPB = this.makeActionButton(CREATE, this.userAuthorized);
        jPanel.add(this.createPB);
        this.deletePB = this.makeActionButton(DELETE, false);
        jPanel.add(this.deletePB);
        this.ringMapPB = this.makeActionButton(RINGMAP, false);
        jPanel.add(this.ringMapPB);
        this.squelchTablePB = this.makeActionButton(SQUELCHTABLE, false);
        jPanel.add(this.squelchTablePB);
        this.ripTablePB = this.makeActionButton(RIPTABLE, false);
        jPanel.add(this.ripTablePB);
        this.upgradePB = this.makeActionButton(UPGRADE, false);
        if (this.blsrLimits.getMax4FBlsr() > 0) {
            jPanel.add(this.upgradePB);
        }
        return jPanel;
    }

    private JButton makeActionButton(String string, boolean bl) {
        JButton jButton = new JButton(string);
        jButton.setEnabled(bl);
        jButton.addActionListener(this);
        return jButton;
    }

    private boolean hasCircuits(BlsrModel blsrModel) {
        TdmLineModel tdmLineModel;
        TdmLineModel tdmLineModel2;
        TdmLineModel tdmLineModel3;
        TdmLineModel tdmLineModel4;
        IEntityModel iEntityModel;
        block15: {
            block14: {
                block13: {
                    block12: {
                        iEntityModel = null;
                        tdmLineModel4 = null;
                        tdmLineModel3 = null;
                        tdmLineModel2 = null;
                        tdmLineModel = null;
                        try {
                            iEntityModel = blsrModel.getEastEntityModel();
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!db.on()) break block12;
                            db.println("AbstractCmsNoSuchEntityException caught.");
                        }
                    }
                    if (iEntityModel != null && iEntityModel instanceof TdmPortModel) {
                        tdmLineModel4 = ((TdmPortModel)iEntityModel).getTdmLineModel();
                    }
                    try {
                        iEntityModel = blsrModel.getWestEntityModel();
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) break block13;
                        db.println("AbstractCmsNoSuchEntityException caught.");
                    }
                }
                if (iEntityModel != null && iEntityModel instanceof TdmPortModel) {
                    tdmLineModel3 = ((TdmPortModel)iEntityModel).getTdmLineModel();
                }
                try {
                    iEntityModel = blsrModel.getEastProtectEntityModel();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block14;
                    db.println("AbstractCmsNoSuchEntityException caught.");
                }
            }
            if (iEntityModel != null && iEntityModel instanceof TdmPortModel) {
                tdmLineModel2 = ((TdmPortModel)iEntityModel).getTdmLineModel();
            }
            try {
                iEntityModel = blsrModel.getWestProtectEntityModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block15;
                db.println("AbstractCmsNoSuchEntityException caught.");
            }
        }
        if (iEntityModel != null && iEntityModel instanceof TdmPortModel) {
            tdmLineModel = ((TdmPortModel)iEntityModel).getTdmLineModel();
        }
        return this.hasConnections(tdmLineModel4) || this.hasConnections(tdmLineModel3) || this.hasConnections(tdmLineModel2) || this.hasConnections(tdmLineModel);
    }

    private boolean hasConnections(TdmLineModel tdmLineModel) {
        boolean bl;
        block4: {
            bl = false;
            if (tdmLineModel != null) {
                try {
                    List list = tdmLineModel.getConnectionsList();
                    if (list != null && list.size() > 0) {
                        bl = true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!SppRingPane.db.on) break block4;
                    db.println("IllegalArgumentException caught checking for connections on TdmLineModel: " + tdmLineModel);
                    SDebug.printStackTrace((Throwable)illegalArgumentException);
                }
            }
        }
        return bl;
    }

    private boolean isProtectionSwitched(BlsrModel blsrModel) {
        return blsrModel.getEastProtectionOp().kOp != eBlsrProtectionOp.BLSR_CMD_CLEAR && blsrModel.getEastProtectionOp().kOp != eBlsrProtectionOp.BLSR_CMD_APS_CLEAR || blsrModel.getWestProtectionOp().kOp != eBlsrProtectionOp.BLSR_CMD_CLEAR && blsrModel.getWestProtectionOp().kOp != eBlsrProtectionOp.BLSR_CMD_APS_CLEAR;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            String string = "The network level provisioning panel allows you to create\n";
            string = string + "a " + this.blsrTerm + " on multiple nodes at the same time and makes it much easier\n";
            string = string + "to get the East/West orientation setup correctly.  It is advisable\n";
            string = string + "to use this facility instead of provisioning the rings one node at a time.\n";
            IgnorableDialog.infoDialog((Component)((Object)this), (String)string, (String)"Suggestion", (String)IGNORABLE_CREATE_PREF, (String)IGNORABLE_SUGGEST_DESCR);
            if (SppRingPane.db.on) {
                db.println("showing BlsrCreationDialog...");
            }
            BlsrCreationDialog.instance(this, this.mayCreate4Fiber ? 0 : 1).show();
        } else {
            int n = this.table.getSelectedRow();
            if (n == -1) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_BLSR_NOT_SELECTED_PARAM_1, (Object)this.blsrTerm);
                return;
            }
            BlsrModel blsrModel = this.getBlsrModel(n);
            String string = blsrModel.getProvision().ringName;
            if (object == this.deletePB) {
                String string2 = "The network level provisioning panel allows you to delete\n";
                string2 = string2 + "all nodes in the " + this.blsrTerm + " at the same time.\n";
                string2 = string2 + "It is advisable to use this facility instead of deleting them one node at a time.\n";
                IgnorableDialog.infoDialog((Component)((Object)this), (String)string2, (String)"Suggestion", (String)IGNORABLE_DELETE_PREF, (String)IGNORABLE_SUGGEST_DESCR);
                if (this.isProtectionSwitched(blsrModel) && this.hasCircuits(blsrModel)) {
                    ErrorMsg.displayError(null, (EID)EMC.EID_BLSR_FAIL_DELETE_PROT_OP);
                } else {
                    String string3 = "Do you really want to delete the " + this.blsrTerm + " named " + string + "?\n";
                    boolean bl = false;
                    if (blsrModel.hasDriConnections()) {
                        string3 = string3 + "\nNOTE: There is at least one DRI connection on this " + this.blsrTerm + ".\n";
                        bl = true;
                    }
                    if (blsrModel.hasPCAConnections() && blsrModel.getType() == 3) {
                        string3 = string3 + "\nNOTE: There are PCA circuits which will become PARTIAL.\nif you delete this " + this.blsrTerm + ".  " + "All PCA traffic on this " + this.blsrTerm + " will be lost.\n";
                        bl = true;
                    }
                    if (bl) {
                        string3 = string3 + "\nAre you sure you want to continue? ";
                    }
                    if (CerentDialog.yesNoDialog((Component)((Object)this), (String)string3, (String)("Confirm " + this.blsrTerm + " Deletion"))) {
                        if (SppRingPane.db.on) {
                            db.println("deleting ring " + string);
                        }
                        try {
                            blsrModel.delete();
                        }
                        catch (Busy busy) {
                            ErrorMsg.displayError((Component)((Object)this), EMC.EID_BLSR_FAIL_DELETE_BUSY_PARAM_2, this.blsrTerm, this.hasCircuits(blsrModel) ? "currently carrying traffic" : "in use");
                        }
                        catch (CmsNodeUpgradingException cmsNodeUpgradingException) {
                            db.println("Error in deleting ring " + cmsNodeUpgradingException.toString());
                            SDebug.printStackTrace((Throwable)cmsNodeUpgradingException);
                            ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_NODE_UPGRADING_EXCEPTION, (Exception)((Object)cmsNodeUpgradingException));
                        }
                    }
                }
            } else if (object == this.ringMapPB) {
                if (SppRingPane.db.on) {
                    db.println("displaying ring map for ring " + string);
                }
                BlsrRingMapDialog.instance(this, blsrModel).show();
            } else if (object == this.squelchTablePB) {
                if (SppRingPane.db.on) {
                    db.println("displaying squelch table for ring " + string);
                }
                boolean bl = false;
                if (blsrModel != null) {
                    bl = blsrModel.getNodeModel().getTdmProtocolTypeObj().isSonet();
                }
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer("slot ");
                new SquelchTableDialog((JComponent)((Object)this), (IEntityCellRenderer)entityCellRenderer, (IBlsrModel)blsrModel, bl).show();
            } else if (object == this.ripTablePB) {
                if (SppRingPane.db.on) {
                    db.println("displaying rip table for ring " + string);
                }
                BlsrRipTblDialog.instance(this, db, blsrModel).show();
            } else if (object == this.upgradePB) {
                if (SppRingPane.db.on) {
                    db.println("upgrading 2F ring " + string);
                }
                String string4 = "The network level provisioning panel allows you to upgrade\n";
                string4 = string4 + "all nodes in a " + this.blsrTerm + " at the same time.\n";
                string4 = string4 + "It is advisable to use this facility instead of upgrading them one node at a time\n";
                IgnorableDialog.infoDialog((Component)((Object)this), (String)string4, (String)"Suggestion", (String)IGNORABLE_UPGRADE_PREF, (String)IGNORABLE_SUGGEST_DESCR);
                BlsrCreationDialog blsrCreationDialog = BlsrCreationDialog.instance(this, 2);
                blsrCreationDialog.setBlsrModel(blsrModel);
                blsrCreationDialog.show();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.createPB == null && this.deletePB == null) {
                this.init();
            }
            super.enteringPage();
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppRingPane;
    }
}

