/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.SonetTopology.eVtMode;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.UnableSwitchMode;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SppXcPane
extends NodeProvPane
implements ActionListener {
    private boolean initialized = false;
    private JPanel xcModePanel;
    private JPanel xcModeRbPanel;
    private eVtMode[] xcModeArray = null;
    private eVtMode selectedXcMode;
    private static final String sdh_LOPT_Label = "Low Order Payload Type";
    private static final String sonet_LOPT_Label = "VT Payload Type";
    private static String LOPT_Label;
    private JRadioButton[] xcModeRbs;
    private ButtonGroup xcModeRbGroup;
    private Vector xcModes;
    private String oldAction;
    private IChassisModel chassis = (IChassisModel)this.getUiModel();
    private boolean isUserAuthorized;
    private NodeModelDelegate nmd = (NodeModelDelegate)this.chassis.getNodeModel();
    protected static final SDebug db;

    public SppXcPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        LOPT_Label = this.chassis.getTdmProtocolTypeObj().isSdh() ? sdh_LOPT_Label : sonet_LOPT_Label;
        this.isUserAuthorized = this.isUserAuthorized(SecurityLevel.PROVISIONING);
    }

    public void enteringPage() throws Exception {
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        super.enteringPage();
    }

    private void init() {
        if (db.on()) {
            db.println("Entering the init() Method");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.createLoptPanel(), gridBagConstraints);
        if (this.nmd != null) {
            this.nmd.addObserver((Observer)((Object)this));
        }
        if (this.chassis != null) {
            this.chassis.addObserver((Observer)((Object)this));
        }
        if (db.on()) {
            db.println("Exiting the init() Method");
        }
    }

    public void dispose() {
        if (db.on()) {
            db.println("dispose() called");
        }
        if (this.initialized) {
            if (this.chassis != null) {
                this.chassis.deleteObserver((Observer)((Object)this));
            }
            if (this.nmd != null) {
                this.nmd.deleteObserver((Observer)((Object)this));
            }
        }
        super.dispose();
        this.initialized = false;
    }

    private JPanel createLoptPanel() {
        if (db.on()) {
            db.println("CreatdLoptPanel, creating radio buttons.");
        }
        this.xcModePanel = new JPanel(new FlowLayout(0));
        this.xcModePanel.setBorder(BorderFactory.createTitledBorder(LOPT_Label));
        this.xcModeArray = new eVtMode[4];
        this.xcModeArray[0] = eVtMode.VT1_MODE;
        this.xcModeArray[1] = eVtMode.VT2_MODE;
        this.xcModeArray[2] = eVtMode.VT1_VT2_MODE;
        this.xcModeArray[3] = eVtMode.VT1_VT2_MODE;
        this.xcModes = this.createXcModeVector(this.xcModeArray);
        this.xcModeRbGroup = new ButtonGroup();
        this.xcModeRbs = new JRadioButton[this.xcModes.size()];
        String string = "";
        for (int i = 0; i < this.xcModes.size(); ++i) {
            string = ((XCMode)this.xcModes.get(i)).toString();
            this.xcModeRbs[i] = new JRadioButton(string);
            this.xcModeRbGroup.add(this.xcModeRbs[i]);
            this.xcModeRbs[i].setActionCommand(string);
            this.xcModeRbs[i].addActionListener(this);
            this.xcModePanel.add(this.xcModeRbs[i]);
        }
        this.xcModeRbs[this.xcModes.size() - 1].setVisible(false);
        return this.xcModePanel;
    }

    private Vector createXcModeVector(eVtMode[] eVtModeArray) {
        Vector<XCMode> vector = new Vector<XCMode>(eVtModeArray.length);
        for (int i = 0; i < eVtModeArray.length; ++i) {
            vector.add(new XCMode(eVtModeArray[i]));
        }
        return vector;
    }

    private void initRB() {
        if (db.on()) {
            db.println("initRB() callled");
        }
        if (this.chassis != null) {
            int n;
            IPlatform iPlatform = this.chassis.getPlatform();
            boolean bl = false;
            int[] nArray = iPlatform.getSupportedXcCardEqTypes();
            for (n = 0; n < nArray.length; ++n) {
                if (this.chassis.getDescendantsOfEqType(nArray[n]).size() <= 0) continue;
                bl = true;
            }
            if (iPlatform.hasXcMixedMode(this.chassis)) {
                this.xcModeRbs[0].setEnabled(true);
                this.xcModeRbs[1].setEnabled(true);
                this.xcModeRbs[2].setEnabled(true);
                try {
                    this.selectedXcMode = this.nmd.getLopXcMode();
                }
                catch (CTCUserException cTCUserException) {
                    ErrorMsg.displayError(null, (EID)EMC.EID_NO_RTRV_LO_XC_MODE);
                    return;
                }
                for (n = 0; n < this.xcModes.size(); ++n) {
                    if (this.selectedXcMode != this.xcModeArray[n]) continue;
                    this.oldAction = this.xcModeRbs[n].getActionCommand();
                    this.xcModeRbs[n].setSelected(true);
                    if (db.on()) {
                        db.println("[XCVXC card] selectedXcMode = " + n);
                    }
                    break;
                }
            } else {
                if (!bl) {
                    for (n = 0; n < this.xcModeRbs.length; ++n) {
                        this.xcModeRbs[n].setSelected(false);
                        this.xcModeRbs[n].setEnabled(false);
                    }
                    this.xcModeRbs[this.xcModeRbs.length - 1].setSelected(true);
                    this.setDirty(false);
                    return;
                }
                if (((EntityModel)((Object)this.chassis)).getDescendantsOfType(eEqType.XC_CARD).size() > 0) {
                    this.xcModeRbs[0].setEnabled(false);
                    this.xcModeRbs[1].setEnabled(false);
                    if (db.on() && this.selectedXcMode != null) {
                        db.println("[XC card] selectedXcMode = " + this.selectedXcMode.value());
                    }
                } else {
                    if (this.chassis.getTdmProtocolTypeObj().isSdh()) {
                        if (((EntityModel)((Object)this.chassis)).getDescendantsOfType(eEqType.XCVXL_CARD).size() > 0 || ((EntityModel)((Object)this.chassis)).getDescendantsOfType(eEqType.XCVXL25G_CARD).size() > 0) {
                            this.xcModeRbs[0].setEnabled(false);
                            this.xcModeRbs[1].setSelected(true);
                            this.xcModeRbs[1].setEnabled(false);
                        } else {
                            this.xcModeRbs[0].setSelected(false);
                            this.xcModeRbs[0].setEnabled(false);
                            this.xcModeRbs[1].setSelected(false);
                            this.xcModeRbs[1].setEnabled(false);
                        }
                    } else {
                        this.xcModeRbs[0].setSelected(true);
                        this.xcModeRbs[1].setEnabled(false);
                    }
                    if (db.on() && this.selectedXcMode != null) {
                        db.println("[Non XC/XCVXC cards] selectedXcMode = " + this.selectedXcMode.value());
                    }
                }
                this.xcModeRbs[2].setSelected(false);
                this.xcModeRbs[2].setEnabled(false);
            }
            if (!this.isUserAuthorized) {
                this.xcModeRbs[0].setEnabled(false);
                this.xcModeRbs[1].setEnabled(false);
                this.xcModeRbs[2].setEnabled(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (db.on()) {
            db.println("actionPerformed() callled: new action " + string);
        }
        if (this.oldAction == null || string.equals(this.oldAction)) {
            return;
        }
        for (int i = 0; i < this.xcModes.size(); ++i) {
            if (!string.equals(((XCMode)this.xcModes.get(i)).toString())) continue;
            this.oldAction = string;
            this.selectedXcMode = this.xcModeArray[i];
            this.setDirty();
        }
    }

    public void applyChangesToModel() throws Exception {
        XCMode xCMode = new XCMode(this.selectedXcMode);
        if (db.on()) {
            db.println("Change mode to: " + xCMode);
        }
        try {
            this.nmd.setLopXcMode(this.selectedXcMode);
        }
        catch (UnableSwitchMode unableSwitchMode) {
            StringBuffer stringBuffer = new StringBuffer("The cross-connect mode could not be switched because ");
            if (xCMode.eVtModeValue() == eVtMode.VT1_VT2_MODE) {
                stringBuffer.append("the circuits currently provisioned are using more than 50% of the " + this.oldAction + " matrix ports.\n");
            } else {
                int n = xCMode.eVtModeValue() == eVtMode.VT1_MODE ? 1 : 0;
                stringBuffer.append("there are " + this.xcModes.get(n) + " circuits provisioned.\n");
                stringBuffer.append("This switch command can only occur if there are no " + this.xcModes.get(n) + " circuit provisioned on the cross-connect(s).");
            }
            ErrorMsg.displayDetailed(null, EMC.EID_NO_SWITCH_LO_XC_MODE_1, xCMode, stringBuffer.toString());
            this.refresh();
        }
        catch (CTCUserException cTCUserException) {
            ErrorMsg.displayError(null, (EID)EMC.EID_NO_SWITCH_LO_XC_MODE_1, (Object)xCMode);
            this.refresh();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.initRB();
        }
    }

    public void refreshFromModel() throws Exception {
        this.initRB();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppXcPane;
    }

    static {
        db = new SDebug("SppXcPane");
    }

    private class XCMode {
        private eVtMode xcMode;

        public XCMode(eVtMode eVtMode2) {
            this.xcMode = eVtMode2;
        }

        public int value() {
            return this.xcMode.value();
        }

        public eVtMode eVtModeValue() {
            return this.xcMode;
        }

        public String toString() {
            String string;
            TDMTerminology tDMTerminology = SppXcPane.this.chassis.getTDMTerminology();
            try {
                switch (this.xcMode.value()) {
                    case 0: {
                        string = tDMTerminology.getVirtualContainerTerm(4);
                        break;
                    }
                    case 1: {
                        string = tDMTerminology.getVirtualContainerTerm(3);
                        break;
                    }
                    case 2: {
                        string = tDMTerminology.getVirtualContainerTerm(4) + " & " + tDMTerminology.getVirtualContainerTerm(3) + " (Mixed Mode)";
                        break;
                    }
                    default: {
                        string = "";
                        break;
                    }
                }
            }
            catch (Exception exception) {
                string = "";
            }
            return string;
        }
    }
}

