/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.OSI.eLapdMode;
import cerent.cms.idl.OSI.sLapdTerm;
import cerent.cms.idl.OSI.sRouter;
import cerent.cms.idl.OSI.sSubnet;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.helper.OsiHelper;
import cerent.cms.ui.shelf.AbstractTermPane;
import cerent.cms.ui.shelf.TermRowObject;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.MultiLineLabelUI;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.plaf.LabelUI;
import javax.swing.table.DefaultTableCellRenderer;

public class TermColumnRenderer
extends AbstractColumnRenderer {
    public static final int PORT_INDEX = 0;
    public static final int OSPF_ADVERTISE_INDEX = 1;
    public static final int FAR_END_FOREIGN = 2;
    public static final int FAR_END_IP_ADDR = 3;
    public static final int SERVICE_STATE_INDEX = 4;
    public static final int LAPD_INDEX = 5;
    public static final int SUBNET_INDEX = 6;
    public static final int RATE_INDEX = 7;
    public static final int OSC_SRV_STATE_INDEX = 1;
    public static final int OSC_SUBNET_INDEX = 3;
    public static final int OSC_LAPD_INDEX = 2;
    public static final String[] columnNames = new String[]{"Port", "OSPF Disabled on Link", "Foreign", "Foreign IP", "Port Service State", "LAPD Termination", "OSI SNPA", "GCC Rate"};
    public static final String[] oscColumnNames = new String[]{"Port", "Service State", "LAPD Termination", "OSI SNPA"};
    private static final int[] columnWidths = new int[]{160, 140, 50, 110, 270, 140, 200, 80};
    private static final int[] oscColumnWidths = new int[]{60, 120, 140, 200};
    public static final EntityCellRenderer ecr = new EntityCellRenderer("slot ");
    private TDMTerminology tdmTerm;
    private eTCRendererType type;
    private DefaultTableCellRenderer cellRenderer = new OhTermCellRenderer();
    private int mode;
    private NodeModelDelegate nmd;
    private static final int SINGLE_ROW_HEIGHT = 20;
    protected static final String CK_IMG_PATH = "/images/check_blue.gif";
    protected static final Icon CK_IMG = WindowHelper.getIcon(TermColumnRenderer.class, (String)"/images/check_blue.gif", (String)"yes");
    private static final SDebug db = new SDebug("TermColumnRenderer");

    public TermColumnRenderer(int n, String string, int n2, boolean bl, int n3, TDMTerminology tDMTerminology, eTCRendererType eTCRendererType2) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.tdmTerm = tDMTerminology;
        this.type = eTCRendererType2;
        this.cellRenderer.setUI((LabelUI)new MultiLineLabelUI());
        this.cellRenderer.setForeground(null);
        this.cellRenderer.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        TermRowObject termRowObject = (TermRowObject)object;
        Object object2 = null;
        if (termRowObject != null) {
            object2 = this.getTermField((OhTermModel)termRowObject.model, this.mode);
        }
        return this.cellRenderer.getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
    }

    public static ColumnRenderer[] createColumnRenderers(TDMTerminology tDMTerminology, eTCRendererType eTCRendererType2) {
        int n = eTCRendererType2 == eTCRendererType.OSC ? oscColumnNames.length : columnNames.length;
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[n];
        for (int i = 0; i < n; ++i) {
            columnRendererArray[i] = new TermColumnRenderer(i, eTCRendererType2 == eTCRendererType.OSC ? oscColumnNames[i] : columnNames[i], eTCRendererType2 == eTCRendererType.OSC ? oscColumnWidths[i] : columnWidths[i], true, 0, tDMTerminology, eTCRendererType2);
        }
        return columnRendererArray;
    }

    private static String asString(sIpAddr sIpAddr2) {
        return InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sIpAddr2));
    }

    public static String getFarEndIpAddress(OhTermModel ohTermModel) {
        String string;
        block3: {
            string = "";
            try {
                if (ohTermModel.isFarEndForeign()) {
                    string = TermColumnRenderer.asString(ohTermModel.getFarEndIpAddress());
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        return string;
    }

    public int compareColumn(Object object, Object object2, int n) {
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        TermRowObject termRowObject = (TermRowObject)object;
        TermRowObject termRowObject2 = (TermRowObject)object2;
        Object object3 = this.getTermField((OhTermModel)termRowObject.model, n);
        Object object4 = this.getTermField((OhTermModel)termRowObject2.model, n);
        String string = "N/A";
        String string2 = "N/A";
        if (object3 != null) {
            string = object3.toString();
        }
        if (object4 != null) {
            string2 = object3.toString();
        }
        return string.compareTo(string2);
    }

    private Object getTermField(OhTermModel ohTermModel, int n) {
        if (this.nmd == null) {
            this.nmd = ohTermModel.getNodeModelDelegate();
        }
        if (this.type == eTCRendererType.OSC) {
            return this.getOscTermField(ohTermModel, n);
        }
        return this.getOhTermField(ohTermModel, n);
    }

    private Object getOhTermField(OhTermModel ohTermModel, int n) {
        PortModel portModel = null;
        try {
            portModel = (PortModel)ohTermModel.getOpticalPortModel();
        }
        catch (NullPointerException nullPointerException) {
            db.fine("Null value in renderer");
            return null;
        }
        sLapdTerm sLapdTerm2 = null;
        sLapdTerm2 = this.nmd.getLapdModel().getLapdByIndex(portModel.getEntityIndex());
        if (sLapdTerm2 == null) {
            db.info("No LapdTerm for " + portModel.getEntityIndex());
        }
        switch (n) {
            case 0: {
                return portModel;
            }
            case 1: {
                try {
                    return new Boolean(!ohTermModel.isOspfEnable());
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    return Boolean.FALSE;
                }
            }
            case 2: {
                if (sLapdTerm2 != null) {
                    return "N/A";
                }
                try {
                    return new Boolean(ohTermModel.isFarEndForeign());
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    return Boolean.FALSE;
                }
            }
            case 3: {
                return TermColumnRenderer.getFarEndIpAddress(ohTermModel);
            }
            case 4: {
                return this.getServiceState(portModel);
            }
            case 7: {
                if (ohTermModel.getChannelType() == 0 || ohTermModel.getChannelType() == 10) {
                    return this.getAttributeKey("declDwdmGccRate", 0);
                }
                if (ohTermModel.getChannelType() == 4) {
                    return this.getAttributeKey("declDwdmGccRate", 1);
                }
            }
            case 5: {
                return sLapdTerm2;
            }
            case 6: {
                try {
                    this.nmd = ohTermModel.getNodeModelDelegate();
                    sSubnet sSubnet2 = this.nmd.getSubnetModel().getSubnetByIndex(portModel.getEntityIndex());
                    return sSubnet2;
                }
                catch (Exception exception) {
                    db.info("Unexpected error when getting Subnet: " + exception);
                    return null;
                }
            }
        }
        return null;
    }

    public Object getOscTermField(OhTermModel ohTermModel, int n) {
        PortModel portModel = null;
        try {
            portModel = (PortModel)ohTermModel.getOpticalPortModel();
        }
        catch (NullPointerException nullPointerException) {
            db.fine("Null value in renderer");
            return null;
        }
        switch (n) {
            case 0: {
                return portModel;
            }
            case 1: {
                return this.getServiceState(portModel);
            }
            case 2: {
                sLapdTerm sLapdTerm2 = ohTermModel.getNodeModelDelegate().getLapdModel().getLapdByIndex(portModel.getEntityIndex());
                return sLapdTerm2;
            }
            case 3: {
                sSubnet sSubnet2 = null;
                try {
                    sSubnet2 = ohTermModel.getNodeModelDelegate().getSubnetModel().getSubnetByIndex(portModel.getEntityIndex());
                }
                catch (Exception exception) {
                    db.info("Unexpected error when getting Subnet: " + exception);
                }
                return sSubnet2;
            }
        }
        return null;
    }

    protected String getServiceState(PortModel portModel) {
        String string = "";
        String string2 = "";
        if (portModel != null) {
            try {
                string = this.tdmTerm.getTermForServiceState(portModel.getServiceStateType());
            }
            catch (NoSuchInterface noSuchInterface) {
                db.info("port.getServiceStateType() failed: " + (Object)((Object)noSuchInterface));
            }
            PortModel portModel2 = AbstractTermPane.getProtectPort(portModel, db);
            if (portModel2 != null) {
                try {
                    string2 = this.tdmTerm.getTermForServiceState(portModel2.getServiceStateType());
                }
                catch (NoSuchInterface noSuchInterface) {
                    db.info("protectPort.getServiceStateType() failed: " + (Object)((Object)noSuchInterface));
                }
            }
        }
        if (string2.length() > 0) {
            return string + " (Working)  " + string2 + " (Protect) ";
        }
        return string;
    }

    private String getAttributeKey(String string, int n) {
        Attribute attribute = ElementDefaults.getAttributeMap(this.nmd).getAttributeForVal(string, n);
        return attribute != null ? attribute.getKey() : null;
    }

    protected class OhTermCellRenderer
    extends DefaultTableCellRenderer {
        final JLabel checkedLabel = new JLabel(CK_IMG);
        final JLabel emptyLabel = new JLabel("");
        final JTextArea lapdTA = new JTextArea("N/A");
        final JTextArea subnetTA = new JTextArea("N/A");
        final JTextArea naTA = new JTextArea("N/A");

        public OhTermCellRenderer() {
            this.checkedLabel.setOpaque(true);
            this.emptyLabel.setOpaque(true);
        }

        private JLabel getBooleanLabel(boolean bl, JTable jTable, boolean bl2) {
            JLabel jLabel;
            JLabel jLabel2 = jLabel = bl ? this.checkedLabel : this.emptyLabel;
            if (bl2) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(Color.white);
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(Color.black);
            }
            return jLabel;
        }

        protected JTextArea getLapdAttr(JTable jTable, int n, sLapdTerm sLapdTerm2, boolean bl) {
            if (sLapdTerm2 == null) {
                this.lapdTA.setText("N/A");
            } else {
                String string = (sLapdTerm2.acknowledged ? "AITS" : "UITS") + ", " + (sLapdTerm2.mode == eLapdMode.LAPD_MODE_NETWORK ? "Network" : "User") + ", MTU: " + sLapdTerm2.mtu;
                if (sLapdTerm2.acknowledged) {
                    string = string + "\nT200: " + sLapdTerm2.t200 + ", T203: " + sLapdTerm2.t203;
                }
                this.lapdTA.setText(string);
            }
            int n2 = this.lapdTA.getPreferredSize().height;
            if (jTable.getRowHeight(n) < n2) {
                jTable.setRowHeight(n, n2);
            }
            if (bl) {
                this.lapdTA.setBackground(jTable.getSelectionBackground());
                this.lapdTA.setForeground(jTable.getSelectionForeground());
            } else {
                this.lapdTA.setBackground(jTable.getBackground());
                this.lapdTA.setForeground(jTable.getForeground());
            }
            return this.lapdTA;
        }

        protected JTextArea getSubnetAttr(JTable jTable, int n, sSubnet sSubnet2, boolean bl) {
            if (sSubnet2 == null) {
                this.subnetTA.setText("N/A");
            } else {
                sRouter sRouter2 = TermColumnRenderer.this.nmd.getRouterModel().getRouter(sSubnet2.routerNumber);
                this.subnetTA.setText(OsiHelper.getRouterId((short)sRouter2.routerNumber, (byte[])sRouter2.addrList[0], (byte[])sRouter2.sysId) + "\nRouter State: " + (sRouter2.enabled ? "Enabled" : "Disabled"));
            }
            int n2 = this.subnetTA.getPreferredSize().height;
            if (jTable.getRowHeight(n) < n2) {
                jTable.setRowHeight(n, n2);
            }
            if (bl) {
                this.subnetTA.setBackground(jTable.getSelectionBackground());
                this.subnetTA.setForeground(jTable.getSelectionForeground());
            } else {
                this.subnetTA.setBackground(jTable.getBackground());
                this.subnetTA.setForeground(jTable.getForeground());
            }
            return this.subnetTA;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            block19: {
                block18: {
                    if (TermColumnRenderer.this.type != eTCRendererType.OSC) break block18;
                    switch (n2) {
                        case 0: {
                            PortModel portModel = (PortModel)object;
                            if (portModel != null) {
                                if (TermColumnRenderer.this.nmd.isMultishelf()) {
                                    object = ecr.getString(portModel, "shelf ");
                                    break;
                                }
                                object = ecr.getString(portModel, "slot ");
                                break;
                            }
                            break block19;
                        }
                        case 2: {
                            sLapdTerm sLapdTerm2 = (sLapdTerm)object;
                            return this.getLapdAttr(jTable, n, sLapdTerm2, bl);
                        }
                        case 3: {
                            sSubnet sSubnet2 = (sSubnet)object;
                            return this.getSubnetAttr(jTable, n, sSubnet2, bl);
                        }
                    }
                    break block19;
                }
                switch (n2) {
                    case 0: {
                        PortModel portModel = (PortModel)object;
                        if (portModel == null) break;
                        if (TermColumnRenderer.this.nmd.isMultishelf()) {
                            object = ecr.getString(portModel, "shelf ");
                            break;
                        }
                        object = ecr.getString(portModel, "slot ");
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (object instanceof Boolean) {
                            Boolean bl3 = (Boolean)object;
                            if (bl3 == null) break;
                            return this.getBooleanLabel(bl3, jTable, bl);
                        }
                        if (bl) {
                            this.naTA.setBackground(jTable.getSelectionBackground());
                            this.naTA.setForeground(jTable.getSelectionForeground());
                        } else {
                            this.naTA.setBackground(jTable.getBackground());
                            this.naTA.setForeground(jTable.getForeground());
                        }
                        return this.naTA;
                    }
                    case 3: 
                    case 4: 
                    case 7: {
                        break;
                    }
                    case 5: {
                        sLapdTerm sLapdTerm3 = (sLapdTerm)object;
                        return this.getLapdAttr(jTable, n, sLapdTerm3, bl);
                    }
                    case 6: {
                        sSubnet sSubnet3 = (sSubnet)object;
                        return this.getSubnetAttr(jTable, n, sSubnet3, bl);
                    }
                }
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    public static class eTCRendererType {
        private static final int _NORMAL = 0;
        private static final int _GCC = 1;
        private static final int _OSC = 2;
        public static final eTCRendererType NORMAL = new eTCRendererType(0);
        public static final eTCRendererType GCC = new eTCRendererType(1);
        public static final eTCRendererType OSC = new eTCRendererType(2);
        private int _type;

        public eTCRendererType(int n) {
            this._type = n;
        }
    }
}

