/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Node.xMaxTunnels;
import cerent.cms.idl.Node.xTunnelExists;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.TunnelsModel;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.TunnelsDataSource;
import cerent.cms.ui.shelf.TunnelsDialog;
import cerent.util.CEMC;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class TunnelsPane
extends ObserverPane
implements Observer {
    private static final String CREATE = "Create...";
    private static final String DELETE = "Delete...";
    private CSHelpID _csHelpKey;
    private TunnelsInfo _dsc;
    private JButton createButton;
    private JButton deleteButton;
    private JPanel buttonRow;
    private UScrollPane tunnelSP;

    public TunnelsPane(String string, CSHelpID cSHelpID, TabbedView tabbedView, TunnelsModel tunnelsModel) {
        super(string, tabbedView);
        this._csHelpKey = cSHelpID;
        this._dsc = new TunnelsInfo(tunnelsModel);
        this.setDataSourceControl(this._dsc);
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.destroy();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.leavingPage();
    }

    private void setTable(JTable jTable) {
        this.table = jTable;
    }

    public void update(Observable observable, Object object) {
        this.requestRefresh(observable, null);
        this.manageButtons();
    }

    private void manageButtons() {
        this.createButton.setEnabled(this.isUserAuthorized());
        this.deleteButton.setEnabled(this.isUserAuthorized() && this._dsc.isSelected());
    }

    private class TunnelsInfo
    extends AbstractDataSourceControl {
        private TunnelsModel _model;
        private ObservableManager _om;
        private TunnelsDataSource _ds;
        private SortableRowTableModel _tm;
        private Thread _updater;
        private boolean _needsUpdate;

        TunnelsInfo(TunnelsModel tunnelsModel) {
            this._model = tunnelsModel;
            this._om = new ObservableManager(TunnelsPane.this, true);
            this._ds = null;
            this._tm = null;
            this._updater = null;
            this._needsUpdate = false;
        }

        private synchronized boolean needsUpdate() {
            if (this._needsUpdate) {
                if (db.on()) {
                    db.println("updater starting update");
                }
                this._needsUpdate = false;
                return true;
            }
            return false;
        }

        private void doUpdate() {
            try {
                this._ds.refreshFromModel(this._tm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void refreshFromModel() {
            if (db.on()) {
                db.println("refreshFromModel()");
            }
            this._needsUpdate = true;
            if (this._updater == null) {
                this._updater = new Thread(new Runnable(){

                    public void run() {
                        TunnelsPane.this.uiToolkit.setSBText("Loading tunnels...");
                        while (TunnelsInfo.this.needsUpdate()) {
                            TunnelsInfo.this.doUpdate();
                        }
                        TunnelsInfo.this._updater = null;
                        TunnelsPane.this.uiToolkit.setSBText("");
                        if (db.on()) {
                            db.println("updater done");
                        }
                    }
                });
                if (db.on()) {
                    db.println("updater created");
                }
                this._updater.start();
            }
        }

        public void refreshFromModel(int n) {
            if (n == -1) {
                this.initUi();
            }
            this.refreshFromModel();
        }

        public void applyToModel() {
        }

        public IObservableManager getObservableManager() {
            return this._om;
        }

        public void disposeDataSource() {
            this._om.removeObservable((Observable)((Object)this._model));
        }

        boolean isSelected() {
            return TunnelsPane.this.getTable().getSelectedRowCount() > 0;
        }

        TunnelsDataSource.TunnelInfo[] getSelected() {
            JTable jTable = TunnelsPane.this.getTable();
            int[] nArray = jTable.getSelectedRows();
            if (nArray != null && nArray.length > 0) {
                TunnelsDataSource.TunnelInfo[] tunnelInfoArray = new TunnelsDataSource.TunnelInfo[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    tunnelInfoArray[i] = (TunnelsDataSource.TunnelInfo)this._tm.getValueAt(nArray[i], 0);
                }
                return tunnelInfoArray;
            }
            return null;
        }

        UScrollPane initTable() {
            this._om.addObservable((Observable)((Object)this._model));
            this._ds = new TunnelsDataSource(this._model);
            this._tm = new SortableRowTableModel((RowDataSource)this._ds, this._ds.getRenderers(), this._ds.getRowObjectClass());
            TunnelsPane.this.setTable((JTable)new UTable((TableModel)((Object)this._tm)));
            this._tm.initTable(TunnelsPane.this.getTable());
            ListSelectionModel listSelectionModel = TunnelsPane.this.getTable().getSelectionModel();
            listSelectionModel.setSelectionMode(2);
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        TunnelsPane.this.manageButtons();
                    }
                }
            });
            return new UScrollPane((Component)TunnelsPane.this.getTable());
        }

        void initUi() {
            TunnelsPane.this.setLayout(new BorderLayout());
            TunnelsPane.this.buttonRow = AbstractPane.createHorizontalPanel(null);
            TunnelsPane.this.buttonRow.setLayout(new BorderLayout());
            TunnelsPane.this.tunnelSP = this.initTable();
            TunnelsPane.this.createButton = new JButton(TunnelsPane.CREATE);
            TunnelsPane.this.createButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TunnelsInfo.this.createTunnel();
                }
            });
            TunnelsPane.this.deleteButton = new JButton(TunnelsPane.DELETE);
            TunnelsPane.this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TunnelsInfo.this.deleteTunnel();
                }
            });
            TunnelsPane.this.manageButtons();
            JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel.add(TunnelsPane.this.createButton);
            jPanel.add(TunnelsPane.this.deleteButton);
            jPanel2.add(new CSHelpButton(TunnelsPane.this._csHelpKey));
            TunnelsPane.this.buttonRow.add((Component)jPanel, "Center");
            TunnelsPane.this.buttonRow.add((Component)jPanel2, "East");
            TunnelsPane.this.add((Component)TunnelsPane.this.tunnelSP, "Center");
            TunnelsPane.this.add(TunnelsPane.this.buttonRow, "South");
        }

        private void createTunnel() {
            block5: {
                TunnelsDialog tunnelsDialog = TunnelsDialog.instance(TunnelsPane.this);
                tunnelsDialog.show();
                if (tunnelsDialog.ok()) {
                    try {
                        this._model.addTunnel(tunnelsDialog.getTunnel());
                    }
                    catch (xTunnelExists xTunnelExists2) {
                        ErrorMsg.displayDetailed((Component)((Object)tunnelsDialog), EMC.EID_PROVISION_ERROR, "Failed to add new tunnel:\n  This tunnel already exists.");
                    }
                    catch (xMaxTunnels xMaxTunnels2) {
                        ErrorMsg.displayDetailed((Component)((Object)tunnelsDialog), EMC.EID_PROVISION_ERROR, "Failed to add new tunnel:\n  No more tunnels can be added.");
                    }
                    catch (Exception exception) {
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                        if (!(exception instanceof CmsNodeUpgradingException)) break block5;
                        ErrorMsg.displayDetailed((Component)((Object)TunnelsPane.this), CEMC.EID_NODE_UPGRADING_EXCEPTION, exception);
                    }
                }
            }
        }

        private void deleteTunnel() {
            TunnelsDataSource.TunnelInfo[] tunnelInfoArray = this.getSelected();
            if (tunnelInfoArray != null && tunnelInfoArray.length > 0 && CerentDialog.yesNoDialog((Component)((Object)TunnelsPane.this), (String)("Are you sure you want to delete the selected " + TunnelsPane.this.getName().toLowerCase() + " " + PluralisationUtil.s("tunnel", tunnelInfoArray.length) + "?"), (String)"Confirmation Dialog")) {
                for (int i = 0; i < tunnelInfoArray.length; ++i) {
                    this._model.deleteTunnel(tunnelInfoArray[i].getTunnel());
                }
            }
        }
    }
}

