/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Optics.sOChEqualizationAttributes;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.shelf.IXAssisChartElement;
import cerent.util.SDebug;

public class XAssisChartElements
implements IXAssisChartElement {
    protected static final SDebug db = new SDebug("OchsPwrMonitoringModel");
    private double[] xvalues;
    private String[] pointLabels;
    private String[] seriesLabels;
    public final int ADD;
    public final int PT;
    public final int OUT;
    private final int wavelengths;
    private final int bandCType;
    private final int mun_of_pt;

    private XAssisChartElements(int n, int n2) {
        this(n, n2, 2, false);
    }

    private XAssisChartElements(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    private XAssisChartElements(int n, int n2, int n3, boolean bl) {
        int n4;
        if (n3 > 2) {
            if (bl) {
                this.OUT = 0;
                this.ADD = 1;
                this.PT = 2;
            } else {
                this.ADD = 0;
                this.PT = 1;
                this.OUT = n3 + 1;
            }
            this.mun_of_pt = n3;
        } else {
            if (bl) {
                this.OUT = 0;
                this.ADD = 1;
                this.PT = 2;
            } else {
                this.ADD = 0;
                this.PT = 1;
                this.OUT = 2;
            }
            this.mun_of_pt = 1;
        }
        this.wavelengths = n;
        this.bandCType = n2;
        this.xvalues = new double[this.wavelengths];
        this.pointLabels = new String[this.wavelengths];
        this.seriesLabels = new String[this.mun_of_pt + 2];
        for (n4 = 1; n4 <= this.wavelengths; ++n4) {
            this.xvalues[n4 - 1] = n4;
            this.pointLabels[n4 - 1] = String.valueOf(n4);
        }
        this.seriesLabels[this.ADD] = "ADD";
        this.seriesLabels[this.OUT] = "OUT";
        if (this.mun_of_pt > 1) {
            for (n4 = 1; n4 <= this.mun_of_pt; ++n4) {
                this.seriesLabels[this.PT + n4 - 1] = DwdmSide.getSideFromOffset(n4);
            }
        } else {
            this.seriesLabels[this.PT] = "PT";
        }
    }

    public int getChannel() {
        return this.mun_of_pt + 2;
    }

    public int getWavelengths() {
        return this.wavelengths;
    }

    public double[] getXvalues() {
        return this.xvalues;
    }

    public String[] getPointLabels() {
        return this.pointLabels;
    }

    public String[] getSeriesLabels() {
        return this.seriesLabels;
    }

    public void fillValues(sOChEqualizationAttributes[] sOChEqualizationAttributesArray, double[][] dArray, int n) {
        int n2 = -1;
        for (int i = 0; i < sOChEqualizationAttributesArray.length; ++i) {
            if (n == 1) {
                n2 = Wavelength.getLambdaLChannelOffset(sOChEqualizationAttributesArray[i].lambdaId.value(), this.wavelengths);
            } else if (n == 0) {
                switch (this.bandCType) {
                    case 0: {
                        n2 = Wavelength.getLambdaCChannelOffset(sOChEqualizationAttributesArray[i].lambdaId.value(), this.wavelengths);
                        break;
                    }
                    case 1: {
                        n2 = Wavelength.getLambdaCEChannelOffset(sOChEqualizationAttributesArray[i].lambdaId.value(), this.wavelengths);
                    }
                }
            }
            if (db.on()) {
                db.print("Lambda Offset:" + n2);
            }
            if (sOChEqualizationAttributesArray[i].addPower != -1000000 && (double)sOChEqualizationAttributesArray[i].addPower / 10.0 > -25.0) {
                dArray[this.ADD][n2] = (double)sOChEqualizationAttributesArray[i].addPower / 10.0;
            }
            if (sOChEqualizationAttributesArray[i].passThroughPower != -1000000 && (double)sOChEqualizationAttributesArray[i].passThroughPower / 10.0 > -25.0) {
                int n3 = this.PT;
                if (this.mun_of_pt > 1) {
                    n3 += sOChEqualizationAttributesArray[i].side - 1;
                }
                dArray[n3][n2] = (double)sOChEqualizationAttributesArray[i].passThroughPower / 10.0;
            }
            if (sOChEqualizationAttributesArray[i].outputPower == -1000000 || !((double)sOChEqualizationAttributesArray[i].outputPower / 10.0 > -25.0)) continue;
            dArray[this.OUT][n2] = (double)sOChEqualizationAttributesArray[i].outputPower / 10.0;
        }
    }

    public static XAssisChartElements factoryCreate(int n, int n2) {
        switch (n) {
            case 191: 
            case 242: {
                return new XAssisChartElements(32, n2);
            }
            case 263: 
            case 267: {
                return new XAssisChartElements(40, n2);
            }
            case 266: 
            case 270: {
                return new XAssisChartElements(40, n2, 8);
            }
            case 294: 
            case 296: {
                return new XAssisChartElements(40, n2);
            }
            case 295: {
                return new XAssisChartElements(40, n2, 4, true);
            }
        }
        return null;
    }
}

